/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.unisms.config;

import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.provider.base.BaseProviderFactory;
import org.dromara.sms4j.unisms.config.UniConfig;
import org.dromara.sms4j.unisms.core.Uni;
import org.dromara.sms4j.unisms.service.UniSmsImpl;

public class UniFactory
implements BaseProviderFactory<UniSmsImpl, UniConfig> {
    private static UniSmsImpl uniSmsImpl;
    private static final UniFactory INSTANCE;

    private UniFactory() {
    }

    public static UniFactory instance() {
        return INSTANCE;
    }

    private void buildSms(UniConfig uniConfig) {
        if (uniConfig.getIsSimple().booleanValue()) {
            Uni.init(uniConfig.getAccessKeyId());
        } else {
            Uni.init(uniConfig.getAccessKeyId(), uniConfig.getAccessKeySecret());
        }
    }

    @Override
    public UniSmsImpl createSms(UniConfig uniConfig) {
        if (uniSmsImpl == null) {
            this.buildSms(uniConfig);
            uniSmsImpl = this.createMultitonSms(uniConfig);
        }
        return uniSmsImpl;
    }

    @Override
    public UniSmsImpl createMultitonSms(UniConfig config) {
        return new UniSmsImpl(config, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public UniSmsImpl refresh(UniConfig uniConfig) {
        this.buildSms(uniConfig);
        uniSmsImpl = new UniSmsImpl(uniConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return uniSmsImpl;
    }

    @Override
    public UniConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(UniConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new UniFactory();
    }

    private static final class ConfigHolder {
        private static UniConfig config = UniConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

