/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.tencent.utils;

import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.dromara.sms4j.comm.utils.SmsDateUtils;
import org.dromara.sms4j.tencent.config.TencentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentUtils {
    private static final Logger log = LoggerFactory.getLogger(TencentUtils.class);
    private static final String ALGORITHM = "TC3-HMAC-SHA256";
    private static final String HTTP_REQUEST_METHOD = "POST";

    private static byte[] hmac256(byte[] key, String msg) {
        HMac hMac = new HMac(HmacAlgorithm.HmacSHA256, key);
        return hMac.digest(msg);
    }

    private static String sha256Hex(String s) throws Exception {
        return DatatypeConverter.printHexBinary((byte[])DigestUtil.sha256((String)s)).toLowerCase();
    }

    public static String generateSignature(TencentConfig tencentConfig, String templateId, String[] messages, String[] phones, String timestamp) throws Exception {
        String date = SmsDateUtils.normDateGmt((Date)new Date(Long.parseLong(timestamp + "000")));
        String canonicalUri = "/";
        String canonicalQueryString = "";
        String canonicalHeaders = "content-type:application/json; charset=utf-8\nhost:" + tencentConfig.getRequestUrl() + "\n";
        String signedHeaders = "content-type;host";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("PhoneNumberSet", phones);
        params.put("SmsSdkAppId", tencentConfig.getSdkAppId());
        params.put("SignName", tencentConfig.getSignature());
        params.put("TemplateId", templateId);
        params.put("TemplateParamSet", messages);
        String payload = JSONUtil.toJsonStr(params);
        String hashedRequestPayload = TencentUtils.sha256Hex(payload);
        String canonicalRequest = "POST\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
        String credentialScope = date + "/" + tencentConfig.getService() + "/tc3_request";
        String hashedCanonicalRequest = TencentUtils.sha256Hex(canonicalRequest);
        String stringToSign = "TC3-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
        byte[] secretDate = TencentUtils.hmac256(("TC3" + tencentConfig.getAccessKeySecret()).getBytes(StandardCharsets.UTF_8), date);
        byte[] secretService = TencentUtils.hmac256(secretDate, tencentConfig.getService());
        byte[] secretSigning = TencentUtils.hmac256(secretService, "tc3_request");
        String signature = DatatypeConverter.printHexBinary((byte[])TencentUtils.hmac256(secretSigning, stringToSign)).toLowerCase();
        return "TC3-HMAC-SHA256 Credential=" + tencentConfig.getAccessKeyId() + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
    }

    public static Map<String, String> generateHeadsMap(String authorization, String timestamp, String action, String version, String territory, String requestUrl) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authorization);
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("Host", requestUrl);
        headers.put("X-TC-Action", action);
        headers.put("X-TC-Timestamp", timestamp);
        headers.put("X-TC-Version", version);
        headers.put("X-TC-Region", territory);
        return headers;
    }

    public static Map<String, Object> generateRequestBody(String[] phones, String sdkAppId, String signatureName, String templateId, String[] templateParamSet) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("PhoneNumberSet", phones);
        requestBody.put("SmsSdkAppId", sdkAppId);
        requestBody.put("SignName", signatureName);
        requestBody.put("TemplateId", templateId);
        requestBody.put("TemplateParamSet", templateParamSet);
        return requestBody;
    }
}

