/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.ctyun.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.sms4j.comm.utils.SmsDateUtils;
import org.dromara.sms4j.ctyun.config.CtyunConfig;

public class CtyunUtils {
    private static String signatureTime() {
        return SmsDateUtils.pureDateUtcGmt8((Date)new Date());
    }

    public static Map<String, String> signHeader(String body, String key, String secret) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(4);
        String signatureDate = SmsDateUtils.pureDateGmt8((Date)new Date());
        String signatureTime = CtyunUtils.signatureTime();
        String uuid = UUID.randomUUID().toString();
        String calculateContentHash = CtyunUtils.getSHA256(body);
        byte[] kTime = CtyunUtils.hmacSHA256(signatureTime.getBytes(), secret.getBytes());
        byte[] kAk = CtyunUtils.hmacSHA256(key.getBytes(), kTime);
        byte[] kDate = CtyunUtils.hmacSHA256(signatureDate.getBytes(), kAk);
        String signatureStr = String.format("ctyun-eop-request-id:%s\neop-date:%s\n", uuid, signatureTime) + "\n\n" + calculateContentHash;
        String signature = Base64.encode((byte[])CtyunUtils.hmacSHA256(signatureStr.getBytes(StandardCharsets.UTF_8), kDate));
        String signHeader = String.format("%s Headers=ctyun-eop-request-id;eop-date Signature=%s", key, signature);
        map.put("Content-Type", "application/json; charset=utf-8");
        map.put("ctyun-eop-request-id", uuid);
        map.put("Eop-date", signatureTime);
        map.put("Eop-Authorization", signHeader);
        return map;
    }

    public static String generateParamJsonStr(CtyunConfig ctyunConfig, String phone, String message, String templateId) {
        HashMap<String, String> paramMap = new HashMap<String, String>(5);
        paramMap.put("action", ctyunConfig.getAction());
        paramMap.put("phoneNumber", phone);
        paramMap.put("signName", ctyunConfig.getSignature());
        paramMap.put("templateParam", message);
        paramMap.put("templateCode", templateId);
        return JSONUtil.toJsonStr(paramMap);
    }

    private static String getSHA256(String text) {
        return DigestUtil.sha256Hex((String)text);
    }

    private static byte[] hmacSHA256(byte[] data, byte[] key) {
        return SecureUtil.hmacSha256((byte[])key).digest(data);
    }

    private CtyunUtils() {
    }
}

