/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.wildfly.jar;

import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SemanticVersionUtil;

public class WildflyJarUtils {
    public static final String BOOTABLE_JAR_GROUP_ID = "org.wildfly.plugins";
    public static final String BOOTABLE_JAR_ARTIFACT_ID = "wildfly-jar-maven-plugin";
    private static final int WILDLY_MAJOR_VERSION_SINCE_STARTUP_CHANGE = 25;
    private static final int WILDLY_MINOR_VERSION_SINCE_STARTUP_CHANGE = 0;
    public static final String DEFAULT_LIVENESS_PATH = "/health/live";
    public static final String DEFAULT_READINESS_PATH = "/health/ready";
    public static final String DEFAULT_STARTUP_PATH = "/health/started";

    private WildflyJarUtils() {
    }

    public static boolean isStartupEndpointSupported(JavaProject javaProject) {
        return SemanticVersionUtil.isVersionAtLeast((int)25, (int)0, (String)WildflyJarUtils.findWildflyVersion(javaProject));
    }

    static String findWildflyVersion(JavaProject javaProject) {
        return JKubeProjectUtil.getAnyDependencyVersionWithGroupId((JavaProject)javaProject, (String)BOOTABLE_JAR_GROUP_ID);
    }
}

