/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.wildfly.jar.generator;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class WildflyJARGenerator
extends JavaExecGenerator {
    static final String JBOSS_MAVEN_DIST = "jboss-maven-dist";
    static final String JBOSS_MAVEN_REPO = "jboss-maven-repo";
    static final String PLUGIN_OPTIONS = "plugin-options";
    final Path localRepoCache;

    public WildflyJARGenerator(GeneratorContext context) {
        super(context, "wildfly-jar");
        JavaProject project = context.getProject();
        Plugin plugin = JKubeProjectUtil.getPlugin((JavaProject)project, (String)"org.wildfly.plugins", (String)"wildfly-jar-maven-plugin");
        this.localRepoCache = Optional.ofNullable(plugin).map(Plugin::getConfiguration).map(c -> (Map)c.get(PLUGIN_OPTIONS)).map(options -> options.containsKey(JBOSS_MAVEN_DIST) && options.containsKey(JBOSS_MAVEN_REPO) ? options : null).map(options -> {
            String dist = (String)options.get(JBOSS_MAVEN_DIST);
            return dist == null || "true".equals(dist) ? (String)options.get(JBOSS_MAVEN_REPO) : null;
        }).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"org.wildfly.plugins", (String)"wildfly-jar-maven-plugin");
    }

    protected Map<String, String> getEnv(boolean isPrepackagePhase) {
        Map ret = super.getEnv(isPrepackagePhase);
        ret.put("AB_PROMETHEUS_OFF", "true");
        ret.put("AB_OFF", "true");
        ret.put("AB_JOLOKIA_OFF", "true");
        return ret;
    }

    protected List<AssemblyFileSet> addAdditionalFiles() {
        List set = super.addAdditionalFiles();
        if (this.localRepoCache != null) {
            Path parentDir;
            Path repoDir = this.localRepoCache;
            if (this.localRepoCache.isAbsolute()) {
                parentDir = this.localRepoCache.getParent();
            } else {
                repoDir = this.getProject().getBaseDirectory().toPath().resolve(this.localRepoCache);
                parentDir = repoDir.getParent();
            }
            if (Files.notExists(repoDir, new LinkOption[0])) {
                throw new RuntimeException("Error, WildFly bootable JAR generator can't retrieve generated maven local cache, directory " + repoDir + " doesn't exist.");
            }
            set.add(AssemblyFileSet.builder().directory(parentDir.toFile()).include(this.localRepoCache.getFileName().toString()).outputDirectory(new File(".")).fileMode("0640").build());
        }
        return set;
    }

    protected List<String> getExtraJavaOptions() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("-Djava.net.preferIPv4Stack=true");
        if (this.localRepoCache != null) {
            properties.add("-Dmaven.repo.local=/deployments/" + this.localRepoCache.getFileName().toString());
        }
        return properties;
    }
}

