/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpUnitUtils {
    public static final int DEFAULT_TEXT_BUFFER_SIZE = 2048;
    public static final String DEFAULT_CHARACTER_SET = "iso-8859-1";
    private static boolean EXCEPTION_DEBUG = true;

    public static void handleException(Throwable th) {
        if (EXCEPTION_DEBUG) {
            th.printStackTrace();
        }
    }

    public static boolean isEclipse() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        return ste[ste.length - 1].getClassName().startsWith("org.eclipse.jdt");
    }

    public static String[] parseContentTypeHeader(String header) {
        String[] result = new String[]{"text/plain", null};
        if (header.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(header, ";= ");
            result[0] = st.nextToken();
            while (st.hasMoreTokens()) {
                String parameter = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String value = HttpUnitUtils.stripQuotes(st.nextToken());
                if (!parameter.trim().equalsIgnoreCase("charset")) continue;
                result[1] = value;
            }
        }
        return result;
    }

    public static String stripQuotes(String value) {
        if (value.startsWith("'") || value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("'") || value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String decode(String byteString) {
        return HttpUnitUtils.decode(byteString, DEFAULT_CHARACTER_SET);
    }

    static String trimmedValue(Number number) {
        String rawNumber = number.toString();
        if (rawNumber.indexOf(46) == -1) {
            return rawNumber;
        }
        int index = rawNumber.length();
        while (rawNumber.charAt(index - 1) == '0') {
            --index;
        }
        if (rawNumber.charAt(index - 1) == '.') {
            --index;
        }
        return rawNumber.substring(0, index);
    }

    public static String decode(String string, String charset) {
        try {
            if (string == null) {
                return null;
            }
            return new String(HttpUnitUtils.decodeUrl(string.getBytes("US-ASCII")), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private static final byte[] decodeUrl(byte[] pArray) throws IllegalArgumentException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < pArray.length; ++i) {
            byte b = pArray[i];
            if (b == 43) {
                buffer.write(32);
                continue;
            }
            if (b != 37) {
                buffer.write(b);
                continue;
            }
            try {
                int u = Character.digit((char)pArray[++i], 16);
                int l = Character.digit((char)pArray[++i], 16);
                if (u == -1 || l == -1) {
                    throw new IllegalArgumentException("Invalid URL encoding");
                }
                buffer.write((char)((u << 4) + l));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid URL encoding");
            }
        }
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseISToString(InputStream is) {
        DataInputStream din = new DataInputStream(is);
        StringBuffer sb = new StringBuffer();
        try {
            String line = null;
            while ((line = din.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (Exception ex) {
            ex.getMessage();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    public static Document parse(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilder db = HttpUnitUtils.newParser();
        try {
            Document doc = db.parse(inputSource);
            return doc;
        }
        catch (MalformedURLException mue) {
            if (EXCEPTION_DEBUG) {
                String msg = mue.getMessage();
                if (msg != null) {
                    System.err.println(msg);
                }
                InputStream is = inputSource.getByteStream();
                is.reset();
                String content = HttpUnitUtils.parseISToString(is);
                System.err.println(content);
            }
            throw mue;
        }
    }

    public static Document parse(InputStream inputStream) throws SAXException, IOException {
        DocumentBuilder db = HttpUnitUtils.newParser();
        try {
            Document doc = db.parse(inputStream);
            return doc;
        }
        catch (MalformedURLException mue) {
            if (EXCEPTION_DEBUG) {
                String msg = mue.getMessage();
                if (msg != null) {
                    System.err.println(msg);
                }
                InputStream is = inputStream;
                is.reset();
                String content = HttpUnitUtils.parseISToString(is);
                System.err.println(content);
            }
            throw mue;
        }
    }

    public static DocumentBuilder newParser() throws SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ClasspathEntityResolver());
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
    }

    static String[] withNewValue(String[] oldValue, String newValue) {
        String[] result;
        if (oldValue == null) {
            result = new String[]{newValue};
        } else {
            result = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, result, 0, oldValue.length);
            result[oldValue.length] = newValue;
        }
        return result;
    }

    static Object[] withNewValue(Object[] oldValue, Object newValue) {
        Object[] result;
        if (oldValue == null) {
            result = new Object[]{newValue};
        } else {
            result = new Object[oldValue.length + 1];
            System.arraycopy(oldValue, 0, result, 0, oldValue.length);
            result[oldValue.length] = newValue;
        }
        return result;
    }

    static boolean contains(String string, String substring) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().indexOf(substring.toUpperCase()) >= 0;
        }
        return string.indexOf(substring) >= 0;
    }

    static boolean hasPrefix(String string, String prefix) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string.toUpperCase().startsWith(prefix.toUpperCase());
        }
        return string.startsWith(prefix);
    }

    static boolean matches(String string1, String string2) {
        if (HttpUnitOptions.getMatchesIgnoreCase()) {
            return string1.equalsIgnoreCase(string2);
        }
        return string1.equals(string2);
    }

    static boolean isJavaScriptURL(String urlString) {
        boolean result = urlString.toLowerCase().startsWith("javascript:");
        return result;
    }

    static String encodeSpaces(String s) {
        if ((s = s.trim()).indexOf(32) < 0) {
            return s;
        }
        boolean inQuotes = false;
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == '\"' || aChar == '\'') {
                inQuotes = !inQuotes;
                sb.append(aChar);
                continue;
            }
            if (inQuotes) {
                sb.append(aChar);
                continue;
            }
            if (aChar > ' ') {
                sb.append(aChar);
                continue;
            }
            if (aChar != ' ') continue;
        }
        return sb.toString();
    }

    static String replaceEntities(String string) {
        int semiColonIndex;
        int ampIndex;
        int i = 0;
        while ((ampIndex = string.indexOf(38, i)) >= 0 && (semiColonIndex = string.indexOf(59, ampIndex + 1)) >= 0) {
            i = ampIndex + 1;
            String entityName = string.substring(ampIndex + 1, semiColonIndex);
            if (!entityName.equalsIgnoreCase("amp")) continue;
            string = string.substring(0, ampIndex) + '&' + string.substring(semiColonIndex + 1);
        }
        return string;
    }

    static String trimFragment(String rawUrl) {
        if (HttpUnitUtils.isJavaScriptURL(rawUrl)) {
            return rawUrl;
        }
        int hashIndex = rawUrl.indexOf(35);
        return hashIndex < 0 ? rawUrl : rawUrl.substring(0, hashIndex);
    }

    protected static boolean isEXCEPTION_DEBUG() {
        return EXCEPTION_DEBUG;
    }

    public static boolean setEXCEPTION_DEBUG(boolean exception_debug) {
        boolean oldExceptionDebug = exception_debug;
        EXCEPTION_DEBUG = exception_debug;
        return oldExceptionDebug;
    }

    static class ClasspathEntityResolver
    implements EntityResolver {
        ClasspathEntityResolver() {
        }

        public InputSource resolveEntity(String publicID, String systemID) {
            if (systemID == null) {
                return null;
            }
            String localName = systemID;
            if (localName.indexOf("/") > 0) {
                localName = localName.substring(localName.lastIndexOf("/") + 1, localName.length());
            }
            try {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream(localName));
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

