/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class HttpWebResponse
extends WebResponse {
    private String _referer;
    private static final String FILE_ENCODING = System.getProperty("file.encoding");
    private int _responseCode = 200;
    private String _responseMessage = "OK";
    private Hashtable _headers = new Hashtable();

    HttpWebResponse(WebConversation client, FrameSelector frame, URL url, URLConnection connection, boolean throwExceptionOnError) throws IOException {
        super(client, frame, url);
        if (HttpUnitOptions.isLoggingHttpHeaders()) {
            System.out.println("\nReceived from " + url);
        }
        this.readHeaders(connection);
        if (this._responseCode < 400 || !throwExceptionOnError) {
            InputStream inputStream = this.getInputStream(connection);
            this.defineRawInputStream(new BufferedInputStream(inputStream));
            String contentType = this.getContentType();
            if (contentType.startsWith("text")) {
                this.loadResponseText();
            }
        }
    }

    HttpWebResponse(WebConversation client, FrameSelector frame, WebRequest request, URLConnection connection, boolean throwExceptionOnError) throws IOException {
        this(client, frame, request.getURL(), connection, throwExceptionOnError);
        super.setWithParse(!request.getMethod().equals("HEAD"));
        this._referer = request.getReferer();
    }

    private InputStream getInputStream(URLConnection connection) throws IOException {
        InputStream result = null;
        if (this.isResponseOnErrorStream(connection)) {
            result = ((HttpURLConnection)connection).getErrorStream();
        } else {
            try {
                result = connection.getInputStream();
            }
            catch (FileNotFoundException fnfe) {
                if (this.isErrorResponse(connection)) {
                    result = new ByteArrayInputStream(new byte[0]);
                }
                throw fnfe;
            }
        }
        return result;
    }

    private boolean isErrorResponse(URLConnection connection) {
        return this._responseCode >= 400;
    }

    private boolean isResponseOnErrorStream(URLConnection connection) {
        return this.isErrorResponse(connection) && ((HttpURLConnection)connection).getErrorStream() != null;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseMessage() {
        return this._responseMessage;
    }

    public String[] getHeaderFieldNames() {
        Vector names = new Vector();
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] result = new String[names.size()];
        names.copyInto(result);
        return result;
    }

    public String getHeaderField(String fieldName) {
        String[] fields = (String[])this._headers.get(fieldName.toUpperCase());
        return fields == null ? null : fields[0];
    }

    public String[] getHeaderFields(String fieldName) {
        String[] fields = (String[])this._headers.get(fieldName.toUpperCase());
        return fields == null ? new String[]{} : fields;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("HttpWebResponse [url=");
        sb.append(this.getURL()).append("; headers=");
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String[] values = (String[])this._headers.get(key);
            for (int i = 0; i < values.length; ++i) {
                sb.append("\n   ").append(key).append(": ").append(values[i]);
            }
        }
        sb.append(" ]");
        return sb.toString();
    }

    String getReferer() {
        return this._referer;
    }

    private void setResponseCode(int code, String message) {
        this._responseCode = code;
        this._responseMessage = message;
    }

    private void readResponseHeader(HttpURLConnection connection) throws IOException {
        if (!this.needStatusWorkaround()) {
            this.setResponseCode(connection.getResponseCode(), connection.getResponseMessage());
        } else {
            if (connection.getHeaderField(0) == null) {
                throw new UnknownHostException(connection.getURL().toExternalForm());
            }
            StringTokenizer st = new StringTokenizer(connection.getHeaderField(0));
            st.nextToken();
            if (!st.hasMoreTokens()) {
                this.setResponseCode(200, "OK");
            } else {
                try {
                    this.setResponseCode(Integer.parseInt(st.nextToken()), this.getRemainingTokens(st));
                }
                catch (NumberFormatException e) {
                    this.setResponseCode(500, "Cannot parse response header");
                }
            }
        }
    }

    private boolean needStatusWorkaround() {
        String jdkVersion = System.getProperty("java.version");
        return jdkVersion.startsWith("1.2") || jdkVersion.startsWith("1.3");
    }

    private String getRemainingTokens(StringTokenizer st) {
        StringBuffer messageBuffer = new StringBuffer(st.hasMoreTokens() ? st.nextToken() : "");
        while (st.hasMoreTokens()) {
            messageBuffer.append(' ').append(st.nextToken());
        }
        return messageBuffer.toString();
    }

    private void readHeaders(URLConnection connection) throws IOException {
        this.loadHeaders(connection);
        if (connection instanceof HttpURLConnection) {
            this.readResponseHeader((HttpURLConnection)connection);
        } else {
            this.setResponseCode(200, "OK");
            if (connection.getContentType().startsWith("text")) {
                this.setContentTypeHeader(connection.getContentType() + "; charset=" + FILE_ENCODING);
            }
        }
    }

    private void loadHeaders(URLConnection connection) {
        if (HttpUnitOptions.isLoggingHttpHeaders()) {
            System.out.println("Header:: " + connection.getHeaderField(0));
        }
        int i = 1;
        while (true) {
            String headerFieldKey = connection.getHeaderFieldKey(i);
            String headerField = connection.getHeaderField(i);
            if (headerFieldKey == null || headerField == null) break;
            if (HttpUnitOptions.isLoggingHttpHeaders()) {
                System.out.println("Header:: " + headerFieldKey + ": " + headerField);
            }
            this.addHeader(headerFieldKey.toUpperCase(), headerField);
            ++i;
        }
        if (connection.getContentType() != null) {
            this.setContentTypeHeader(connection.getContentType());
        }
    }

    private void addHeader(String key, String field) {
        this._headers.put(key, HttpUnitUtils.withNewValue((String[])this._headers.get(key), field));
    }
}

