/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public abstract class HttpsProtocolSupport {
    private static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    public static final String SunJSSE_PROVIDER_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    public static final String SunJSSE_PROVIDER_CLASS2 = "sun.net.www.protocol.https";
    public static final String SunSSL_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    public static final String IBMJSSE_PROVIDER_CLASS = "com.ibm.jsse.IBMJSSEProvider";
    public static final String IBMSSL_PROTOCOL_HANDLER = "com.ibm.net.ssl.www.protocol";
    private static String JSSE_PROVIDER_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    private static String SSL_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    private static Class _httpsProviderClass;
    private static boolean _httpsSupportVerified;
    private static boolean _httpsProtocolSupportEnabled;

    public static void useProvider(String className, String handlerName) {
        _httpsProviderClass = null;
        JSSE_PROVIDER_CLASS = className;
        SSL_PROTOCOL_HANDLER = handlerName;
    }

    public static void useIBM() {
        HttpsProtocolSupport.useProvider(IBMJSSE_PROVIDER_CLASS, IBMSSL_PROTOCOL_HANDLER);
    }

    static boolean hasHttpsSupport() {
        if (!_httpsSupportVerified) {
            try {
                HttpsProtocolSupport.getHttpsProviderClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _httpsSupportVerified = true;
        }
        return _httpsProviderClass != null;
    }

    static void verifyProtocolSupport(String protocol) {
        if (protocol.equalsIgnoreCase("http")) {
            return;
        }
        if (protocol.equalsIgnoreCase("https")) {
            HttpsProtocolSupport.validateHttpsProtocolSupport();
        }
    }

    private static void validateHttpsProtocolSupport() {
        if (!_httpsProtocolSupportEnabled) {
            HttpsProtocolSupport.verifyHttpsSupport();
            _httpsProtocolSupportEnabled = true;
        }
    }

    private static void verifyHttpsSupport() {
        try {
            Class providerClass = HttpsProtocolSupport.getHttpsProviderClass();
            if (!HttpsProtocolSupport.hasProvider(providerClass)) {
                Security.addProvider((Provider)providerClass.newInstance());
            }
            HttpsProtocolSupport.registerSSLProtocolHandler();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("https support requires the Java Secure Sockets Extension. See http://java.sun.com/products/jsse");
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to enable https support. Make sure that you have installed JSSE as described in http://java.sun.com/products/jsse/install.html: " + e);
        }
    }

    public static Class getHttpsProviderClass() throws ClassNotFoundException {
        if (_httpsProviderClass == null) {
            Provider[] sslProviders = Security.getProviders("SSLContext.SSLv3");
            if (sslProviders.length > 0) {
                _httpsProviderClass = sslProviders[0].getClass();
            }
            if (_httpsProviderClass == null) {
                _httpsProviderClass = Class.forName(JSSE_PROVIDER_CLASS);
            }
        }
        return _httpsProviderClass;
    }

    private static boolean hasProvider(Class providerClass) {
        Provider[] list = Security.getProviders();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getClass().equals(providerClass)) continue;
            return true;
        }
        return false;
    }

    public static SSLSocketFactory getSocketFactory() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new X509TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, null);
        return context.getSocketFactory();
    }

    private static void registerSSLProtocolHandler() {
        String list = System.getProperty(PROTOCOL_HANDLER_PKGS);
        if (list == null || list.length() == 0) {
            System.setProperty(PROTOCOL_HANDLER_PKGS, SSL_PROTOCOL_HANDLER);
        } else if (list.indexOf(SSL_PROTOCOL_HANDLER) < 0) {
            System.setProperty(PROTOCOL_HANDLER_PKGS, list + " | " + SSL_PROTOCOL_HANDLER);
        }
    }
}

