/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLPage;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebWindow;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class WebRequestSource
extends ParameterHolder
implements HTMLElement {
    private FrameSelector _frame;
    private String _destinationAttribute;
    private ScriptingHandler _scriptable;
    private static final String PARAM_DELIM = "&";
    private WebResponse _baseResponse;
    private String _defaultTarget;
    private URL _baseURL;
    private Node _node;

    public String getID() {
        return this.getAttribute("id");
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public String getTarget() {
        if (this.getSpecifiedTarget().length() == 0) {
            return this._defaultTarget;
        }
        return this.getSpecifiedTarget();
    }

    public String getPageFrame() {
        return this._frame.getName();
    }

    public FrameSelector getFrame() {
        return this._frame;
    }

    public String getFragmentIdentifier() {
        int hashIndex = this.getDestination().indexOf(35);
        if (hashIndex < 0) {
            return "";
        }
        return this.getDestination().substring(hashIndex + 1);
    }

    public Node getDOMSubtree() {
        return this._node.cloneNode(true);
    }

    public abstract WebRequest getRequest();

    public abstract String[] getParameterNames();

    public abstract String[] getParameterValues(String var1);

    String getRelativePage() {
        String url = this.getRelativeURL();
        if (HttpUnitUtils.isJavaScriptURL(url)) {
            return url;
        }
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex >= 1 && questionMarkIndex < url.length() - 1) {
            return url.substring(0, questionMarkIndex);
        }
        return url;
    }

    protected String getRelativeURL() {
        String result = HttpUnitUtils.encodeSpaces(HttpUnitUtils.trimFragment(this.getDestination()));
        if (result.trim().length() == 0) {
            result = this.getBaseURL().getFile();
        }
        return result;
    }

    WebRequestSource(WebResponse response, Node node, URL baseURL, String attribute, FrameSelector frame, String defaultTarget) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        this._baseResponse = response;
        this._node = node;
        this._baseURL = baseURL;
        this._destinationAttribute = attribute;
        this._frame = frame;
        this._defaultTarget = defaultTarget;
    }

    protected URL getBaseURL() {
        return this._baseURL;
    }

    public String getDestination() {
        return this.getElement().getAttribute(this._destinationAttribute);
    }

    protected void setDestination(String destination) {
        this.getElement().setAttribute(this._destinationAttribute, destination);
    }

    protected Element getElement() {
        return (Element)this._node;
    }

    protected HTMLPage getHTMLPage() throws SAXException {
        return this._baseResponse.getReceivedPage();
    }

    protected final void loadDestinationParameters() {
        StringTokenizer st = new StringTokenizer(this.getParametersString(), PARAM_DELIM);
        while (st.hasMoreTokens()) {
            this.stripOneParameter(st.nextToken());
        }
    }

    protected WebResponse submitRequest(String event, WebRequest request) throws IOException, SAXException {
        WebResponse response = null;
        if (this.doEventScript(event)) {
            response = this.submitRequest(request);
        }
        if (response == null) {
            response = this.getCurrentFrameContents();
        }
        return response;
    }

    public boolean doEvent(String eventScript) {
        return this.doEventScript(eventScript);
    }

    public boolean doEventScript(String eventScript) {
        return this.getScriptingHandler().doEventScript(eventScript);
    }

    public boolean handleEvent(String eventName) {
        return this.getScriptingHandler().handleEvent(eventName);
    }

    protected WebResponse getCurrentFrameContents() {
        return this.getCurrentFrame(this.getBaseResponse().getWindow(), this._frame);
    }

    private WebResponse getCurrentFrame(WebWindow window, FrameSelector pageFrame) {
        return window.hasFrame(pageFrame) ? window.getFrameContents(pageFrame) : window.getCurrentPage();
    }

    protected final WebResponse submitRequest(WebRequest request) throws IOException, SAXException {
        return this.getDestination().equals("#") ? this._baseResponse : this._baseResponse.getWindow().sendRequest(request);
    }

    protected final WebResponse getBaseResponse() {
        return this._baseResponse;
    }

    protected abstract void addPresetParameter(String var1, String var2);

    public String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this._node, name);
    }

    public void setAttribute(String name, Object value) {
        NodeUtils.setNodeAttribute(this.getNode(), name, value == null ? null : value.toString());
    }

    public void removeAttribute(String name) {
        NodeUtils.removeNodeAttribute(this.getNode(), name);
    }

    public boolean isSupportedAttribute(String name) {
        return false;
    }

    public Node getNode() {
        return this._node;
    }

    public String getText() {
        if (this._node == null) {
            return "";
        }
        if (this._node.getNodeType() == 3) {
            return this._node.getNodeValue().trim();
        }
        if (!this._node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this._node.getChildNodes()).trim();
    }

    public String getTagName() {
        return this._node.getNodeName();
    }

    String getAttribute(String name, String defaultValue) {
        return NodeUtils.getNodeAttribute(this._node, name, defaultValue);
    }

    private String getSpecifiedTarget() {
        return this.getAttribute("target");
    }

    protected void setTargetAttribute(String value) {
        ((Element)this._node).setAttribute("target", value);
    }

    private String getParametersString() {
        String url = HttpUnitUtils.trimFragment(this.getDestination());
        if (url.trim().length() == 0) {
            url = this.getBaseURL().toExternalForm();
        }
        if (HttpUnitUtils.isJavaScriptURL(url)) {
            return "";
        }
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex >= 1 && questionMarkIndex < url.length() - 1) {
            return url.substring(questionMarkIndex + 1);
        }
        return "";
    }

    private void stripOneParameter(String param) {
        int index = param.indexOf("=");
        String value = index < 0 ? null : (index == param.length() - 1 ? this.getEmptyParameterValue() : this.decode(param.substring(index + 1)));
        String name = index < 0 ? this.decode(param) : this.decode(param.substring(0, index));
        this.addPresetParameter(name, value);
    }

    private String decode(String string) {
        return HttpUnitUtils.decode(string, this._baseResponse.getCharacterSet()).trim();
    }

    protected abstract String getEmptyParameterValue();

    public ScriptingHandler getScriptingHandler() {
        if (this._scriptable == null) {
            this._scriptable = HttpUnitOptions.getScriptingEngine().createHandler(this);
        }
        return this._scriptable;
    }

    public ScriptableDelegate getParentDelegate() {
        return this.getBaseResponse().getDocumentScriptable();
    }
}

