/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.DefaultWebResponse;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLPage;
import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.HttpWebResponse;
import com.meterware.httpunit.NoSuchFrameException;
import com.meterware.httpunit.NotHTMLException;
import com.meterware.httpunit.TextBlock;
import com.meterware.httpunit.WebApplet;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebTable;
import com.meterware.httpunit.WebWindow;
import com.meterware.httpunit.cookies.CookieJar;
import com.meterware.httpunit.cookies.CookieSource;
import com.meterware.httpunit.dom.DomWindow;
import com.meterware.httpunit.dom.DomWindowProxy;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.protocol.MessageBody;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebResponse
implements HTMLSegment,
CookieSource,
DomWindowProxy {
    private static final String HTML_CONTENT = "text/html";
    private static final String XHTML_CONTENT = "application/xhtml+xml";
    private static final String FAUX_XHTML_CONTENT = "text/xhtml";
    private static final String XML_CONTENT = "text/xml";
    private static String[] validContentTypes = new String[]{"text/html", "application/xhtml+xml", "text/xhtml", "text/xml"};
    private static final int UNINITIALIZED_INT = -2;
    private static final int UNKNOWN_LENGTH_TIMEOUT = 500;
    private static final int UNKNOWN_LENGTH_RETRY_INTERVAL = 10;
    private FrameSelector _frame;
    private boolean _withParse = true;
    private String _baseTarget;
    private String _refreshHeader;
    private URL _baseURL;
    private boolean _parsingPage;
    static final String BLANK_HTML = "";
    private WebWindow _window;
    private HTMLPage _page;
    private String _contentHeader;
    private int _contentLength = -2;
    private String _contentType;
    private String _characterSet;
    private WebRequest _refreshRequest;
    private int _refreshDelay = -1;
    private String _responseText;
    private byte[] _bytes;
    private InputStream _inputStream;
    private final URL _pageURL;
    private final WebClient _client;
    private ScriptingHandler _scriptingHandler;
    private CookieJar _cookies;
    private static String _defaultEncoding;
    private static final String[] DEFAULT_ENCODING_CANDIDATES;

    public boolean isWithParse() {
        return this._withParse;
    }

    public void setWithParse(boolean doParse) {
        this._withParse = doParse;
    }

    public static WebResponse newResponse(URLConnection connection) throws IOException {
        return new HttpWebResponse(null, FrameSelector.TOP_FRAME, connection.getURL(), connection, HttpUnitOptions.getExceptionsThrownOnErrorStatus());
    }

    public boolean isHTML() {
        boolean result = false;
        for (int i = 0; i < validContentTypes.length && !(result = this.getContentType().equalsIgnoreCase(validContentTypes[i])); ++i) {
        }
        return result;
    }

    public URL getURL() {
        return this._pageURL;
    }

    public String getTitle() throws SAXException {
        return this.getReceivedPage().getTitle();
    }

    public String getExternalStyleSheet() throws SAXException {
        return this.getReceivedPage().getExternalStyleSheet();
    }

    public String[] getMetaTagContent(String attribute, String attributeValue) throws SAXException {
        return this.getReceivedPage().getMetaTagContent(attribute, attributeValue);
    }

    public String getFrameName() {
        return this._frame.getName();
    }

    void setFrame(FrameSelector frame) {
        if (!this._frame.getName().equals(frame.getName())) {
            throw new IllegalArgumentException("May not modify the frame name");
        }
        this._frame = frame;
    }

    FrameSelector getFrame() {
        return this._frame;
    }

    public WebRequest getRefreshRequest() {
        this.readRefreshRequest();
        return this._refreshRequest;
    }

    public int getRefreshDelay() {
        this.readRefreshRequest();
        return this._refreshDelay;
    }

    public abstract int getResponseCode();

    public abstract String getResponseMessage();

    public int getContentLength() {
        if (this._contentLength == -2) {
            String length = this.getHeaderField("Content-Length");
            this._contentLength = length == null ? -1 : Integer.parseInt(length);
        }
        return this._contentLength;
    }

    public String getContentType() {
        if (this._contentType == null) {
            this.readContentTypeHeader();
        }
        return this._contentType;
    }

    public String getCharacterSet() {
        if (this._characterSet == null) {
            this.readContentTypeHeader();
            if (this._characterSet == null) {
                this.setCharacterSet(this.getHeaderField("Charset"));
            }
            if (this._characterSet == null) {
                this.setCharacterSet(HttpUnitOptions.getDefaultCharacterSet());
            }
        }
        return this._characterSet;
    }

    public String[] getNewCookieNames() {
        return this.getCookieJar().getCookieNames();
    }

    public String getNewCookieValue(String name) {
        return this.getCookieJar().getCookieValue(name);
    }

    public abstract String[] getHeaderFieldNames();

    public abstract String getHeaderField(String var1);

    public byte[] getBytes() throws IOException {
        if (this._responseText == null) {
            this.loadResponseText();
        }
        return this._bytes;
    }

    public String getText() throws IOException {
        if (this._responseText == null) {
            this.loadResponseText();
        }
        return this._responseText;
    }

    public InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new ByteArrayInputStream(this.getText().getBytes());
        }
        return this._inputStream;
    }

    public String[] getFrameNames() throws SAXException {
        WebFrame[] frames = this.getFrames();
        String[] result = new String[frames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = frames[i].getFrameName();
        }
        return result;
    }

    FrameSelector[] getFrameSelectors() throws SAXException {
        WebFrame[] frames = this.getFrames();
        FrameSelector[] result = new FrameSelector[frames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = frames[i].getSelector();
        }
        return result;
    }

    public WebResponse getSubframeContents(String subFrameName) {
        if (this._window == null) {
            throw new NoSuchFrameException(subFrameName);
        }
        return this._window.getSubframeContents(this._frame, subFrameName);
    }

    public HTMLElement getElementWithID(String id) throws SAXException {
        return this.getReceivedPage().getElementWithID(id);
    }

    public HTMLElement[] getElementsByTagName(String tagName) throws SAXException {
        return this.getReceivedPage().getElementsByTagName(this.getDOM(), tagName);
    }

    public String[] getElementNames() throws SAXException {
        return this.getReceivedPage().getElementNames();
    }

    public HTMLElement[] getElementsWithName(String name) throws SAXException {
        return this.getReceivedPage().getElementsWithName(name);
    }

    public HTMLElement[] getElementsWithClassName(String className) throws SAXException {
        return this.getReceivedPage().getElementsWithClassName(className);
    }

    public HTMLElement[] getElementsWithAttribute(String name, String value) throws SAXException {
        return this.getReceivedPage().getElementsWithAttribute(name, value);
    }

    public WebForm[] getForms() throws SAXException {
        return this.getReceivedPage().getForms();
    }

    public WebForm getFormWithName(String name) throws SAXException {
        return this.getReceivedPage().getFormWithName(name);
    }

    public WebForm getFormWithID(String ID) throws SAXException {
        return this.getReceivedPage().getFormWithID(ID);
    }

    public WebForm getFirstMatchingForm(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getFirstMatchingForm(predicate, criteria);
    }

    public WebForm[] getMatchingForms(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getMatchingForms(predicate, criteria);
    }

    public WebLink[] getLinks() throws SAXException {
        return this.getReceivedPage().getLinks();
    }

    public WebLink getLinkWith(String text) throws SAXException {
        return this.getReceivedPage().getLinkWith(text);
    }

    public WebLink getLinkWithImageText(String text) throws SAXException {
        return this.getReceivedPage().getLinkWithImageText(text);
    }

    public WebLink getLinkWithName(String name) throws SAXException {
        return this.getReceivedPage().getLinkWithName(name);
    }

    public WebLink getLinkWithID(String ID) throws SAXException {
        return this.getReceivedPage().getLinkWithID(ID);
    }

    public WebLink getFirstMatchingLink(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getFirstMatchingLink(predicate, criteria);
    }

    public WebLink[] getMatchingLinks(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getMatchingLinks(predicate, criteria);
    }

    public WebImage[] getImages() throws SAXException {
        return this.getReceivedPage().getImages();
    }

    public WebImage getImageWithName(String source) throws SAXException {
        return this.getReceivedPage().getImageWithName(source);
    }

    public WebImage getImageWithSource(String source) throws SAXException {
        return this.getReceivedPage().getImageWithSource(source);
    }

    public WebImage getImageWithAltText(String altText) throws SAXException {
        return this.getReceivedPage().getImageWithAltText(altText);
    }

    public WebApplet[] getApplets() throws SAXException {
        return this.getReceivedPage().getApplets();
    }

    public TextBlock[] getTextBlocks() throws SAXException {
        return this.getReceivedPage().getTextBlocks();
    }

    public TextBlock getNextTextBlock(TextBlock block) throws SAXException {
        return this.getReceivedPage().getNextTextBlock(block);
    }

    public TextBlock getFirstMatchingTextBlock(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getFirstMatchingTextBlock(predicate, criteria);
    }

    public Document getDOM() throws SAXException {
        if (this.isHTML()) {
            return (Document)this.getReceivedPage().getDOM();
        }
        try {
            return HttpUnitUtils.parse(new InputSource(new StringReader(this.getText())));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public WebTable[] getTables() throws SAXException {
        return this.getReceivedPage().getTables();
    }

    public WebTable getFirstMatchingTable(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getFirstMatchingTable(predicate, criteria);
    }

    public WebTable[] getMatchingTables(HTMLElementPredicate predicate, Object criteria) throws SAXException {
        return this.getReceivedPage().getMatchingTables(predicate, criteria);
    }

    public WebTable getTableStartingWith(String text) throws SAXException {
        return this.getReceivedPage().getTableStartingWith(text);
    }

    public WebTable getTableStartingWithPrefix(String text) throws SAXException {
        return this.getReceivedPage().getTableStartingWithPrefix(text);
    }

    public WebTable getTableWithSummary(String text) throws SAXException {
        return this.getReceivedPage().getTableWithSummary(text);
    }

    public WebTable getTableWithID(String text) throws SAXException {
        return this.getReceivedPage().getTableWithID(text);
    }

    public Scriptable getScriptableObject() {
        ScriptingHandler result = this.getScriptingHandler();
        if (!(result instanceof Scriptable)) {
            throw new RuntimeException("getScriptableObject failed for " + result.getClass().getName() + " - not a Scriptable");
        }
        return (Scriptable)result;
    }

    public void setScriptingHandler(ScriptingHandler scriptingHandler) {
        this._scriptingHandler = scriptingHandler;
    }

    public ScriptingHandler getScriptingHandler() {
        if (this._scriptingHandler == null) {
            this._scriptingHandler = HttpUnitOptions.getScriptingEngine().createHandler(this);
        }
        return this._scriptingHandler;
    }

    public ScriptingHandler createJavascriptScriptingHandler() {
        return new Scriptable();
    }

    public ScriptingHandler createDomScriptingHandler() {
        if (!this.isHTML()) {
            return new DomWindow(this);
        }
        try {
            HTMLPage page = this.getReceivedPage();
            Node rootNode = page.getRootNode();
            HTMLDocumentImpl document = (HTMLDocumentImpl)rootNode;
            DomWindow result = document.getWindow();
            result.setProxy(this);
            return result;
        }
        catch (SAXException e) {
            return new DomWindow(this);
        }
    }

    public static ScriptableDelegate newDelegate(String delegateClassName) {
        if (delegateClassName.equalsIgnoreCase("Option")) {
            return FormControl.newSelectionOption();
        }
        throw new IllegalArgumentException("No such scripting class supported: " + delegateClassName);
    }

    HTMLPage.Scriptable getDocumentScriptable() {
        return this.getScriptableObject().getDocument();
    }

    public DomWindowProxy openNewWindow(String name, String relativeUrl) throws IOException, SAXException {
        if (relativeUrl == null || relativeUrl.trim().length() == 0) {
            relativeUrl = "about:";
        }
        GetMethodWebRequest request = new GetMethodWebRequest(this.getURL(), relativeUrl, this._frame, name);
        WebResponse response = this._window.getResponse(request);
        return response;
    }

    public DomWindowProxy submitRequest(HTMLElementImpl sourceElement, String method, String location, String target, MessageBody requestBody) throws IOException, SAXException {
        if (method.equalsIgnoreCase("get")) {
            return this.getWindow().sendRequest(new GetMethodWebRequest(this, sourceElement, this.getURL(), location, target));
        }
        return null;
    }

    public void close() {
        if (this.getFrameName().equals("_top")) {
            this._window.close();
        }
    }

    public void alert(String message) {
        this._client.postAlert(message);
    }

    public boolean confirm(String message) {
        return this._client.getConfirmationResponse(message);
    }

    public String prompt(String prompt, String defaultResponse) {
        return this._client.getUserResponse(prompt, defaultResponse);
    }

    String getBaseTarget() {
        return this._baseTarget;
    }

    public abstract String toString();

    protected WebResponse(WebClient client, FrameSelector frame, URL url) {
        this._client = client;
        this._baseURL = this._pageURL = url;
        this._baseTarget = frame.getName();
        this._frame = frame;
        if (client != null) {
            this._window = client.getMainWindow();
        }
    }

    protected WebResponse(WebClient client, FrameSelector frame, URL url, String text) {
        this(client, frame, url);
        this._responseText = text;
    }

    protected final void defineRawInputStream(InputStream inputStream) throws IOException {
        if (this._inputStream != null || this._responseText != null) {
            throw new IllegalStateException("Must be called before response text is defined.");
        }
        if (this.encodedUsingGZIP()) {
            try {
                this._inputStream = new GZIPInputStream(inputStream);
            }
            catch (EOFException eof) {
                this._inputStream = inputStream;
            }
        } else {
            this._inputStream = inputStream;
        }
    }

    private boolean encodedUsingGZIP() {
        String encoding = this.getHeaderField("Content-Encoding");
        return encoding != null && encoding.indexOf("gzip") >= 0;
    }

    protected void setContentTypeHeader(String value) {
        this._contentHeader = value;
    }

    static WebResponse createBlankResponse() {
        return new DefaultWebResponse(BLANK_HTML);
    }

    WebWindow getWindow() {
        return this._window;
    }

    void setWindow(WebWindow window) {
        this._window = window;
    }

    public boolean replaceText(String text, String contentType) {
        if (this._parsingPage) {
            return false;
        }
        this._responseText = text;
        this._inputStream = null;
        this._page = null;
        this._contentType = contentType;
        this._baseURL = null;
        this._baseTarget = this._frame.getName();
        this._refreshHeader = null;
        try {
            this.readTags(text.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failure while attempting to reparse text: " + e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failure while attempting to reparse text: " + e);
        }
        return true;
    }

    WebRequest[] getFrameRequests() throws SAXException {
        WebFrame[] frames = this.getFrames();
        Vector<WebRequest> requests = new Vector<WebRequest>();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].hasInitialRequest()) continue;
            requests.addElement(frames[i].getInitialRequest());
        }
        Object[] result = new WebRequest[requests.size()];
        requests.copyInto(result);
        return result;
    }

    public WebClient getClient() {
        return this._client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResponseText() throws IOException {
        if (this._responseText != null) {
            throw new IllegalStateException("May only invoke loadResponseText once");
        }
        this._responseText = BLANK_HTML;
        InputStream inputStream = this.getInputStream();
        try {
            int contentLength = this.encodedUsingGZIP() ? -1 : this.getContentLength();
            int bytesRemaining = contentLength < 0 ? Integer.MAX_VALUE : contentLength;
            this._bytes = this.readFromStream(inputStream, bytesRemaining);
            this.readTags(this._bytes);
            this._responseText = new String(this._bytes, this.getCharacterSet());
            this._inputStream = new ByteArrayInputStream(this._bytes);
            if (HttpUnitOptions.isCheckContentLength() && contentLength >= 0 && this._bytes.length != contentLength) {
                throw new IOException("Truncated message. Expected length: " + contentLength + ", Actual length: " + this._bytes.length);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private byte[] readFromStream(InputStream inputStream, int maxBytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int count = 0;
        if (maxBytes > 0) {
            do {
                outputStream.write(buffer, 0, count);
            } while ((maxBytes -= count) > 0 && (count = inputStream.read(buffer, 0, Math.min(maxBytes, buffer.length))) != -1);
        } else {
            int available;
            do {
                outputStream.write(buffer, 0, count);
            } while ((count = (available = this.getAvailableBytes(inputStream)) == 0 ? -1 : inputStream.read(buffer, 0, buffer.length)) != -1);
        }
        return outputStream.toByteArray();
    }

    private int getAvailableBytes(InputStream inputStream) throws IOException {
        int available;
        int timeLeft = 500;
        do {
            timeLeft -= 10;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ((available = inputStream.available()) == 0 && timeLeft > 0);
        return available;
    }

    private void readTags(byte[] rawMessage) throws UnsupportedEncodingException, MalformedURLException {
        ByteTagParser parser = new ByteTagParser(rawMessage);
        ByteTag tag = parser.getNextTag();
        while (tag != null) {
            if (tag.getName().equalsIgnoreCase("meta")) {
                this.processMetaTag(tag);
            }
            if (tag.getName().equalsIgnoreCase("base")) {
                this.processBaseTag(tag);
            }
            if (tag.getName().equalsIgnoreCase("noscript") && HttpUnitOptions.isScriptingEnabled()) {
                while (!(tag = parser.getNextTag()).getName().equalsIgnoreCase("/noscript")) {
                }
            }
            tag = parser.getNextTag();
        }
    }

    private void processBaseTag(ByteTag tag) throws MalformedURLException {
        if (tag.getAttribute("href") != null) {
            this._baseURL = new URL(this.getURL(), tag.getAttribute("href"));
        }
        if (tag.getAttribute("target") != null) {
            this._baseTarget = tag.getAttribute("target");
        }
    }

    private void processMetaTag(ByteTag tag) {
        if (this.isHttpEquivMetaTag(tag, "content-type")) {
            this.inferContentType(tag.getAttribute("content"));
        } else if (this.isHttpEquivMetaTag(tag, "refresh")) {
            this.inferRefreshHeader(tag.getAttribute("content"));
        }
    }

    private boolean isHttpEquivMetaTag(ByteTag tag, String headerName) {
        String equiv1 = tag.getAttribute("http_equiv");
        String equiv2 = tag.getAttribute("http-equiv");
        boolean result = headerName.equalsIgnoreCase(equiv1) || headerName.equalsIgnoreCase(equiv2);
        return result;
    }

    private void inferRefreshHeader(String refreshHeader) {
        String originalHeader = this.getHeaderField("Refresh");
        if (originalHeader == null) {
            this._refreshHeader = refreshHeader;
        }
    }

    private void readRefreshRequest() {
        String refreshHeader;
        if (this._refreshDelay >= 0) {
            return;
        }
        this._refreshDelay = 0;
        String string = refreshHeader = this._refreshHeader != null ? this._refreshHeader : this.getHeaderField("Refresh");
        if (refreshHeader == null) {
            return;
        }
        int semicolonIndex = refreshHeader.indexOf(59);
        if (semicolonIndex < 0) {
            this.interpretRefreshHeaderElement(refreshHeader, refreshHeader);
        } else {
            this.interpretRefreshHeaderElement(refreshHeader.substring(0, semicolonIndex), refreshHeader);
            this.interpretRefreshHeaderElement(refreshHeader.substring(semicolonIndex + 1), refreshHeader);
        }
        if (this._refreshRequest == null) {
            this._refreshRequest = new GetMethodWebRequest(this._pageURL, this._pageURL.toString(), this._frame.getName());
        }
    }

    private void interpretRefreshHeaderElement(String token, String refreshHeader) {
        if (token.length() == 0) {
            return;
        }
        try {
            if (Character.isDigit(token.charAt(0))) {
                this._refreshDelay = Integer.parseInt(token);
            } else {
                this._refreshRequest = new GetMethodWebRequest(this._pageURL, this.getRefreshURL(token), this._frame.getName());
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Unable to interpret refresh tag: \"" + refreshHeader + '\"');
        }
    }

    private String getRefreshURL(String text) {
        if (!(text = text.trim()).toUpperCase().startsWith("URL")) {
            return HttpUnitUtils.stripQuotes(text);
        }
        int splitIndex = text.indexOf(61);
        String value = text.substring(splitIndex + 1).trim();
        return HttpUnitUtils.replaceEntities(HttpUnitUtils.stripQuotes(value));
    }

    private void inferContentType(String contentTypeHeader) {
        String originalHeader = this.getHeaderField("Content-type");
        if (originalHeader == null || originalHeader.indexOf("charset") < 0) {
            this.setContentTypeHeader(contentTypeHeader);
        }
    }

    CookieJar getCookieJar() {
        if (this._cookies == null) {
            this._cookies = new CookieJar(this);
        }
        return this._cookies;
    }

    private void readContentTypeHeader() {
        String contentHeader;
        String string = contentHeader = this._contentHeader != null ? this._contentHeader : this.getHeaderField("Content-type");
        if (contentHeader == null) {
            this._contentType = HttpUnitOptions.getDefaultContentType();
            this.setCharacterSet(HttpUnitOptions.getDefaultCharacterSet());
            this._contentHeader = this._contentType + ";charset=" + this._characterSet;
        } else {
            String[] parts = HttpUnitUtils.parseContentTypeHeader(contentHeader);
            this._contentType = null != this._client && null != this._client.getClientProperties().getOverrideContentType() ? this._client.getClientProperties().getOverrideContentType() : parts[0];
            if (parts[1] != null) {
                this.setCharacterSet(parts[1]);
            }
        }
    }

    private WebFrame[] getFrames() throws SAXException {
        if (this.isWithParse()) {
            return this.getReceivedPage().getFrames();
        }
        return new WebFrame[0];
    }

    HTMLPage getReceivedPage() throws SAXException {
        if (this._page == null) {
            try {
                this._parsingPage = true;
                if (HttpUnitOptions.isCheckHtmlContentType() && !this.isHTML()) {
                    throw new NotHTMLException(this.getContentType());
                }
                this._page = new HTMLPage(this, this._frame, this._baseURL, this._baseTarget, this.getCharacterSet());
                if (this._withParse) {
                    this._page.parse(this.getText(), this._pageURL);
                    if (this._page == null) {
                        throw new IllegalStateException("replaceText called in the middle of getReceivedPage()");
                    }
                    ((HTMLDocumentImpl)this._page.getRootNode()).getWindow().setProxy(this);
                }
            }
            catch (IOException e) {
                HttpUnitUtils.handleException(e);
                throw new RuntimeException(e.toString());
            }
            finally {
                this._parsingPage = false;
            }
        }
        return this._page;
    }

    static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            for (int i = 0; i < DEFAULT_ENCODING_CANDIDATES.length; ++i) {
                if (!WebResponse.isSupportedCharacterSet(DEFAULT_ENCODING_CANDIDATES[i])) continue;
                _defaultEncoding = DEFAULT_ENCODING_CANDIDATES[i];
                return _defaultEncoding;
            }
        }
        _defaultEncoding = System.getProperty("file.encoding");
        return _defaultEncoding;
    }

    private void setCharacterSet(String characterSet) {
        if (characterSet == null) {
            return;
        }
        this._characterSet = WebResponse.isSupportedCharacterSet(characterSet) ? characterSet : WebResponse.getDefaultEncoding();
    }

    private static boolean isSupportedCharacterSet(String characterSet) {
        try {
            return "abcd".getBytes(characterSet).length > 0;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    void setCookie(String name, String value) {
        this._client.putCookie(name, value);
    }

    String getCookieHeader() {
        return this._client.getCookieJar().getCookieHeaderField(this.getURL());
    }

    String getReferer() {
        return null;
    }

    public static String[] getValidContentTypes() {
        return validContentTypes;
    }

    protected static void setValidContentTypes(String[] validContentTypes) {
        WebResponse.validContentTypes = validContentTypes;
    }

    static {
        DEFAULT_ENCODING_CANDIDATES = new String[]{"iso-8859-1", "us-ascii", "utf-8", "utf8"};
    }

    static class ByteTagParser {
        private int _scriptDepth = 0;
        private int _end = -1;
        private byte[] _buffer;

        ByteTagParser(byte[] buffer) {
            this._buffer = buffer;
        }

        ByteTag getNextTag() throws UnsupportedEncodingException {
            ByteTag byteTag = null;
            do {
                int _start;
                for (_start = this._end + 1; _start < this._buffer.length && this._buffer[_start] != 60; ++_start) {
                }
                this._end = _start + 1;
                while (this._end < this._buffer.length && this._buffer[this._end] != 62) {
                    ++this._end;
                }
                if (this._end >= this._buffer.length || this._end < _start) {
                    return null;
                }
                byteTag = new ByteTag(this._buffer, _start + 1, this._end - _start - 1);
                if (byteTag.getName().equalsIgnoreCase("script")) {
                    ++this._scriptDepth;
                    return byteTag;
                }
                if (!byteTag.getName().equalsIgnoreCase("/script")) continue;
                --this._scriptDepth;
            } while (this._scriptDepth > 0);
            return byteTag;
        }
    }

    static class ByteTag {
        private String _name = "";
        private Hashtable _attributes;
        private char[] _buffer;
        private int _end = -1;

        ByteTag(byte[] buffer, int start, int length) throws UnsupportedEncodingException {
            this._buffer = new String(buffer, start, length, WebResponse.getDefaultEncoding()).toCharArray();
            this._name = this.nextToken();
            String attribute = WebResponse.BLANK_HTML;
            String token = this.nextToken();
            while (token.length() != 0) {
                if (token.equals("=") && attribute.length() != 0) {
                    this.getAttributes().put(attribute.toLowerCase(), this.nextToken());
                    attribute = WebResponse.BLANK_HTML;
                } else {
                    if (attribute.length() > 0) {
                        this.getAttributes().put(attribute.toLowerCase(), WebResponse.BLANK_HTML);
                    }
                    attribute = token;
                }
                token = this.nextToken();
            }
        }

        public String getName() {
            return this._name;
        }

        public String getAttribute(String attributeName) {
            return (String)this.getAttributes().get(attributeName);
        }

        public String toString() {
            return "ByteTag[ name=" + this._name + ";attributes = " + this._attributes + ']';
        }

        private Hashtable getAttributes() {
            if (this._attributes == null) {
                this._attributes = new Hashtable();
            }
            return this._attributes;
        }

        private String nextToken() {
            int start;
            for (start = this._end + 1; start < this._buffer.length && Character.isWhitespace(this._buffer[start]); ++start) {
            }
            if (start >= this._buffer.length) {
                return WebResponse.BLANK_HTML;
            }
            if (this._buffer[start] == '\"') {
                this._end = start + 1;
                while (this._end < this._buffer.length && this._buffer[this._end] != '\"') {
                    ++this._end;
                }
                return new String(this._buffer, start + 1, this._end - start - 1);
            }
            if (this._buffer[start] == '\'') {
                this._end = start + 1;
                while (this._end < this._buffer.length && this._buffer[this._end] != '\'') {
                    ++this._end;
                }
                return new String(this._buffer, start + 1, this._end - start - 1);
            }
            if (this._buffer[start] == '=') {
                this._end = start;
                return "=";
            }
            this._end = start + 1;
            while (this._end < this._buffer.length && this._buffer[this._end] != '=' && !Character.isWhitespace(this._buffer[this._end])) {
                ++this._end;
            }
            return new String(this._buffer, start, this._end-- - start);
        }
    }

    public class Scriptable
    extends ScriptableDelegate
    implements NamedDelegate {
        public void alertUser(String message) {
            WebResponse.this.alert(message);
        }

        public boolean getConfirmationResponse(String message) {
            return WebResponse.this.confirm(message);
        }

        public String getUserResponse(String prompt, String defaultResponse) {
            return WebResponse.this.prompt(prompt, defaultResponse);
        }

        public ClientProperties getClientProperties() {
            return WebResponse.this._client == null ? ClientProperties.getDefaultProperties() : WebResponse.this._client.getClientProperties();
        }

        public HTMLPage.Scriptable getDocument() {
            try {
                if (!WebResponse.this.isHTML()) {
                    WebResponse.this.replaceText(WebResponse.BLANK_HTML, WebResponse.HTML_CONTENT);
                }
                return WebResponse.this.getReceivedPage().getScriptableObject();
            }
            catch (SAXException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Scriptable[] getFrames() throws SAXException {
            String[] names = WebResponse.this.getFrameNames();
            Scriptable[] frames = new Scriptable[names.length];
            for (int i = 0; i < frames.length; ++i) {
                frames[i] = WebResponse.this.getSubframeContents(names[i]).getScriptableObject();
            }
            return frames;
        }

        public void load() throws SAXException {
            if (WebResponse.this.isHTML() && WebResponse.this.isWithParse()) {
                WebResponse.this.getReceivedPage().getForms();
                this.doEventScript(WebResponse.this.getReceivedPage().getOnLoadEvent());
            }
        }

        public Scriptable open(String urlString, String name, String features, boolean replace) throws IOException, SAXException {
            WebResponse response = (WebResponse)WebResponse.this.openNewWindow(name, urlString);
            return response == null ? null : response.getScriptableObject();
        }

        public void closeWindow() {
            WebResponse.this.close();
        }

        public Object get(String propertyName) {
            if (propertyName.equals("name")) {
                return this.getName();
            }
            if (propertyName.equalsIgnoreCase("top")) {
                return WebResponse.this._window.getFrameContents("_top").getScriptableObject();
            }
            if (propertyName.equalsIgnoreCase("parent")) {
                return WebResponse.this._window.getParentFrameContents(WebResponse.this._frame).getScriptableObject();
            }
            if (propertyName.equalsIgnoreCase("opener")) {
                return WebResponse.this.getFrameName().equals("_top") ? this.getScriptable(WebResponse.this._window.getOpener()) : null;
            }
            if (propertyName.equalsIgnoreCase("closed")) {
                return WebResponse.this.getFrameName().equals("_top") && WebResponse.this._window.isClosed() ? Boolean.TRUE : Boolean.FALSE;
            }
            try {
                return WebResponse.this.getSubframeContents(propertyName).getScriptableObject();
            }
            catch (NoSuchFrameException e) {
                return super.get(propertyName);
            }
        }

        public String getName() {
            String windowName = WebResponse.this.getFrameName().equals("_top") ? WebResponse.this._window.getName() : WebResponse.this.getFrameName();
            return windowName.startsWith("$$HttpUnit_Window$$_") ? WebResponse.BLANK_HTML : windowName;
        }

        private Scriptable getScriptable(WebResponse opener) {
            return opener == null ? null : opener.getScriptableObject();
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equals("name")) {
                if (value == null) {
                    value = WebResponse.BLANK_HTML;
                }
                if (WebResponse.this.getFrameName().equals("_top")) {
                    WebResponse.this._window.setName(value.toString());
                }
            } else {
                super.set(propertyName, value);
            }
        }

        public void setLocation(String relativeURL) throws IOException, SAXException {
            WebResponse.this.getWindow().getResponse(new GetMethodWebRequest(WebResponse.this._pageURL, relativeURL, WebResponse.this._frame.getName()));
        }

        public URL getURL() {
            return WebResponse.this._pageURL;
        }
    }
}

