/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementPredicate;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPredicate
implements HTMLElementPredicate {
    private XPathExpression xpath;
    private String path;
    public static final boolean DEBUG = false;

    public XPathPredicate(String path) throws XPathExpressionException {
        this.path = path;
        this.xpath = XPathFactory.newInstance().newXPath().compile(path);
    }

    private void debugOut(Node node, String indent) {
        System.out.print(indent + node.getNodeName() + ":");
        System.out.println(indent + node.getNodeValue());
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            this.debugOut(nl.item(i), indent + "\t");
        }
    }

    public boolean matchesCriteria(Object someElement, Object criteria) {
        if (!(someElement instanceof HTMLElement)) {
            return false;
        }
        HTMLElement htmlElement = (HTMLElement)someElement;
        Node htmlNode = htmlElement.getNode();
        Document doc = htmlNode.getOwnerDocument();
        try {
            NodeList nodes = (NodeList)this.xpath.evaluate(doc, XPathConstants.NODESET);
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                if (!nodes.item(i).equals(htmlNode)) continue;
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("unable to evaluate xpath '" + this.path + "'", e);
        }
        return false;
    }
}

