/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.cookies;

import com.meterware.httpunit.cookies.CookieProperties;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class Cookie {
    private String _name;
    private String _value;
    private String _path;
    private String _domain;
    private long _expiredTime;
    private static final DateFormat originalCookieFormat = new SimpleDateFormat("EEE,dd-MMM-yyyy HH:mm:ss z", Locale.US);

    public long getExpiredTime() {
        return this._expiredTime;
    }

    Cookie(String name, String value) {
        this._name = name;
        this._value = value;
    }

    Cookie(String name, String value, String domain, String path) {
        this(name, value);
        this._path = path;
        this._domain = domain;
    }

    Cookie(String name, String value, Map attributes) {
        this(name, value);
        for (String key : attributes.keySet()) {
            String attributeValue = (String)attributes.get(key);
            if (key.equalsIgnoreCase("path")) {
                this._path = attributeValue;
                continue;
            }
            if (key.equalsIgnoreCase("domain")) {
                this._domain = attributeValue;
                continue;
            }
            if (key.equalsIgnoreCase("max-age")) {
                this._expiredTime = System.currentTimeMillis() + (long)this.getAgeInMsec(attributeValue);
                continue;
            }
            if (!key.equalsIgnoreCase("expires")) continue;
            this._expiredTime = this.getAgeInMsecFromDate(attributeValue);
        }
    }

    private int getAgeInMsec(String maxAgeValue) {
        try {
            return 1000 * Integer.parseInt(maxAgeValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAgeInMsecFromDate(String dateValue) {
        try {
            DateFormat dateFormat = originalCookieFormat;
            synchronized (dateFormat) {
                long age = originalCookieFormat.parse(dateValue).getTime();
                return age;
            }
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String getPath() {
        return this._path;
    }

    public String getDomain() {
        return this._domain;
    }

    void setPath(String path) {
        this._path = path;
    }

    void setDomain(String domain) {
        this._domain = domain;
    }

    public int hashCode() {
        int hashCode = this._name.hashCode();
        if (this._domain != null) {
            hashCode ^= this._domain.hashCode();
        }
        if (this._path != null) {
            hashCode ^= this._path.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.equals((Cookie)obj);
    }

    private boolean equals(Cookie other) {
        return this._name.equalsIgnoreCase(other._name) && this.equalProperties(this.getDomain(), other.getDomain()) && this.equalProperties(this.getPath(), other.getPath());
    }

    private boolean equalProperties(String first, String second) {
        return first == second || first != null && first.equals(second);
    }

    public boolean isExpired() {
        boolean expired = this._expiredTime != 0L && this._expiredTime <= System.currentTimeMillis();
        return expired;
    }

    public boolean mayBeSentTo(URL url) {
        if (this.getDomain() == null) {
            return true;
        }
        if (this.isExpired()) {
            return false;
        }
        return Cookie.acceptHost(this.getDomain(), url.getHost()) && this.acceptPath(this.getPath(), url.getPath());
    }

    private boolean acceptPath(String pathPattern, String hostPath) {
        return !CookieProperties.isPathMatchingStrict() || hostPath.startsWith(pathPattern);
    }

    private static boolean acceptHost(String hostPattern, String hostName) {
        return hostPattern.equalsIgnoreCase(hostName) || hostPattern.startsWith(".") && hostName.endsWith(hostPattern);
    }

    static {
        originalCookieFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

