/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AbstractDomComponent;
import com.meterware.httpunit.dom.DomWindowProxy;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.io.IOException;
import java.net.URL;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.SAXException;

public class DomWindow
extends AbstractDomComponent
implements Scriptable {
    private DomWindowProxy _proxy;
    private HTMLDocumentImpl _document;

    public DomWindow(HTMLDocumentImpl document) {
        this._document = document;
    }

    public DomWindow(DomWindowProxy implementation) {
        this._proxy = implementation;
    }

    public void setProxy(DomWindowProxy proxy) {
        this._proxy = proxy;
    }

    public DomWindow getWindow() {
        return this;
    }

    public DomWindow getSelf() {
        return this;
    }

    public HTMLDocument getDocument() {
        return this._document;
    }

    public HTMLDocument getOwnerDocument() {
        return this._document;
    }

    public DomWindow open(String urlString, String name, String features, boolean replace) {
        try {
            if (this._proxy == null) {
                throw new RuntimeException("DomWindow.open failed for '" + name + "' _proxy is null");
            }
            DomWindowProxy newWindow = this._proxy.openNewWindow(name, urlString);
            if (newWindow == null) {
                return null;
            }
            ScriptingHandler result = newWindow.getScriptingHandler();
            return (DomWindow)result;
        }
        catch (IOException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    public void close() {
        this._proxy.close();
    }

    public void alert(String message) {
        this._proxy.alert(message);
    }

    public boolean confirm(String prompt) {
        return this._proxy.confirm(prompt);
    }

    public String prompt(String message, String defaultResponse) {
        return this._proxy.prompt(message, defaultResponse);
    }

    public void setTimeout(int timeout) {
    }

    public void focus() {
    }

    public void moveTo(int x, int y) {
    }

    public void scrollTo(int x, int y) {
    }

    protected String getDocumentWriteBuffer() {
        return this._document.getWriteBuffer().toString();
    }

    protected void discardDocumentWriteBuffer() {
        this._document.clearWriteBuffer();
    }

    boolean replaceText(String string, String mimeType) {
        return this._proxy.replaceText(string, mimeType);
    }

    URL getUrl() {
        return this._proxy.getURL();
    }

    void submitRequest(HTMLElementImpl sourceElement, String method, String location, String target, byte[] requestBody) throws IOException, SAXException {
        this._proxy.submitRequest(sourceElement, method, location, target, null);
    }
}

