/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AttrImpl;
import com.meterware.httpunit.dom.DocumentImpl;
import com.meterware.httpunit.dom.DomListener;
import com.meterware.httpunit.dom.NamedNodeMapImpl;
import com.meterware.httpunit.dom.NamespaceAwareNodeImpl;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NamespaceAwareNodeImpl
implements Element {
    private Hashtable _attributes = new Hashtable();
    private ArrayList _listeners = new ArrayList();

    static ElementImpl createElement(DocumentImpl owner, String tagName) {
        ElementImpl element = new ElementImpl();
        element.initialize(owner, tagName);
        return element;
    }

    public static Element createElement(DocumentImpl owner, String namespaceURI, String qualifiedName) {
        ElementImpl element = new ElementImpl();
        element.initialize(owner, namespaceURI, qualifiedName);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomListener(DomListener listener) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportPropertyChanged(String propertyName) {
        ArrayList listeners;
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            listeners = (ArrayList)this._listeners.clone();
        }
        Iterator each = listeners.iterator();
        while (each.hasNext()) {
            ((DomListener)each.next()).propertyChanged(this, propertyName);
        }
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public boolean hasAttributes() {
        return !this._attributes.isEmpty();
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this._attributes);
    }

    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (value.equals(this.getAttribute(name))) {
            return;
        }
        Attr attribute = this.getOwnerDocument().createAttribute(name);
        attribute.setValue(value);
        this.setAttributeNode(attribute);
        this.reportPropertyChanged(name);
    }

    public boolean handleEvent(String eventName) {
        if (eventName.toLowerCase().equals("onclick")) {
            this.handleEvent("onmousedown");
        }
        String eventScript = this.getAttribute(eventName);
        boolean result = this.doEventScript(eventScript);
        if (eventName.toLowerCase().equals("onclick")) {
            this.handleEvent("onmouseup");
        }
        return result;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Attr attribute = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
        attribute.setValue(value);
        this.setAttributeNodeNS(attribute);
    }

    public void removeAttribute(String name) throws DOMException {
        this._attributes.remove(name);
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this._attributes.get(name);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (newAttr.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, "attribute must be from the same document as the element");
        }
        ((AttrImpl)newAttr).setOwnerElement(this);
        AttrImpl oldAttr = (AttrImpl)this._attributes.put(newAttr.getName(), newAttr);
        if (oldAttr != null) {
            oldAttr.setOwnerElement(null);
        }
        return oldAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (newAttr.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, "attribute must be from the same document as the element");
        }
        ((AttrImpl)newAttr).setOwnerElement(this);
        AttrImpl oldAttr = (AttrImpl)this._attributes.put(newAttr.getName(), newAttr);
        if (oldAttr != null) {
            oldAttr.setOwnerElement(null);
        }
        return oldAttr;
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (!this._attributes.containsValue(oldAttr)) {
            throw new DOMException(8, "Specified attribute is not defined for this element");
        }
        AttrImpl removedAttr = (AttrImpl)this._attributes.remove(oldAttr.getName());
        if (removedAttr != null) {
            removedAttr.setOwnerElement(null);
        }
        return removedAttr;
    }

    public boolean hasAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return null;
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return false;
    }

    public static Element importNode(DocumentImpl document, Element original, boolean deep) {
        Element copy = document.createElementNS(original.getNamespaceURI(), original.getTagName());
        NamedNodeMap attributes = original.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            copy.setAttributeNode((Attr)document.importNode(attributes.item(i), false));
        }
        if (deep) {
            document.importChildren(original, copy);
        }
        return copy;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }
}

