/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.html.HTMLAnchorElement;

public class HTMLAnchorElementImpl
extends HTMLElementImpl
implements HTMLAnchorElement {
    ElementImpl create() {
        return new HTMLAnchorElementImpl();
    }

    public String getCharset() {
        return this.getAttributeWithNoDefault("charset");
    }

    public String getHref() {
        String relativeLocation = this.getAttributeWithNoDefault("href");
        if (relativeLocation.indexOf(58) > 0 || relativeLocation.equals("#")) {
            return relativeLocation;
        }
        try {
            return new URL(((HTMLDocumentImpl)this.getOwnerDocument()).getBaseUrl(), relativeLocation).toExternalForm();
        }
        catch (MalformedURLException e) {
            return e.toString();
        }
    }

    public String getHreflang() {
        return this.getAttributeWithNoDefault("hreflang");
    }

    public String getRel() {
        return this.getAttributeWithNoDefault("rel");
    }

    public String getRev() {
        return this.getAttributeWithNoDefault("rev");
    }

    public String getTarget() {
        return this.getAttributeWithNoDefault("target");
    }

    public String getType() {
        return this.getAttributeWithNoDefault("type");
    }

    public void setCharset(String charset) {
        this.setAttribute("charset", charset);
    }

    public void setHref(String href) {
        this.setAttribute("href", href);
    }

    public void setHreflang(String hreflang) {
        this.setAttribute("hreflang", hreflang);
    }

    public void setRel(String rel) {
        this.setAttribute("rel", rel);
    }

    public void setRev(String rev) {
        this.setAttribute("rev", rev);
    }

    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public void blur() {
        this.handleEvent("onblur");
    }

    public void focus() {
        this.handleEvent("onfocus");
    }

    public String getAccessKey() {
        return this.getAttributeWithNoDefault("accesskey");
    }

    public String getCoords() {
        return this.getAttributeWithNoDefault("coords");
    }

    public String getName() {
        return this.getAttributeWithNoDefault("name");
    }

    public String getShape() {
        return this.getAttributeWithNoDefault("shape");
    }

    public int getTabIndex() {
        return this.getIntegerAttribute("tabindex");
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute("accesskey", accessKey);
    }

    public void setCoords(String coords) {
        this.setAttribute("coords", coords);
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public void setShape(String shape) {
        this.setAttribute("shape", shape);
    }

    public void setTabIndex(int tabIndex) {
        this.setAttribute("tabindex", tabIndex);
    }

    public void doClickAction() {
        if (null == this.getHref() || this.getHref().startsWith("#")) {
            return;
        }
        try {
            ((HTMLDocumentImpl)this.getOwnerDocument()).getWindow().submitRequest(this, "GET", this.getHref(), this.getTarget(), new byte[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error clicking link: " + e);
        }
    }
}

