/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.DocumentImpl;
import com.meterware.httpunit.dom.DomWindow;
import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLAnchorElementImpl;
import com.meterware.httpunit.dom.HTMLAppletElementImpl;
import com.meterware.httpunit.dom.HTMLAreaElementImpl;
import com.meterware.httpunit.dom.HTMLBaseElementImpl;
import com.meterware.httpunit.dom.HTMLBodyElementImpl;
import com.meterware.httpunit.dom.HTMLButtonElementImpl;
import com.meterware.httpunit.dom.HTMLContainerDelegate;
import com.meterware.httpunit.dom.HTMLContainerElement;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.dom.HTMLFormElementImpl;
import com.meterware.httpunit.dom.HTMLHeadElementImpl;
import com.meterware.httpunit.dom.HTMLHtmlElementImpl;
import com.meterware.httpunit.dom.HTMLIFrameElementImpl;
import com.meterware.httpunit.dom.HTMLImageElementImpl;
import com.meterware.httpunit.dom.HTMLInputElementImpl;
import com.meterware.httpunit.dom.HTMLLinkElementImpl;
import com.meterware.httpunit.dom.HTMLMetaElementImpl;
import com.meterware.httpunit.dom.HTMLOptionElementImpl;
import com.meterware.httpunit.dom.HTMLParagraphElementImpl;
import com.meterware.httpunit.dom.HTMLSelectElementImpl;
import com.meterware.httpunit.dom.HTMLStyleElementImpl;
import com.meterware.httpunit.dom.HTMLTableCellElementImpl;
import com.meterware.httpunit.dom.HTMLTableElementImpl;
import com.meterware.httpunit.dom.HTMLTableRowElementImpl;
import com.meterware.httpunit.dom.HTMLTextAreaElementImpl;
import com.meterware.httpunit.dom.HTMLTitleElementImpl;
import com.meterware.httpunit.dom.NodeListImpl;
import com.meterware.httpunit.dom.ScriptingSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLBaseElement;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLHtmlElement;
import org.w3c.dom.html.HTMLTitleElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument,
HTMLContainerElement {
    private static Hashtable _exemplars = new Hashtable();
    private DomWindow _window;
    private StringBuffer _writeBuffer;
    private HTMLContainerDelegate _containerDelegate = new HTMLContainerDelegate(SKIP_IFRAMES);

    public void setIFramesEnabled(boolean enabled) {
        this._containerDelegate = new HTMLContainerDelegate(enabled ? SKIP_IFRAMES : null);
    }

    public Object get(String propertyName, Scriptable scriptable) {
        if (propertyName.equals("document")) {
            return this;
        }
        Object result = super.get(propertyName, scriptable);
        if (result != NOT_FOUND) {
            return result;
        }
        Element element = this.getElementById(propertyName);
        if (element != null) {
            return element;
        }
        NodeList elements = this.getElementsByName(propertyName);
        if (elements.getLength() >= 1) {
            return elements.item(0);
        }
        return ScriptingSupport.getNamedProperty(this, this.getJavaPropertyName(propertyName), scriptable);
    }

    public void put(String propertyName, Scriptable initialObject, Object value) {
        ScriptingSupport.setNamedProperty(this, this.getJavaPropertyName(propertyName), value);
    }

    public HTMLCollection getLinks() {
        return this._containerDelegate.getLinks(this);
    }

    public HTMLCollection getImages() {
        return this._containerDelegate.getImages(this);
    }

    public HTMLCollection getApplets() {
        return this._containerDelegate.getApplets(this);
    }

    public HTMLCollection getForms() {
        return this._containerDelegate.getForms(this);
    }

    public HTMLCollection getAnchors() {
        return this._containerDelegate.getAnchors(this);
    }

    public String getTitle() {
        HTMLTitleElement result = this.getTitleElement();
        return result == null ? "" : result.getText();
    }

    private HTMLTitleElement getTitleElement() {
        HTMLTitleElement result = null;
        NodeList titleNodes = this.getElementsByTagName("title");
        for (int i = 0; i < titleNodes.getLength(); ++i) {
            Node node = titleNodes.item(i);
            if (!(node instanceof HTMLTitleElement)) continue;
            result = (HTMLTitleElement)node;
        }
        return result;
    }

    private HTMLHeadElement getHeadElement() {
        NodeList headNodes = this.getElementsByTagName("head");
        for (int i = 0; i < headNodes.getLength(); ++i) {
            Node node = headNodes.item(i);
            if (!(node instanceof HTMLHeadElement)) continue;
            return (HTMLHeadElement)node;
        }
        HTMLHeadElement head = (HTMLHeadElement)this.createElement("head");
        this.getHtmlElement().appendChild(head);
        return head;
    }

    private HTMLHtmlElement getHtmlElement() {
        NodeList htmlNodes = this.getElementsByTagName("html");
        for (int i = 0; i < htmlNodes.getLength(); ++i) {
            Node node = htmlNodes.item(i);
            if (!(node instanceof HTMLHtmlElement)) continue;
            return (HTMLHtmlElement)node;
        }
        HTMLHtmlElement html = (HTMLHtmlElement)this.createElement("html");
        this.appendChild(html);
        return html;
    }

    public void setTitle(String title) {
        HTMLTitleElement titleElement = this.getTitleElement();
        if (titleElement != null) {
            titleElement.setText(title);
        } else {
            titleElement = (HTMLTitleElement)this.createElement("title");
            titleElement.setText(title);
            this.getHeadElement().appendChild(titleElement);
        }
    }

    public String getReferrer() {
        return null;
    }

    public String getDomain() {
        return null;
    }

    public String getURL() {
        return null;
    }

    public HTMLElement getBody() {
        NodeList bodyNodes = this.getElementsByTagName("body");
        for (int i = 0; i < bodyNodes.getLength(); ++i) {
            Node node = bodyNodes.item(i);
            if (!(node instanceof HTMLBodyElement)) continue;
            return (HTMLBodyElement)node;
        }
        return null;
    }

    public void setBody(HTMLElement body) {
        this.getHtmlElement().appendChild(body);
    }

    public String getCookie() {
        return null;
    }

    public void setCookie(String cookie) {
    }

    public void open() {
    }

    public void close() {
        if (this.getWindow().replaceText(this.getWriteBuffer().toString(), this.getMimeType())) {
            this.clearWriteBuffer();
        }
    }

    private String getMimeType() {
        return "text/html";
    }

    public void write(String text) {
        this.getWriteBuffer().append(text);
    }

    public void writeln(String text) {
        this.getWriteBuffer().append(text).append('\r').append('\n');
    }

    public NodeList getElementsByName(String elementName) {
        ArrayList<HTMLElementImpl> elements = new ArrayList<HTMLElementImpl>();
        Iterator each = this.preOrderIterator();
        while (each.hasNext()) {
            HTMLElementImpl element;
            Node node = (Node)each.next();
            if (!(node instanceof HTMLElementImpl) || !elementName.equals((element = (HTMLElementImpl)node).getAttributeWithNoDefault("name"))) continue;
            elements.add(element);
        }
        return new NodeListImpl(elements);
    }

    public Element createElement(String tagName) throws DOMException {
        ElementImpl element = HTMLDocumentImpl.getExemplar(tagName).create();
        element.initialize(this, this.toNodeCase(tagName));
        return element;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        ElementImpl element = HTMLDocumentImpl.getExemplar(qualifiedName).create();
        element.initialize(this, namespaceURI, this.toNodeCase(qualifiedName));
        return element;
    }

    public NodeList getElementsByTagName(String name) {
        return super.getElementsByTagName(this.toNodeCase(name));
    }

    public Node cloneNode(boolean deep) {
        HTMLDocumentImpl copy = new HTMLDocumentImpl();
        if (deep) {
            copy.importChildren(this, copy);
            copy._documentElement = copy.getHtmlElement();
        }
        return copy;
    }

    private static HTMLElementImpl getExemplar(String tagName) {
        HTMLElementImpl impl = (HTMLElementImpl)_exemplars.get(tagName.toLowerCase());
        if (impl == null) {
            impl = new HTMLElementImpl();
        }
        return impl;
    }

    String toNodeCase(String nodeName) {
        return nodeName.toUpperCase();
    }

    HTMLContainerDelegate getContainerDelegate() {
        return this._containerDelegate;
    }

    public DomWindow getWindow() {
        if (this._window == null) {
            this._window = new DomWindow(this);
            this.setParentScope(this._window);
        }
        return this._window;
    }

    StringBuffer getWriteBuffer() {
        if (this._writeBuffer == null) {
            this._writeBuffer = new StringBuffer();
        }
        return this._writeBuffer;
    }

    public void clearWriteBuffer() {
        this._writeBuffer = null;
    }

    URL getBaseUrl() {
        NodeList list = this.getElementsByTagName("base");
        if (list.getLength() == 0) {
            return this.getWindow().getUrl();
        }
        HTMLBaseElement base = (HTMLBaseElement)list.item(0);
        try {
            return new URL(this.getWindow().getUrl(), base.getHref());
        }
        catch (MalformedURLException e) {
            return this.getWindow().getUrl();
        }
    }

    static {
        _exemplars.put("html", new HTMLHtmlElementImpl());
        _exemplars.put("head", new HTMLHeadElementImpl());
        _exemplars.put("link", new HTMLLinkElementImpl());
        _exemplars.put("title", new HTMLTitleElementImpl());
        _exemplars.put("meta", new HTMLMetaElementImpl());
        _exemplars.put("base", new HTMLBaseElementImpl());
        _exemplars.put("style", new HTMLStyleElementImpl());
        _exemplars.put("body", new HTMLBodyElementImpl());
        _exemplars.put("form", new HTMLFormElementImpl());
        _exemplars.put("select", new HTMLSelectElementImpl());
        _exemplars.put("option", new HTMLOptionElementImpl());
        _exemplars.put("input", new HTMLInputElementImpl());
        _exemplars.put("button", new HTMLButtonElementImpl());
        _exemplars.put("textarea", new HTMLTextAreaElementImpl());
        _exemplars.put("a", new HTMLAnchorElementImpl());
        _exemplars.put("area", new HTMLAreaElementImpl());
        _exemplars.put("img", new HTMLImageElementImpl());
        _exemplars.put("td", new HTMLTableCellElementImpl());
        _exemplars.put("th", new HTMLTableCellElementImpl());
        _exemplars.put("tr", new HTMLTableRowElementImpl());
        _exemplars.put("table", new HTMLTableElementImpl());
        _exemplars.put("p", new HTMLParagraphElementImpl());
        _exemplars.put("iframe", new HTMLIFrameElementImpl());
        _exemplars.put("applet", new HTMLAppletElementImpl());
    }
}

