/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.dom.HTMLFormElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLInputElement;

public class HTMLInputElementImpl
extends HTMLControl
implements HTMLInputElement {
    private String _value;
    private Boolean _checked;
    private TypeSpecificBehavior _behavior;

    ElementImpl create() {
        return new HTMLInputElementImpl();
    }

    public void blur() {
        this.handleEvent("onblur");
    }

    public void focus() {
        this.handleEvent("onfocus");
    }

    public void doClickAction() {
        this.getBehavior().click();
    }

    public void select() {
    }

    public String getAccept() {
        return this.getAttributeWithNoDefault("accept");
    }

    public String getAccessKey() {
        return this.getAttributeWithNoDefault("accessKey");
    }

    public String getAlign() {
        return this.getAttributeWithDefault("align", "bottom");
    }

    public String getAlt() {
        return this.getAttributeWithNoDefault("alt");
    }

    public boolean getChecked() {
        return this.getBehavior().getChecked();
    }

    public boolean getDefaultChecked() {
        return this.getBooleanAttribute("checked");
    }

    public String getDefaultValue() {
        return this.getAttributeWithNoDefault("value");
    }

    public int getMaxLength() {
        return this.getIntegerAttribute("maxlength");
    }

    public String getSize() {
        return this.getAttributeWithNoDefault("size");
    }

    public String getSrc() {
        return this.getAttributeWithNoDefault("src");
    }

    public String getUseMap() {
        return this.getAttributeWithNoDefault("useMap");
    }

    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute("accessKey", accessKey);
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    public void setChecked(boolean checked) {
        this.getBehavior().setChecked(checked);
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.setAttribute("checked", defaultChecked);
    }

    public void setDefaultValue(String defaultValue) {
        this.setAttribute("value", defaultValue);
    }

    public void setMaxLength(int maxLength) {
        this.setAttribute("maxlength", maxLength);
    }

    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public void setUseMap(String useMap) {
        this.setAttribute("useMap", useMap);
    }

    public String getValue() {
        return this.getBehavior().getValue();
    }

    public void setValue(String value) {
        this.getBehavior().setValue(value);
    }

    public void reset() {
        this.getBehavior().reset();
    }

    public void setAttribute(String name, String value) throws DOMException {
        super.setAttribute(name, value);
        if (name.equalsIgnoreCase("type")) {
            this.selectBehavior(this.getType().toLowerCase());
        }
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        this.getBehavior().addValues(this.getName(), processor, characterSet);
    }

    public void silenceSubmitButton() {
        this.getBehavior().silenceSubmitButton();
    }

    void setState(boolean checked) {
        this._checked = checked ? Boolean.TRUE : Boolean.FALSE;
    }

    static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private void selectBehavior(String type) {
        this._behavior = type == null || type.equals("text") || type.equals("password") || type.equals("hidden") ? new EditableTextBehavior(this) : (type.equals("checkbox") ? new CheckboxBehavior(this) : (type.equals("radio") ? new RadioButtonBehavior(this) : (type.equals("reset") ? new ResetButtonBehavior(this) : (type.equals("submit") ? new SubmitButtonBehavior(this) : new DefaultBehavior(this)))));
    }

    private TypeSpecificBehavior getBehavior() {
        if (this._behavior == null) {
            this.selectBehavior(this.getType().toLowerCase());
        }
        return this._behavior;
    }

    class ResetButtonBehavior
    extends DefaultBehavior {
        public ResetButtonBehavior(HTMLElementImpl element) {
            super(element);
        }

        public void click() {
            HTMLInputElementImpl.this.getForm().reset();
        }
    }

    class RadioButtonBehavior
    extends CheckboxBehavior {
        public RadioButtonBehavior(HTMLElementImpl element) {
            super(element);
        }

        public void setChecked(boolean checked) {
            if (checked) {
                HTMLCollection elements = HTMLInputElementImpl.this.getForm().getElements();
                for (int i = 0; i < elements.getLength(); ++i) {
                    Node node = elements.item(i);
                    if (!(node instanceof HTMLInputElementImpl)) continue;
                    HTMLInputElementImpl input = (HTMLInputElementImpl)node;
                    if (!HTMLInputElementImpl.this.getName().equals(input.getName()) || !input.getType().equalsIgnoreCase("radio")) continue;
                    input.setState(false);
                }
            }
            HTMLInputElementImpl.this.setState(checked);
        }

        public void click() {
            this.setChecked(true);
        }
    }

    class CheckboxBehavior
    extends DefaultBehavior {
        public CheckboxBehavior(HTMLElementImpl element) {
            super(element);
        }

        public boolean getChecked() {
            return HTMLInputElementImpl.this._checked != null ? HTMLInputElementImpl.this._checked.booleanValue() : HTMLInputElementImpl.this.getDefaultChecked();
        }

        public void setChecked(boolean checked) {
            HTMLInputElementImpl.this.setState(checked);
        }

        public void reset() {
            HTMLInputElementImpl.this._checked = null;
        }

        public void click() {
            this.setChecked(!this.getChecked());
        }

        public void addValues(String name, ParameterProcessor processor, String characterSet) throws IOException {
            if (!HTMLInputElementImpl.this.getDisabled() && this.getChecked()) {
                processor.addParameter(name, this.getFormValue(), characterSet);
            }
        }

        private String getFormValue() {
            return HTMLInputElementImpl.this._value == null ? "on" : HTMLInputElementImpl.this._value;
        }
    }

    class SubmitButtonBehavior
    extends DefaultBehavior {
        private boolean _sendWithSubmit;

        public SubmitButtonBehavior(HTMLElementImpl element) {
            super(element);
        }

        public void click() {
            this._sendWithSubmit = true;
            ((HTMLFormElementImpl)HTMLInputElementImpl.this.getForm()).doSubmitAction();
        }

        public void addValues(String name, ParameterProcessor processor, String characterSet) throws IOException {
            if (!this._sendWithSubmit) {
                return;
            }
            super.addValues(name, processor, characterSet);
        }

        public void silenceSubmitButton() {
            this._sendWithSubmit = false;
        }
    }

    class EditableTextBehavior
    extends DefaultBehavior {
        public EditableTextBehavior(HTMLElementImpl element) {
            super(element);
        }

        public void reset() {
            HTMLInputElementImpl.this._value = null;
        }
    }

    class DefaultBehavior
    implements TypeSpecificBehavior {
        private HTMLElementImpl _element;

        public DefaultBehavior(HTMLElementImpl element) {
            this._element = element;
        }

        public String getValue() {
            return HTMLInputElementImpl.this._value != null ? HTMLInputElementImpl.this._value : HTMLInputElementImpl.this.getDefaultValue();
        }

        public void setValue(String value) {
            if (HTMLInputElementImpl.equals(value, HTMLInputElementImpl.this._value)) {
                return;
            }
            HTMLInputElementImpl.this._value = value;
            this.reportPropertyChanged("value");
        }

        public boolean getChecked() {
            return HTMLInputElementImpl.this.getDefaultChecked();
        }

        public void setChecked(boolean checked) {
        }

        public void reset() {
        }

        public void click() {
        }

        protected void reportPropertyChanged(String propertyName) {
            this._element.reportPropertyChanged(propertyName);
        }

        public void addValues(String name, ParameterProcessor processor, String characterSet) throws IOException {
            processor.addParameter(name, this.getValue(), characterSet);
        }

        public void silenceSubmitButton() {
        }
    }

    static interface TypeSpecificBehavior {
        public void setValue(String var1);

        public String getValue();

        public void reset();

        public void click();

        public boolean getChecked();

        public void setChecked(boolean var1);

        public void addValues(String var1, ParameterProcessor var2, String var3) throws IOException;

        public void silenceSubmitButton();
    }
}

