/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLControl;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLTextAreaElement;

public class HTMLTextAreaElementImpl
extends HTMLControl
implements HTMLTextAreaElement {
    private String _value;

    ElementImpl create() {
        return new HTMLTextAreaElementImpl();
    }

    public void blur() {
        this.handleEvent("onblur");
    }

    public void focus() {
        this.handleEvent("onfocus");
    }

    public String getAccessKey() {
        return this.getAttributeWithNoDefault("accesskey");
    }

    public int getCols() {
        return this.getIntegerAttribute("cols");
    }

    public String getDefaultValue() {
        Node node = this.getFirstChild();
        if (node == null) {
            return "";
        }
        if (node.getNodeType() != 3) {
            return null;
        }
        return node.getNodeValue();
    }

    public int getRows() {
        return this.getIntegerAttribute("rows");
    }

    public void select() {
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute("accesskey", accessKey);
    }

    public void setCols(int cols) {
        this.setAttribute("cols", cols);
    }

    public void setDefaultValue(String defaultValue) {
        Text textNode = this.getOwnerDocument().createTextNode(defaultValue);
        Node child = this.getFirstChild();
        if (child == null) {
            this.appendChild(textNode);
        } else {
            this.replaceChild(textNode, child);
        }
    }

    public void setRows(int rows) {
        this.setAttribute("rows", rows);
    }

    public String getValue() {
        return this._value != null ? this._value : this.getDefaultValue();
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void reset() {
        this._value = null;
    }
}

