/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLTitleElement;

public class HTMLTitleElementImpl
extends HTMLElementImpl
implements HTMLTitleElement {
    ElementImpl create() {
        return new HTMLTitleElementImpl();
    }

    public String getText() {
        Text contentNode = this.getContentNode();
        return contentNode == null ? "" : contentNode.getData();
    }

    private Text getContentNode() {
        NodeList childNodes = this.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 3) continue;
            return (Text)childNodes.item(i);
        }
        return null;
    }

    public void setText(String text) {
        Text newChild = this.getOwnerDocument().createTextNode(text);
        Text oldChild = this.getContentNode();
        if (oldChild == null) {
            this.appendChild(newChild);
        } else {
            this.replaceChild(newChild, oldChild);
        }
    }
}

