/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.javascript;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.ScriptException;
import com.meterware.httpunit.javascript.JavaScript;
import com.meterware.httpunit.scripting.ScriptingEngine;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public abstract class ScriptingEngineImpl
extends ScriptableObject
implements ScriptingEngine {
    private static final Object[] NO_ARGS = new Object[0];
    private static ArrayList _errorMessages = new ArrayList();

    public static void clearErrorMessages() {
        _errorMessages.clear();
    }

    public static String[] getErrorMessages() {
        return _errorMessages.toArray(new String[_errorMessages.size()]);
    }

    public static void handleScriptException(Exception e, String badScript) {
        String errorMessage;
        String string = errorMessage = badScript == null ? e.getMessage() : badScript + " failed: " + e;
        if (e instanceof EcmaError || e instanceof EvaluatorException || e instanceof ScriptException || e instanceof JavaScriptException) {
            if (JavaScript.isThrowExceptionsOnError()) {
                HttpUnitUtils.handleException(e);
                if (e instanceof ScriptException) {
                    throw (ScriptException)e;
                }
                throw new ScriptException(errorMessage);
            }
        } else {
            HttpUnitUtils.handleException(e);
            throw new RuntimeException(errorMessage);
        }
        _errorMessages.add(errorMessage);
    }

    public boolean supportsScriptLanguage(String language) {
        return language == null || language.toLowerCase().startsWith("javascript");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runScript(String language, String script) {
        if (!this.supportsScriptLanguage(language)) {
            return "";
        }
        try {
            script = script.trim();
            if (script.startsWith("<!--") && (script = this.withoutFirstLine(script)).endsWith("-->")) {
                script = script.substring(0, script.lastIndexOf("-->"));
            }
            Context context = Context.enter();
            context.initStandardObjects(null);
            context.evaluateString((Scriptable)this, script, "httpunit", 0, null);
            String string = this.getDocumentWriteBuffer();
            return string;
        }
        catch (Exception e) {
            ScriptingEngineImpl.handleScriptException(e, "Script '" + script + "'");
            String string = "";
            return string;
        }
        finally {
            this.discardDocumentWriteBuffer();
            Context.exit();
        }
    }

    public boolean doEvent(String eventScript) {
        return this.doEventScript(eventScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doEventScript(String eventScript) {
        if (eventScript.length() == 0) {
            return true;
        }
        try {
            Context context = Context.enter();
            context.initStandardObjects(null);
            context.setOptimizationLevel(-1);
            Function f = context.compileFunction((Scriptable)this, "function x() { " + eventScript + "}", "httpunit", 0, null);
            Object result = f.call(context, (Scriptable)this, (Scriptable)this, NO_ARGS);
            boolean bl = !(result instanceof Boolean) || (Boolean)result != false;
            return bl;
        }
        catch (Exception e) {
            ScriptingEngineImpl.handleScriptException(e, "Event '" + eventScript + "'");
            boolean bl = false;
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    public boolean handleEvent(String eventName) {
        throw new RuntimeException("pseudo - abstract handleEvent called ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateExpression(String expression) {
        try {
            Context context = Context.enter();
            context.initStandardObjects(null);
            Object result = context.evaluateString((Scriptable)this, expression, "httpunit", 0, null);
            Object object = result == null || result instanceof Undefined ? null : result;
            return object;
        }
        catch (Exception e) {
            ScriptingEngineImpl.handleScriptException(e, "URL '" + expression + "'");
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            Context.exit();
        }
    }

    protected String getDocumentWriteBuffer() {
        throw new IllegalStateException("may not run runScript() from " + this.getClass());
    }

    protected void discardDocumentWriteBuffer() {
        throw new IllegalStateException("may not run runScript() from " + this.getClass());
    }

    private String withoutFirstLine(String script) {
        for (int i = 0; i < script.length(); ++i) {
            if (!this.isLineTerminator(script.charAt(i))) continue;
            return script.substring(i).trim();
        }
        return "";
    }

    private boolean isLineTerminator(char c) {
        return c == '\n' || c == '\r';
    }
}

