/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.protocol;

import com.meterware.httpunit.protocol.MessageBody;
import com.meterware.httpunit.protocol.ParameterCollection;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.protocol.UploadFileSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class MimeEncodedMessageBody
extends MessageBody {
    private static final String BOUNDARY = "--HttpUnit-part0-aSgQ2M";
    private static final byte[] CRLF = new byte[]{13, 10};

    MimeEncodedMessageBody(String characterSet) {
        super(characterSet);
    }

    public String getContentType() {
        return "multipart/form-data; boundary=--HttpUnit-part0-aSgQ2M";
    }

    public void writeTo(OutputStream outputStream, ParameterCollection parameters) throws IOException {
        MimeEncoding encoding = new MimeEncoding(outputStream);
        parameters.recordParameters(encoding);
        encoding.sendClose();
    }

    private String encode(String string) {
        char[] chars = string.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 20);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    private void writeLn(OutputStream os, String value, String encoding) throws IOException {
        os.write(value.getBytes(encoding));
        os.write(CRLF);
    }

    private void writeLn(OutputStream os, String value) throws IOException {
        this.writeLn(os, value, this.getCharacterSet());
    }

    class MimeEncoding
    implements ParameterProcessor {
        private static final char CR = '\r';
        private static final char LF = '\n';
        private OutputStream _outputStream;

        public MimeEncoding(OutputStream outputStream) {
            this._outputStream = outputStream;
        }

        public void sendClose() throws IOException {
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "----HttpUnit-part0-aSgQ2M--");
        }

        public void addParameter(String name, String value, String characterSet) throws IOException {
            if (name == null || name.length() == 0) {
                return;
            }
            if (value == null) {
                return;
            }
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "----HttpUnit-part0-aSgQ2M");
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "Content-Disposition: form-data; name=\"" + name + '\"');
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "Content-Type: text/plain; charset=" + MimeEncodedMessageBody.this.getCharacterSet());
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "");
            MimeEncodedMessageBody.this.writeLn(this._outputStream, this.fixLineEndings(value), MimeEncodedMessageBody.this.getCharacterSet());
        }

        private String fixLineEndings(String value) {
            StringBuffer sb = new StringBuffer();
            char[] chars = value.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\r' || chars[i] == '\n' && (i == 0 || chars[i - 1] != '\r')) {
                    sb.append('\r').append('\n');
                    continue;
                }
                sb.append(chars[i]);
            }
            return sb.toString();
        }

        public void addFile(String name, UploadFileSpec spec) throws IOException {
            byte[] buffer = new byte[8192];
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "----HttpUnit-part0-aSgQ2M");
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "Content-Disposition: form-data; name=\"" + MimeEncodedMessageBody.this.encode(name) + "\"; filename=\"" + MimeEncodedMessageBody.this.encode(spec.getFileName()) + '\"');
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "Content-Type: " + spec.getContentType());
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "");
            InputStream in = spec.getInputStream();
            int count = 0;
            do {
                this._outputStream.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            in.close();
            MimeEncodedMessageBody.this.writeLn(this._outputStream, "");
        }
    }
}

