/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.pseudoserver.HttpRequest;
import com.meterware.pseudoserver.HttpResponseStream;
import com.meterware.pseudoserver.PseudoServlet;
import com.meterware.pseudoserver.UnknownMethodException;
import com.meterware.pseudoserver.WebResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PseudoServer {
    public static final boolean useFactory = false;
    static final int DEFAULT_SOCKET_TIMEOUT = 1000;
    private static final int INPUT_POLL_INTERVAL = 10;
    private static int _socketReleaseWaitTime = 50;
    private static int _waitThreshhold = 10;
    private static int _numServers = 0;
    private int _serverNum = 0;
    private int _connectionNum = 0;
    private ArrayList _classpathDirs = new ArrayList();
    private String _maxProtocolLevel = "1.1";
    private final int _socketTimeout;
    private Hashtable _resources = new Hashtable();
    private boolean _active = true;
    private boolean _debug = false;
    private ServerSocket _serverSocket;

    public static int getSocketReleaseWaitTime() {
        return _socketReleaseWaitTime;
    }

    public static void setSocketReleaseWaitTime(int socketReleaseWaitTime) {
        _socketReleaseWaitTime = socketReleaseWaitTime;
    }

    public static int getWaitThreshhold() {
        return _waitThreshhold;
    }

    public static void setWaitThreshhold(int waitThreshhold) {
        _waitThreshhold = waitThreshhold;
    }

    public PseudoServer() {
        this(1000);
    }

    public PseudoServer(int socketTimeout) {
        this._socketTimeout = socketTimeout;
        this._serverNum = ++_numServers;
        try {
            this._serverSocket = new ServerSocket(0);
            this._serverSocket.setSoTimeout(1000);
        }
        catch (IOException e) {
            System.out.println("Error while creating socket: " + e);
            throw new RuntimeException(e);
        }
        Thread t = new Thread("PseudoServer " + this._serverNum){

            public void run() {
                while (PseudoServer.this._active) {
                    try {
                        PseudoServer.this.handleNewConnection(PseudoServer.this._serverSocket.accept());
                        Thread.sleep(20L);
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        System.out.println("Error in pseudo server: " + e);
                        HttpUnitUtils.handleException(e);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted. Shutting down");
                        PseudoServer.this._active = false;
                    }
                }
                try {
                    PseudoServer.this._serverSocket.close();
                }
                catch (IOException e) {
                    System.out.println("Error while closing socket: " + e);
                }
                PseudoServer.this.debug("Pseudoserver shutting down");
            }
        };
        this.debug("Starting pseudoserver");
        t.start();
    }

    public void shutDown() {
        this.debug("Requested shutdown of pseudoserver");
        this._active = false;
    }

    private void debug(String message) {
        if (!this._debug) {
            return;
        }
        message = PseudoServer.replaceDebugToken(message, "thread", "thread (" + Thread.currentThread().getName() + ")");
        message = PseudoServer.replaceDebugToken(message, "server", "server " + this._serverNum);
        System.out.println("** " + message);
    }

    private static String replaceDebugToken(String message, String token, String replacement) {
        return !message.contains(token) ? message : message.replaceFirst(token, replacement);
    }

    public void setMaxProtocolLevel(int majorLevel, int minorLevel) {
        this._maxProtocolLevel = majorLevel + "." + minorLevel;
    }

    public int getConnectedPort() throws IOException {
        return this._serverSocket.getLocalPort();
    }

    public void setResource(String name, String value) {
        this.setResource(name, value, "text/html");
    }

    public void setResource(String name, PseudoServlet servlet) {
        this._resources.put(this.asResourceName(name), servlet);
    }

    public void setResource(String name, String value, String contentType) {
        this._resources.put(this.asResourceName(name), new WebResource(value, contentType));
    }

    public void setResource(String name, byte[] value, String contentType) {
        this._resources.put(this.asResourceName(name), new WebResource(value, contentType));
    }

    public WebResource setErrorResource(String name, int errorCode, String errorMessage) {
        WebResource resource = new WebResource(errorMessage, errorCode);
        this._resources.put(this.asResourceName(name), resource);
        return resource;
    }

    public void setSendCharacterSet(String name, boolean enabled) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            throw new IllegalArgumentException("No defined resource " + name);
        }
        resource.setSendCharacterSet(enabled);
    }

    public void setCharacterSet(String name, String characterSet) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            resource = new WebResource("");
            this._resources.put(this.asResourceName(name), resource);
        }
        resource.setCharacterSet(characterSet);
    }

    public void addResourceHeader(String name, String header) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            resource = new WebResource("");
            this._resources.put(this.asResourceName(name), resource);
        }
        resource.addHeader(header);
    }

    public void mapToClasspath(String directory) {
        this._classpathDirs.add(directory);
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    private String asResourceName(String rawName) {
        if (rawName.startsWith("http:") || rawName.startsWith("/")) {
            return PseudoServer.escape(rawName);
        }
        return PseudoServer.escape("/" + rawName);
    }

    private static String escape(String urlString) {
        if (urlString.indexOf(32) < 0) {
            return urlString;
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while (true) {
            int index;
            if ((index = urlString.indexOf(32, start)) < 0) break;
            sb.append(urlString.substring(start, index)).append("%20");
            start = index + 1;
        }
        sb.append(urlString.substring(start));
        return sb.toString();
    }

    private void handleNewConnection(final Socket socket) {
        Thread t = new Thread("PseudoServer " + this._serverNum + " connection " + ++this._connectionNum){

            public void run() {
                try {
                    PseudoServer.this.serveRequests(socket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void serveRequests(Socket socket) throws IOException {
        socket.setSoTimeout(this._socketTimeout);
        socket.setTcpNoDelay(true);
        this.debug("Created server thread " + socket.getInetAddress() + ':' + socket.getPort());
        BufferedInputStream inputStream = new BufferedInputStream(socket.getInputStream());
        HttpResponseStream outputStream = new HttpResponseStream(socket.getOutputStream());
        try {
            HttpRequest request;
            boolean keepAlive;
            while (this._active && (keepAlive = this.respondToRequest(request = new HttpRequest(inputStream), outputStream))) {
                while (this._active && 0 == inputStream.available()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        catch (IOException e) {
            outputStream.restart();
            outputStream.setProtocol("HTTP/1.0");
            outputStream.setResponse(400, e.toString());
        }
        this.debug("Closing server thread");
        outputStream.close();
        socket.close();
        this.debug("Server thread closed");
    }

    private boolean respondToRequest(HttpRequest request, HttpResponseStream response) {
        this.debug("Server thread handling request: " + request);
        boolean keepAlive = this.isKeepAlive(request);
        WebResource resource = null;
        try {
            response.restart();
            response.setProtocol(this.getResponseProtocol(request));
            resource = this.getResource(request);
            if (resource == null) {
                String uri = request.getURI();
                int errorCode = 404;
                String errorMessage = "unable to find " + uri;
                resource = this.setErrorResource(uri, errorCode, errorMessage);
                response.setResponse(errorCode, errorMessage);
            } else if (resource.getResponseCode() != 200) {
                response.setResponse(resource.getResponseCode(), "");
            }
            if (resource.closesConnection()) {
                keepAlive = false;
            }
            String[] headers = resource.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                this.debug("Server thread sending header: " + headers[i]);
                response.addHeader(headers[i]);
            }
        }
        catch (UnknownMethodException e) {
            response.setResponse(405, "unsupported method: " + e.getMethod());
        }
        catch (Throwable t) {
            t.printStackTrace();
            response.setResponse(500, t.toString());
        }
        try {
            response.write(resource);
        }
        catch (IOException e) {
            System.out.println("*** Failed to send reply: " + e);
        }
        return keepAlive;
    }

    private boolean isKeepAlive(HttpRequest request) {
        return request.wantsKeepAlive() && this._maxProtocolLevel.equals("1.1");
    }

    private String getResponseProtocol(HttpRequest request) {
        return this._maxProtocolLevel.equalsIgnoreCase("1.1") ? request.getProtocol() : "HTTP/1.0";
    }

    private WebResource getResource(HttpRequest request) throws IOException {
        String command;
        Object resource = this._resources.get(request.getURI());
        if (resource == null) {
            resource = this._resources.get(this.withoutParameters(request.getURI()));
        }
        if (((command = request.getCommand()).equals("GET") || command.equals("HEAD")) && resource instanceof WebResource) {
            return (WebResource)resource;
        }
        if (resource instanceof PseudoServlet) {
            return this.getResource((PseudoServlet)resource, request);
        }
        if (request.getURI().endsWith(".class")) {
            for (String directory : this._classpathDirs) {
                if (!request.getURI().startsWith(directory)) continue;
                String resourceName = request.getURI().substring(directory.length() + 1);
                return new WebResource(this.getClass().getClassLoader().getResourceAsStream(resourceName), "application/class", 200);
            }
            return null;
        }
        if (request.getURI().endsWith(".zip") || request.getURI().endsWith(".jar")) {
            for (String directory : this._classpathDirs) {
                if (!request.getURI().startsWith(directory)) continue;
                String resourceName = request.getURI().substring(directory.length() + 1);
                String classPath = System.getProperty("java.class.path");
                StringTokenizer st = new StringTokenizer(classPath, ":;,");
                while (st.hasMoreTokens()) {
                    String file = st.nextToken();
                    if (!file.endsWith(resourceName)) continue;
                    File f = new File(file);
                    return new WebResource(new FileInputStream(f), "application/zip", 200);
                }
            }
            return null;
        }
        return null;
    }

    private String withoutParameters(String uri) {
        return uri.indexOf(63) < 0 ? uri : uri.substring(0, uri.indexOf(63));
    }

    private WebResource getResource(PseudoServlet servlet, HttpRequest request) throws IOException {
        servlet.init(request);
        return servlet.getResponse(request.getCommand());
    }
}

