/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.pseudoserver.PseudoServer;
import com.meterware.pseudoserver.PseudoServlet;
import java.io.IOException;
import org.junit.rules.ExternalResource;

public class PseudoServerTestSupport
extends ExternalResource {
    private String _hostPath;
    private PseudoServer _server;

    public void before() throws Throwable {
        this.setUpServer();
    }

    public void after() {
        this.tearDownServer();
    }

    public void setUpServer() throws IOException {
        this._server = new PseudoServer();
        this._hostPath = "http://localhost:" + this._server.getConnectedPort();
    }

    public void tearDownServer() {
        if (this._server != null) {
            this._server.shutDown();
        }
    }

    public void mapToClasspath(String directory) {
        this._server.mapToClasspath(directory);
    }

    public void defineResource(String resourceName, PseudoServlet servlet) {
        this._server.setResource(resourceName, servlet);
    }

    public void defineResource(String resourceName, String value) {
        this._server.setResource(resourceName, value);
    }

    public void defineResource(String resourceName, byte[] value, String contentType) {
        this._server.setResource(resourceName, value, contentType);
    }

    public void defineResource(String resourceName, String value, int statusCode) {
        this._server.setErrorResource(resourceName, statusCode, value);
    }

    public void defineResource(String resourceName, String value, String contentType) {
        this._server.setResource(resourceName, value, contentType);
    }

    public void addResourceHeader(String resourceName, String header) {
        this._server.addResourceHeader(resourceName, header);
    }

    public void setResourceCharSet(String resourceName, String setName, boolean reportCharSet) {
        this._server.setCharacterSet(resourceName, setName);
        this._server.setSendCharacterSet(resourceName, reportCharSet);
    }

    public void defineWebPage(String xmlns, String pageName, String body) {
        String preamble = "";
        if (xmlns == null) {
            xmlns = "";
        } else {
            preamble = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n";
            preamble = preamble + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
            xmlns = " xmlns=\"" + xmlns + "\"";
        }
        this.defineResource(pageName + ".html", preamble + "<html" + xmlns + ">\n<head><title>" + pageName + "</title></head>\n" + "<body>\n" + body + "\n</body>\n</html>");
    }

    public void defineWebPage(String pageName, String body) {
        this.defineWebPage(null, pageName, body);
    }

    public PseudoServer getServer() {
        return this._server;
    }

    public void setServerDebug(boolean enabled) {
        this._server.setDebug(enabled);
    }

    public String getHostPath() {
        return this._hostPath;
    }

    public int getHostPort() throws IOException {
        return this._server.getConnectedPort();
    }
}

