/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.httpunit.HttpUnitUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class WebResource {
    static final String DEFAULT_CONTENT_TYPE = "text/html";
    static final String DEFAULT_CHARACTER_SET = "iso-8859-1";
    private boolean _closesConnection;
    private byte[] _contents;
    private String _string;
    private InputStream _stream;
    private int _responseCode;
    private boolean _sendCharacterSet;
    private String _contentType = "text/html";
    private String _characterSet = "iso-8859-1";
    private boolean _hasExplicitContentTypeHeader;
    private boolean _hasExplicitContentLengthHeader;
    private Vector _headers = new Vector();
    private boolean _isChunked;

    public WebResource(String contents) {
        this(contents, DEFAULT_CONTENT_TYPE);
    }

    public WebResource(String contents, String contentType) {
        this(contents, contentType, 200);
    }

    public WebResource(byte[] contents, String contentType) {
        this(contents, contentType, 200);
    }

    public void addHeader(String header) {
        this._headers.addElement(header);
        if (header.toLowerCase().startsWith("content-type")) {
            this._hasExplicitContentTypeHeader = true;
        }
        if (header.toLowerCase().startsWith("content-length")) {
            this._hasExplicitContentLengthHeader = true;
        }
        if (header.trim().toLowerCase().startsWith("connection") && header.trim().toLowerCase().endsWith("close")) {
            this._closesConnection = true;
        }
        if (header.trim().toLowerCase().startsWith("transfer-encoding") && header.trim().toLowerCase().endsWith("chunked")) {
            this._isChunked = true;
        }
    }

    public void setCharacterSet(String characterSet) {
        this._characterSet = characterSet;
    }

    public void setSendCharacterSet(boolean enabled) {
        this._sendCharacterSet = enabled;
    }

    public void suppressAutomaticLengthHeader() {
        this._hasExplicitContentLengthHeader = true;
    }

    public void suppressAutomaticContentTypeHeader() {
        this._hasExplicitContentTypeHeader = true;
    }

    public WebResource(String contents, int responseCode) {
        this(contents, DEFAULT_CONTENT_TYPE, responseCode);
    }

    public WebResource(String contents, String contentType, int responseCode) {
        this._string = contents;
        this._contentType = contentType;
        this._responseCode = responseCode;
    }

    public WebResource(byte[] contents, String contentType, int responseCode) {
        this._contents = contents;
        this._contentType = contentType;
        this._responseCode = responseCode;
    }

    public WebResource(InputStream stream, String contentType, int responseCode) {
        this._stream = stream;
        this._contentType = contentType;
        this._responseCode = responseCode;
        this.addHeader("Connection: close");
    }

    String[] getHeaders() throws UnsupportedEncodingException {
        Vector effectiveHeaders = (Vector)this._headers.clone();
        if (!this._hasExplicitContentTypeHeader) {
            effectiveHeaders.add(this.getContentTypeHeader());
        }
        if (this._stream == null && !this._hasExplicitContentLengthHeader && !this.isChunked()) {
            effectiveHeaders.add(this.getContentLengthHeader());
        }
        Object[] headers = new String[effectiveHeaders.size()];
        effectiveHeaders.copyInto(headers);
        return headers;
    }

    private boolean isChunked() {
        return this._isChunked;
    }

    boolean closesConnection() {
        return this._closesConnection;
    }

    void writeTo(OutputStream outputStream) throws IOException {
        if (this._stream == null) {
            outputStream.write(this.getContentsAsBytes());
        } else if (this._stream != null) {
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                outputStream.write(buffer, 0, count);
            } while ((count = this._stream.read(buffer, 0, buffer.length)) != -1);
        }
    }

    static String toString(byte[] contentsAsBytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < contentsAsBytes.length; ++i) {
            byte contentsAsByte = contentsAsBytes[i];
            sb.append(Integer.toHexString(contentsAsByte)).append(' ');
        }
        return sb.toString();
    }

    private byte[] getContentsAsBytes() throws UnsupportedEncodingException {
        if (this._contents != null) {
            return this._contents;
        }
        if (this._string != null) {
            return this._string.getBytes(this.getCharacterSet());
        }
        throw new IllegalStateException("Cannot get bytes from stream");
    }

    private String getContentTypeHeader() {
        return "Content-Type: " + this._contentType + this.getCharacterSetParameter();
    }

    private String getContentLengthHeader() throws UnsupportedEncodingException {
        return "Content-Length: " + this.getContentsAsBytes().length;
    }

    String getCharacterSet() {
        return HttpUnitUtils.stripQuotes(this._characterSet);
    }

    String getCharacterSetParameter() {
        if (!this._sendCharacterSet) {
            return "";
        }
        return "; charset=" + this._characterSet;
    }

    int getResponseCode() {
        return this._responseCode;
    }

    public String toString() {
        return "WebResource [code=" + this._responseCode + "; type = " + this._contentType + "; charset = " + this._characterSet + "]\n" + this.getContentsAsString();
    }

    private String getContentsAsString() {
        if (this._string != null) {
            return this._string;
        }
        return "<< hex bytes >>";
    }
}

