/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.Base64;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.servletunit.RequestContext;
import com.meterware.servletunit.ServletInputStreamImpl;
import com.meterware.servletunit.ServletMetaData;
import com.meterware.servletunit.ServletUnitContext;
import com.meterware.servletunit.ServletUnitHttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class ServletUnitHttpRequest
implements HttpServletRequest {
    private ServletInputStreamImpl _inputStream;
    private String _contentType;
    private Vector _locales;
    private String _protocol;
    private boolean _secure;
    private RequestContext _requestContext;
    private String _charset;
    private boolean _gotReader;
    private boolean _gotInputStream;
    private BufferedReader _reader;
    private int _serverPort;
    private String _serverName;
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private WebRequest _request;
    private ServletMetaData _servletRequest;
    private WebClient.HeaderDictionary _headers;
    private ServletUnitContext _context;
    private ServletUnitHttpSession _session;
    private Hashtable _attributes = new Hashtable();
    private Vector _cookies = new Vector();
    private String _sessionID;
    private byte[] _messageBody;
    private String _userName;
    private String[] _roles;

    ServletUnitHttpRequest(ServletMetaData servletRequest, WebRequest request, ServletUnitContext context, Dictionary clientHeaders, byte[] messageBody) throws MalformedURLException {
        boolean setBody;
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        this._servletRequest = servletRequest;
        this._request = request;
        this._context = context;
        this._headers = new WebClient.HeaderDictionary();
        this._headers.addEntries(clientHeaders);
        this._headers.addEntries(request.getHeaders());
        this.setCookiesFromHeader(this._headers);
        this._messageBody = messageBody;
        this._protocol = request.getURL().getProtocol().toLowerCase();
        this._secure = this._protocol.endsWith("s");
        this._serverName = request.getURL().getHost();
        this._serverPort = request.getURL().getPort();
        if (this._serverPort == -1) {
            this._serverPort = request.getURL().getDefaultPort();
        }
        this._requestContext = new RequestContext(request.getURL());
        String contentTypeHeader = (String)this._headers.get("Content-Type");
        if (contentTypeHeader != null) {
            String[] res = HttpUnitUtils.parseContentTypeHeader(contentTypeHeader);
            this._contentType = res[0];
            this._charset = res[1];
            this._requestContext.setMessageEncoding(this._charset);
        }
        if (this._headers.get("Content-Length") == null) {
            this._headers.put("Content-Length", Integer.toString(messageBody.length));
        }
        boolean bl = setBody = this._messageBody != null && (contentTypeHeader == null || contentTypeHeader.indexOf("x-www-form-urlencoded") >= 0);
        if (setBody) {
            this._requestContext.setMessageBody(this._messageBody);
        }
    }

    public String getAuthType() {
        return null;
    }

    public String getQueryString() {
        return this._request.getQueryString();
    }

    public Cookie[] getCookies() {
        if (this._cookies.size() == 0) {
            return null;
        }
        Object[] result = new Cookie[this._cookies.size()];
        this._cookies.copyInto(result);
        return result;
    }

    public int getIntHeader(String name) {
        return Integer.parseInt(this.getHeader(name));
    }

    public long getDateHeader(String name) {
        try {
            String dateString = this.getHeader(name);
            Date headerDate = new Date(dateString);
            return headerDate.getTime();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getHeader(String name) {
        return (String)this._headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return this._headers.keys();
    }

    public String getServletPath() {
        return this._servletRequest.getServletPath();
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public String getPathInfo() {
        return this._servletRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._sessionID != null;
    }

    public String getRemoteUser() {
        return this._userName;
    }

    public String getRequestedSessionId() {
        return this._sessionID;
    }

    public String getRequestURI() {
        return this._requestContext.getRequestURI();
    }

    public HttpSession getSession(boolean create) {
        this._session = this._context.getValidSession(this.getRequestedSessionId(), this._session, create);
        return this._session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public int getContentLength() {
        return this.getIntHeader("Content-length");
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.keys();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._gotReader) {
            throw new IllegalStateException("getReader() has already been called for this request");
        }
        this.initializeInputStream();
        this._gotInputStream = true;
        return this._inputStream;
    }

    private void initializeInputStream() {
        if (this._inputStream == null) {
            this._inputStream = new ServletInputStreamImpl(this._messageBody);
        }
    }

    public String getCharacterEncoding() {
        return this._charset;
    }

    public Enumeration getParameterNames() {
        return this._requestContext.getParameterNames();
    }

    public String getContentType() {
        String result = this._contentType;
        result = this.getHeader("Content-Type");
        return result;
    }

    public String getParameter(String name) {
        String[] parameters = this.getParameterValues(name);
        return parameters == null ? null : parameters[0];
    }

    public String[] getParameterValues(String name) {
        return this._requestContext.getParameterValues(name);
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        String result = this.isSecure() ? "https" : "http";
        result = this._protocol;
        return result;
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getRealPath(String path) {
        this.throwNotImplementedYet();
        return "";
    }

    public BufferedReader getReader() throws IOException {
        if (this._gotInputStream) {
            throw new IllegalStateException("getInputStream() has already been called on this request");
        }
        if (this._reader == null) {
            this.initializeInputStream();
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "iso-8859-1";
            }
            this._reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this._inputStream), encoding));
            this._gotReader = true;
        }
        return this._reader;
    }

    public String getRemoteAddr() {
        return LOOPBACK_ADDRESS;
    }

    public void setAttribute(String key, Object o) {
        if (o == null) {
            this._attributes.remove(key);
        } else {
            this._attributes.put(key, o);
        }
    }

    public boolean isSecure() {
        return this._secure;
    }

    public Locale getLocale() {
        return (Locale)this.getPreferredLocales().firstElement();
    }

    public Enumeration getLocales() {
        return this.getPreferredLocales().elements();
    }

    private Vector getPreferredLocales() {
        if (this._locales == null) {
            this._locales = new Vector();
            String languages = this.getHeader("accept-language");
            if (languages == null) {
                this._locales.add(Locale.getDefault());
            } else {
                StringTokenizer st = new StringTokenizer(languages, ",");
                ArrayList<PrioritizedLocale> al = new ArrayList<PrioritizedLocale>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    al.add(new PrioritizedLocale(token));
                }
                Collections.sort(al);
                Iterator iterator = al.iterator();
                while (iterator.hasNext()) {
                    this._locales.add(((PrioritizedLocale)iterator.next()).getLocale());
                }
            }
        }
        return this._locales;
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        try {
            if (!path.startsWith("/")) {
                path = this.combinedPath(this.getServletPath(), path);
            }
            return this._servletRequest.getServlet().getServletConfig().getServletContext().getRequestDispatcher(path);
        }
        catch (ServletException e) {
            return null;
        }
    }

    private String combinedPath(String basePath, String relativePath) {
        if (basePath.indexOf(47) < 0) {
            return relativePath;
        }
        return basePath.substring(0, basePath.lastIndexOf(47)) + '/' + relativePath;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String role) {
        if (this._roles == null) {
            return false;
        }
        for (int i = 0; i < this._roles.length; ++i) {
            if (!role.equals(this._roles[i])) continue;
            return true;
        }
        return false;
    }

    public Enumeration getHeaders(String name) {
        Vector<Object> list = new Vector<Object>();
        if (this._headers.containsKey(name)) {
            list.add(this._headers.get(name));
        }
        return list.elements();
    }

    public String getContextPath() {
        return this._context.getContextPath();
    }

    public Map getParameterMap() {
        return this._requestContext.getParameterMap();
    }

    public void setCharacterEncoding(String charset) throws UnsupportedEncodingException {
        this._charset = charset;
        this._requestContext.setMessageEncoding(charset);
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        try {
            url.append(this._request.getURL().getProtocol()).append("://");
            url.append(this._request.getURL().getHost());
            String portPortion = this._request.getURL().getPort() == -1 ? "" : ":" + this._request.getURL().getPort();
            url.append(portPortion);
            url.append(this._request.getURL().getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("unable to read URL from request: " + this._request);
        }
        return url;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return "localhost";
    }

    public String getLocalAddr() {
        return LOOPBACK_ADDRESS;
    }

    public int getLocalPort() {
        return 0;
    }

    private void addCookie(Cookie cookie) {
        this._cookies.addElement(cookie);
        if (cookie.getName().equalsIgnoreCase("JSESSION")) {
            this._sessionID = cookie.getValue();
        }
    }

    private ServletUnitHttpSession getServletSession() {
        return (ServletUnitHttpSession)this.getSession();
    }

    void readFormAuthentication() {
        if (this.getSession(false) != null) {
            this.recordAuthenticationInfo(this.getServletSession().getUserName(), this.getServletSession().getRoles());
        }
    }

    void readBasicAuthentication() {
        String authorizationHeader = (String)this._headers.get("Authorization");
        if (authorizationHeader != null) {
            String userAndPassword = Base64.decode(authorizationHeader.substring(authorizationHeader.indexOf(32) + 1));
            int colonPos = userAndPassword.indexOf(58);
            this.recordAuthenticationInfo(userAndPassword.substring(0, colonPos), ServletUnitHttpRequest.toArray(userAndPassword.substring(colonPos + 1)));
        }
    }

    static String[] toArray(String roleList) {
        StringTokenizer st = new StringTokenizer(roleList, ",");
        String[] result = new String[st.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = st.nextToken();
        }
        return result;
    }

    void recordAuthenticationInfo(String userName, String[] roles) {
        this._userName = userName;
        this._roles = roles;
    }

    private void throwNotImplementedYet() {
        throw new RuntimeException("Not implemented yet");
    }

    private void setCookiesFromHeader(Dictionary clientHeaders) {
        String cookieHeader = (String)clientHeaders.get("Cookie");
        if (cookieHeader == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(cookieHeader, ",;=", true);
        String lastToken = st.nextToken();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("=") && st.hasMoreTokens()) {
                this.addCookie(new Cookie(lastToken.trim(), st.nextToken().trim()));
            }
            lastToken = token;
        }
    }

    static class PrioritizedLocale
    implements Comparable {
        private Locale _locale;
        private float _priority;

        PrioritizedLocale(String languageSpec) {
            int semiIndex = languageSpec.indexOf(59);
            if (semiIndex < 0) {
                this._priority = 1.0f;
                this._locale = this.parseLocale(languageSpec);
            } else {
                this._priority = Float.parseFloat(languageSpec.substring(languageSpec.indexOf(61, semiIndex) + 1));
                this._locale = this.parseLocale(languageSpec.substring(0, semiIndex));
            }
        }

        private Locale parseLocale(String range) {
            int dashIndex = (range = range.trim()).indexOf(45);
            if (dashIndex < 0) {
                return new Locale(range, "");
            }
            return new Locale(range.substring(0, dashIndex), range.substring(dashIndex + 1));
        }

        public Locale getLocale() {
            return this._locale;
        }

        public int compareTo(Object o) {
            if (!(o instanceof PrioritizedLocale)) {
                throw new IllegalArgumentException("may only combine with other prioritized locales");
            }
            PrioritizedLocale other = (PrioritizedLocale)o;
            return this._priority == other._priority ? this._locale.getLanguage().compareTo(other._locale.getLanguage()) : (this._priority < other._priority ? 1 : -1);
        }
    }
}

