/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.milyn.reflect.MethodCall;

public class MethodInvocationProxyHandler<T>
implements InvocationHandler {
    private T object;
    private List<MethodCall> callList = new ArrayList<MethodCall>();
    private Map<String, List<MethodCall>> callMap = new LinkedHashMap<String, List<MethodCall>>();

    public MethodInvocationProxyHandler(T object) {
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public T newProxy(Class[] interfaces) {
        return (T)Proxy.newProxyInstance(MethodInvocationProxyHandler.class.getClassLoader(), interfaces, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.logCall(method, args);
        return method.invoke(this.object, new Object[0]);
    }

    private synchronized void logCall(Method method, Object[] args) {
        Exception thisCallStack = new Exception();
        MethodCall methodCall = new MethodCall(this.callList.size(), thisCallStack, args);
        this.callList.add(methodCall);
        this.getCallList(method.getName()).add(methodCall);
    }

    public List<MethodCall> getCallList() {
        return this.callList;
    }

    public synchronized List<MethodCall> getCallList(String methodName) {
        List<MethodCall> methodCallList = this.callMap.get(methodName);
        if (methodCallList == null) {
            methodCallList = new ArrayList<MethodCall>();
            this.callMap.put(methodName, methodCallList);
        }
        return methodCallList;
    }

    public Map<String, List<MethodCall>> getCallMap() {
        return this.callMap;
    }
}

