/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.milyn.config.Configurable;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EDITypeEnum {
    String("String", String.class),
    Numeric("Double", String.class),
    Decimal("Double", Double.class),
    Date("Date", Date.class),
    Time("Date", Date.class),
    Binary("Binary", String.class),
    Custom(null, null);

    public static final String CUSTOM_NAME = "Custom";
    private String typeAlias;
    private Class javaClass;

    private EDITypeEnum(String typeAlias, Class javaClass) {
        this.typeAlias = typeAlias;
        this.javaClass = javaClass;
    }

    public String getTypeAlias() {
        return this.typeAlias;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public boolean validateType(String value, List<Map.Entry<String, String>> parameters) {
        DataDecoder decoder = parameters != null && parameters.size() > 0 && this.name().equals(CUSTOM_NAME) ? DataDecoder.Factory.create((String)parameters.get(0).getValue()) : DataDecoder.Factory.create((String)this.typeAlias);
        if (decoder instanceof Configurable && parameters != null) {
            Properties properties = this.getProperties(parameters);
            Configurable configurable = (Configurable)decoder;
            configurable.setConfiguration(properties);
        }
        try {
            decoder.decode(value);
        }
        catch (DataDecodeException e) {
            return false;
        }
        return true;
    }

    private Properties getProperties(List<Map.Entry<String, String>> parameters) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : parameters) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        return properties;
    }
}

