/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.util;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.edisax.unedifact.UNEdifactInterchangeParser;
import org.milyn.util.ClassUtil;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdimapWriter {
    private static DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final String NS = "http://www.milyn.org/schema/edi-message-mapping-1.5.xsd";
    private Document doc = docBuilderFactory.newDocumentBuilder().newDocument();

    private EdimapWriter() throws ParserConfigurationException {
    }

    public static void write(Edimap edimap, Writer writer) throws IOException {
        try {
            EdimapWriter edimapWriter = new EdimapWriter();
            edimapWriter.write(edimap);
            XmlUtil.serialize((Node)edimapWriter.doc, (boolean)true, (Writer)writer);
            writer.flush();
        }
        catch (ParserConfigurationException e) {
            IOException ioE = new IOException("Error constructing EDI Mapping Model");
            ioE.initCause(e);
            throw ioE;
        }
    }

    public static void write(Segment segment, Writer writer) throws IOException {
        Edimap ediMap = new Edimap();
        SegmentGroup segments = new SegmentGroup();
        segments.getSegments().add(segment);
        ediMap.setSegments(segments);
        ediMap.setDelimiters(UNEdifactInterchangeParser.defaultUNEdifactDelimiters);
        ediMap.setDescription(new Description().setName("TODO").setVersion("TODO"));
        EdimapWriter.write(ediMap, writer);
    }

    private void write(Edimap edimap) {
        Element edimapEl = this.newElement("edimap", this.doc);
        this.addImports(edimap.getImports(), edimapEl);
        this.addDescription(edimap.getDescription(), edimapEl);
        this.addDelimiters(edimap.getDelimiters(), edimapEl);
        SegmentGroup segments = edimap.getSegments();
        Element segmentsEl = this.newElement("segments", edimapEl, segments);
        this.mapBeanProperties(segments, segmentsEl, "name", "xmltag");
        this.addChildSegments(segments, segmentsEl);
    }

    private void addImports(List<Import> imports, Element edimapEl) {
        for (Import importInst : imports) {
            this.mapBeanProperties(importInst, this.newElement("import", edimapEl), "resource", "namespace", "truncatableComponents", "truncatableFields", "truncatableSegments");
        }
    }

    private void addDescription(Description description, Element edimapEl) {
        Element descriptionElement = this.newElement("description", edimapEl);
        this.mapBeanProperties(description, descriptionElement, "name", "version");
        if (!StringUtils.isEmpty((String)description.getNamespace())) {
            descriptionElement.setAttribute("namespace", description.getNamespace());
        }
    }

    private void addDelimiters(Delimiters delimiters, Element edimapEl) {
        this.mapBeanProperties(delimiters, this.newElement("delimiters", edimapEl), "segment", "field", "component", "subComponent|sub-component", "escape", "fieldRepeat");
    }

    private void addChildSegments(SegmentGroup segmentGroup, Element parentSegment) {
        List<SegmentGroup> childSegments = segmentGroup.getSegments();
        for (SegmentGroup childSegment : childSegments) {
            Element segmentEl;
            if (childSegment instanceof Segment) {
                segmentEl = this.newElement("segment", parentSegment, childSegment);
                this.mapBeanProperties(childSegment, segmentEl, "segcode", "nodeTypeRef", "description", "ignoreUnmappedFields", "truncatable");
                this.addFields(((Segment)childSegment).getFields(), segmentEl);
            } else {
                segmentEl = this.newElement("segmentGroup", parentSegment, childSegment);
            }
            this.mapBeanProperties(childSegment, segmentEl, "name", "xmltag", "minOccurs", "maxOccurs");
            this.addChildSegments(childSegment, segmentEl);
        }
    }

    private void addFields(List<Field> fields, Element segmentEl) {
        for (Field field : fields) {
            Element fieldEl = this.newElement("field", segmentEl, field);
            this.mapBeanProperties(field, fieldEl, "name", "xmltag", "nodeTypeRef", "truncatable", "maxLength", "minLength", "required", "dataType", "dataTypeParametersString|dataTypeParameters");
            this.addComponents(field.getComponents(), fieldEl);
        }
    }

    private void addComponents(List<Component> components, Element fieldEl) {
        for (Component component : components) {
            Element componentEl = this.newElement("component", fieldEl, component);
            this.mapBeanProperties(component, componentEl, "name", "xmltag", "nodeTypeRef", "truncatable", "maxLength", "minLength", "required", "dataType", "dataTypeParametersString|dataTypeParameters");
            this.addSubComponents(component.getSubComponents(), componentEl);
        }
    }

    private void addSubComponents(List<SubComponent> subComponents, Element componentEl) {
        for (SubComponent subComponent : subComponents) {
            Element subComponentEl = this.newElement("sub-component", componentEl, subComponent);
            this.mapBeanProperties(subComponent, subComponentEl, "name", "xmltag", "nodeTypeRef", "maxLength", "minLength", "required", "dataType", "dataTypeParametersString|dataTypeParameters");
        }
    }

    private void mapBeanProperties(Object bean, Element target, String ... properties) {
        for (String property : properties) {
            String attributeName;
            String propertyName;
            String[] propertyTokens = property.split("\\|");
            if (propertyTokens.length == 2) {
                propertyName = propertyTokens[0];
                attributeName = propertyTokens[1];
            } else {
                propertyName = property;
                attributeName = property;
            }
            Object value = this.getBeanValue(bean, propertyName);
            if (value == null) continue;
            target.setAttribute(attributeName, XmlUtil.removeEntities((String)value.toString()));
        }
    }

    private Object getBeanValue(Object bean, String property) {
        String getterMethodName = ClassUtil.toGetterName((String)property);
        Method getterMethod = ClassUtil.getGetterMethod((String)getterMethodName, (Object)bean, null);
        if (getterMethod == null) {
            getterMethodName = ClassUtil.toIsGetterName((String)property);
            getterMethod = ClassUtil.getGetterMethod((String)getterMethodName, (Object)bean, null);
        }
        if (getterMethod != null) {
            try {
                return getterMethod.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error invoking getter method '" + getterMethodName + "' on Object type '" + bean.getClass().getName() + "'.", e);
            }
        }
        return null;
    }

    private Element newElement(String name, Node parent) {
        Element element = this.doc.createElementNS(NS, "medi:" + name);
        parent.appendChild(element);
        return element;
    }

    private Element newElement(String name, Node parent, MappingNode mappingNode) {
        Element element = this.newElement(name, parent);
        if (mappingNode != null && mappingNode.getDocumentation() != null) {
            Element documentation = this.newElement("documentation", element);
            documentation.appendChild(this.doc.createTextNode(mappingNode.getDocumentation()));
        }
        return element;
    }

    static {
        docBuilderFactory.setValidating(false);
        docBuilderFactory.setNamespaceAware(true);
    }
}

