/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.milyn.annotation.AnnotatedMethod;
import org.milyn.annotation.AnnotationManager;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.annotation.Param;

public class LookupMethod {
    final Method method;
    Map<String, Integer> parameterPositions;
    private boolean namedParameters = false;

    public LookupMethod(Method method) {
        AssertArgument.isNotNull((Object)method, (String)"method");
        this.method = method;
        this.analyzeParameters();
    }

    private void analyzeParameters() {
        AnnotatedMethod aMethod = AnnotationManager.getAnnotatedClass(this.method.getDeclaringClass()).getAnnotatedMethod(this.method);
        Annotation[][] parameterAnnotations = aMethod.getParameterAnnotations();
        int parameterSize = aMethod.getMethod().getParameterTypes().length;
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!Param.class.equals(annotation.annotationType())) continue;
                this.namedParameters = true;
                Param param = (Param)annotation;
                String name = param.value().trim();
                if (name.length() == 0) {
                    throw new RuntimeException("Illegal empty parameter value encounterd on parameter " + i + " of method '" + this.method + "' from class '" + this.method.getDeclaringClass().getName() + "'.");
                }
                if (this.parameterPositions == null) {
                    this.parameterPositions = new HashMap<String, Integer>();
                }
                this.parameterPositions.put(param.value(), i);
                continue block0;
            }
        }
        if (this.namedParameters && this.parameterPositions.size() != parameterSize) {
            throw new RuntimeException("Not all the parameters of the method '" + this.method.getDeclaringClass().getName() + "." + this.method + "' are annotated with the '" + Param.class.getName() + "' annotation." + " All the parameters of the method need to be have the '" + Param.class.getName() + "' annotation when using the annotation on a method.");
        }
    }

    public Object invoke(Object obj, Map<String, ?> parameters) {
        if (!this.namedParameters) {
            throw new IllegalStateException("This Lookup Method doesn't have name parameters and there for can't be invoked with a parameter Map.");
        }
        Object[] args = new Object[this.parameterPositions.size()];
        for (Map.Entry<String, ?> parameterEntry : parameters.entrySet()) {
            String parameterName = parameterEntry.getKey();
            Integer position = this.parameterPositions.get(parameterName);
            if (position == null) {
                throw new RuntimeException("Parameter with the name " + parameterName + " isn't found on the method '" + this.method + "' of the class '" + this.method.getDeclaringClass().getName() + "'");
            }
            args[position.intValue()] = parameterEntry.getValue();
        }
        return this.invoke(obj, args);
    }

    public Object invoke(Object obj, Object ... args) {
        try {
            return this.method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The method '" + this.method + "' of the class '" + this.method.getDeclaringClass().getName() + "' threw an exception, while invoking it with the object '" + obj + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method '" + this.method + "' of the class '" + this.method.getDeclaringClass().getName() + "' threw an exception, while invoking it with the object '" + obj + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The method '" + this.method + "' of the class '" + this.method.getDeclaringClass().getName() + "' threw an exception, while invoking it with the object '" + obj + "'.", e);
        }
    }
}

