/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.milyn.annotation.AnnotatedClass;
import org.milyn.annotation.AnnotatedMethod;
import org.milyn.annotation.AnnotationManager;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.AnnotationNotFoundException;
import org.milyn.scribe.IllegalAnnotationUsageException;
import org.milyn.scribe.annotation.Dao;
import org.milyn.scribe.annotation.Delete;
import org.milyn.scribe.annotation.Flush;
import org.milyn.scribe.annotation.Insert;
import org.milyn.scribe.annotation.Lookup;
import org.milyn.scribe.annotation.LookupByQuery;
import org.milyn.scribe.annotation.ReturnsNoEntity;
import org.milyn.scribe.annotation.Update;
import org.milyn.scribe.reflection.EntityMethod;
import org.milyn.scribe.reflection.FlushMethod;
import org.milyn.scribe.reflection.LookupMethod;
import org.milyn.scribe.reflection.LookupWithNamedQueryMethod;
import org.milyn.scribe.reflection.LookupWithPositionalQueryMethod;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedDaoRuntimeInfo {
    private final Class<?> daoClass;
    private EntityMethod defaultInsertMethod;
    private EntityMethod defaultUpdateMethod;
    private FlushMethod flushMethod;
    private EntityMethod defaultDeleteMethod;
    private LookupWithNamedQueryMethod lookupWithNamedQueryMethod;
    private LookupWithPositionalQueryMethod lookupWithPositionalQueryMethod;
    private final Map<String, EntityMethod> insertMethods = new HashMap<String, EntityMethod>();
    private final Map<String, EntityMethod> updateMethods = new HashMap<String, EntityMethod>();
    private final Map<String, EntityMethod> deleteMethods = new HashMap<String, EntityMethod>();
    private final Map<String, LookupMethod> lookupWithNamedParameters = new HashMap<String, LookupMethod>();

    AnnotatedDaoRuntimeInfo(Class<?> daoClass) {
        AssertArgument.isNotNull(daoClass, (String)"daoClass");
        this.daoClass = daoClass;
        this.analyze();
    }

    public Class<?> getDaoClass() {
        return this.daoClass;
    }

    public EntityMethod getDefaultInsertMethod() {
        return this.defaultInsertMethod;
    }

    public EntityMethod getInsertMethod(String name) {
        return this.insertMethods.get(name);
    }

    public EntityMethod getDefaultUpdateMethod() {
        return this.defaultUpdateMethod;
    }

    public EntityMethod getUpdateMethod(String name) {
        return this.updateMethods.get(name);
    }

    public FlushMethod getFlushMethod() {
        return this.flushMethod;
    }

    public EntityMethod getDefaultDeleteMethod() {
        return this.defaultDeleteMethod;
    }

    public EntityMethod getDeleteMethod(String name) {
        return this.deleteMethods.get(name);
    }

    public LookupWithNamedQueryMethod getLookupByNamedQueryMethod() {
        return this.lookupWithNamedQueryMethod;
    }

    public LookupWithPositionalQueryMethod getLookupByPositionalQueryMethod() {
        return this.lookupWithPositionalQueryMethod;
    }

    public LookupMethod getLookupWithNamedParametersMethod(String name) {
        return this.lookupWithNamedParameters.get(name);
    }

    private void analyze() {
        AnnotatedMethod[] annotatedMethods;
        AnnotatedClass annotatedClass = AnnotationManager.getAnnotatedClass(this.daoClass);
        if (annotatedClass.getAnnotation(Dao.class) == null) {
            throw new AnnotationNotFoundException("The class '" + this.daoClass.getName() + "' isn't annotated with the '" + Dao.class.getName() + "' annotation. Only class annotated with that annotation can be used as annotated DAO.");
        }
        for (AnnotatedMethod method : annotatedMethods = annotatedClass.getAnnotatedMethods()) {
            if (method.getAllAnnotations().length <= 0) continue;
            if (method.isAnnotationPresent(Insert.class)) {
                this.analyzeInsertMethod(method);
                continue;
            }
            if (method.isAnnotationPresent(Update.class)) {
                this.analyzeUpdateMethod(method);
                continue;
            }
            if (method.isAnnotationPresent(Delete.class)) {
                this.analyzeDeleteMethod(method);
                continue;
            }
            if (method.isAnnotationPresent(Flush.class)) {
                this.analyzeFlushMethod(method);
                continue;
            }
            if (method.isAnnotationPresent(Lookup.class)) {
                this.analyzeFindByMethod(method);
                continue;
            }
            if (!method.isAnnotationPresent(LookupByQuery.class)) continue;
            this.analyzeFindByQueryMethod(method);
        }
        if (this.defaultInsertMethod == null && this.insertMethods.size() == 1) {
            this.defaultInsertMethod = this.insertMethods.values().iterator().next();
        }
        if (this.defaultUpdateMethod == null && this.updateMethods.size() == 1) {
            this.defaultUpdateMethod = this.updateMethods.values().iterator().next();
        }
        if (this.defaultDeleteMethod == null && this.deleteMethods.size() == 1) {
            this.defaultDeleteMethod = this.deleteMethods.values().iterator().next();
        }
    }

    private void analyzeFlushMethod(AnnotatedMethod aMethod) {
        Method method = aMethod.getMethod();
        if (this.flushMethod != null) {
            throw new IllegalAnnotationUsageException("At least two methods are annotated with the '" + Flush.class.getName() + "'. Only one method per class is allowed to be the flush method.");
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalAnnotationUsageException("The Flush annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' has parameters, which isn't allowed.");
        }
        this.flushMethod = new FlushMethod(method);
    }

    private void analyzeUpdateMethod(AnnotatedMethod aMethod) {
        Method method = aMethod.getMethod();
        Update annotation = (Update)aMethod.getAnnotation(Update.class);
        String name = annotation.name();
        if (name.length() == 0) {
            name = method.getName();
        }
        this.assertUniqueName(this.updateMethods, Update.class, name);
        if (annotation.isDefault() && this.defaultUpdateMethod != null) {
            throw new IllegalAnnotationUsageException("At least two methods are annotated with the '" + Update.class.getName() + "' having the isDefault on true. Only one method per class is allowed to be the default update method.");
        }
        if (method.getParameterTypes().length == 0) {
            throw new IllegalAnnotationUsageException("The Update annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' doesn't have any parameters.");
        }
        if (method.getParameterTypes().length > 1) {
            throw new IllegalAnnotationUsageException("The Update annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' has more then 1 parameter, which isn't allowed.");
        }
        boolean returnsEntity = !method.isAnnotationPresent(ReturnsNoEntity.class);
        EntityMethod updateMethod = new EntityMethod(method, returnsEntity);
        if (annotation.isDefault()) {
            this.defaultUpdateMethod = updateMethod;
        }
        this.updateMethods.put(name, updateMethod);
    }

    private void analyzeInsertMethod(AnnotatedMethod aMethod) {
        Method method = aMethod.getMethod();
        Insert annotation = (Insert)aMethod.getAnnotation(Insert.class);
        String name = annotation.name();
        if (name.length() == 0) {
            name = method.getName();
        }
        this.assertUniqueName(this.insertMethods, Insert.class, name);
        if (annotation.isDefault() && this.defaultInsertMethod != null) {
            throw new IllegalAnnotationUsageException("At least two methods are annotated with the '" + Insert.class.getName() + "'annotation having the isDefault on true. Only one method per class is allowed to be the default insert method.");
        }
        if (method.getParameterTypes().length == 0) {
            throw new IllegalAnnotationUsageException("The Insert annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "'  doesn't have any parameters.");
        }
        if (method.getParameterTypes().length > 1) {
            throw new IllegalAnnotationUsageException("The Insert annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' has more then 1 parameter, which isn't allowed.");
        }
        boolean returnsEntity = !method.isAnnotationPresent(ReturnsNoEntity.class);
        EntityMethod insertMethod = new EntityMethod(method, returnsEntity);
        if (annotation.isDefault()) {
            this.defaultInsertMethod = insertMethod;
        }
        this.insertMethods.put(name, insertMethod);
    }

    private void analyzeDeleteMethod(AnnotatedMethod aMethod) {
        Method method = aMethod.getMethod();
        Delete annotation = (Delete)aMethod.getAnnotation(Delete.class);
        String name = annotation.name();
        if (name.length() == 0) {
            name = method.getName();
        }
        this.assertUniqueName(this.deleteMethods, Delete.class, name);
        if (annotation.isDefault() && this.defaultDeleteMethod != null) {
            throw new IllegalAnnotationUsageException("At least two methods are annotated with the '" + Delete.class.getName() + "' annotation having the isDefault on true. Only one method per class is allowed to be the default delete method.");
        }
        if (method.getParameterTypes().length == 0) {
            throw new IllegalAnnotationUsageException("The Delete annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' doesn't have a parameter, which it needs.");
        }
        if (method.getParameterTypes().length > 1) {
            throw new IllegalAnnotationUsageException("The Delete annotated method '" + method + "'  the DAO class '" + this.daoClass.getName() + "' has more then 1 parameter, which isn't allowed.");
        }
        boolean returnsEntity = !method.isAnnotationPresent(ReturnsNoEntity.class);
        EntityMethod deleteMethod = new EntityMethod(method, returnsEntity);
        if (annotation.isDefault()) {
            this.defaultDeleteMethod = deleteMethod;
        }
        this.deleteMethods.put(name, deleteMethod);
    }

    private void analyzeFindByQueryMethod(AnnotatedMethod aMethod) {
        int parameterIndex;
        Method method = aMethod.getMethod();
        Class[] parameters = method.getParameterTypes();
        if (method.getParameterTypes().length != 2) {
            throw new IllegalAnnotationUsageException("The FindByQuery annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' " + "doesn't have exactly two parameters.");
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalAnnotationUsageException("The FindByQuery annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' " + "doesn't return an instance of Collection.");
        }
        int queryIndex = ClassUtil.indexOfFirstAssignableClass(String.class, (Class[])parameters);
        if (queryIndex == -1) {
            throw new IllegalAnnotationUsageException("The FindByQuery annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' " + "doesn't have a String parameter. This parameter is needed to receive the query string.");
        }
        int n = parameterIndex = queryIndex == 0 ? 1 : 0;
        if (ClassUtil.containsAssignableClass(List.class, (Class[])parameters) || ClassUtil.containsAssignableClass(Object[].class, (Class[])parameters)) {
            if (this.lookupWithPositionalQueryMethod != null) {
                throw new IllegalAnnotationUsageException("A second method annotated with the '" + LookupByQuery.class.getName() + "' annotation is found for a Positional query. " + "Only one method, with a List or Object array parameter, per class is allowed to be annotated with this annotation.");
            }
            this.lookupWithPositionalQueryMethod = new LookupWithPositionalQueryMethod(method, queryIndex, parameterIndex);
        } else if (ClassUtil.containsAssignableClass(Map.class, (Class[])parameters)) {
            if (this.lookupWithNamedQueryMethod != null) {
                throw new IllegalAnnotationUsageException("A second method annotated with the '" + LookupByQuery.class.getName() + "' annotation is found for a Positional query. " + "Only one method, with a Map parameter, per class is allowed to be annotated with this annotation.");
            }
            this.lookupWithNamedQueryMethod = new LookupWithNamedQueryMethod(method, queryIndex, parameterIndex);
        } else {
            throw new IllegalAnnotationUsageException("The FindByQuery annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' " + "doesn't have a List, Object array or Map parameter. This parameter is needed to receive the query parameters.");
        }
    }

    private void analyzeFindByMethod(AnnotatedMethod aMethod) {
        Method method = aMethod.getMethod();
        Lookup findByAnnotation = (Lookup)aMethod.getAnnotation(Lookup.class);
        String name = findByAnnotation.name();
        if (name.trim().length() == 0) {
            name = method.getName();
        }
        this.assertUniqueName(this.lookupWithNamedParameters, Lookup.class, name);
        if (Void.TYPE.equals(method.getReturnType())) {
            throw new IllegalAnnotationUsageException("The FindBy annotated method '" + method + "' of the DAO class '" + this.daoClass.getName() + "' " + "returns void, which isn't allowed. The method must return something.");
        }
        this.lookupWithNamedParameters.put(name, new LookupMethod(method));
    }

    private void assertUniqueName(Map<String, ?> methods, Class<? extends Annotation> annotation, String name) {
        if (methods.containsKey(name)) {
            throw new IllegalAnnotationUsageException("A second method annotated with the '" + annotation.getName() + "' annotation and the name '" + name + "' is found." + "If you have defined a name on the annotation then please define a different one. If you haven't defined a name then please define one that is unique.");
        }
    }
}

