/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.classpath.ClasspathUtils;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.util.ClassUtil;

public class JavaContentHandlerFactory
implements ContentHandlerFactory {
    @AppContext
    private ApplicationContext appContext;

    public synchronized Object create(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException {
        Object contentHandler;
        Object javaResource = resourceConfig.getJavaResourceObject();
        if (javaResource != null) {
            return javaResource;
        }
        try {
            String className = ClasspathUtils.toClassName(resourceConfig.getResource());
            Class classRuntime = ClassUtil.forName(className, this.getClass());
            try {
                Constructor constructor = classRuntime.getConstructor(SmooksResourceConfiguration.class);
                contentHandler = constructor.newInstance(resourceConfig);
            }
            catch (NoSuchMethodException e) {
                contentHandler = classRuntime.newInstance();
            }
            Configurator.configure(contentHandler, resourceConfig, this.appContext);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to create an instance of Java ContentHandler [" + resourceConfig.getResource() + "].  See exception cause...", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to create an instance of Java ContentHandler [" + resourceConfig.getResource() + "].  See exception cause...", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to create an instance of Java ContentHandler [" + resourceConfig.getResource() + "].  See exception cause...", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create an instance of Java ContentHandler [" + resourceConfig.getResource() + "].  See exception cause...", e);
        }
        resourceConfig.setJavaResourceObject(contentHandler);
        return contentHandler;
    }
}

