/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.xpath.SelectorStep;
import org.milyn.cdr.xpath.evaluators.equality.ElementIndexCounter;
import org.milyn.cdr.xpath.evaluators.equality.IndexEvaluator;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.AbstractContentDeliveryConfig;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.Filter;
import org.milyn.delivery.FilterBypass;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.ordering.Sorter;
import org.milyn.delivery.sax.SAXElementVisitorMap;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.delivery.sax.SAXVisitChildren;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.SmooksSAXFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXContentDeliveryConfig
extends AbstractContentDeliveryConfig {
    private ContentHandlerConfigMapTable<SAXVisitBefore> visitBefores;
    private ContentHandlerConfigMapTable<SAXVisitChildren> childVisitors = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SAXVisitAfter> visitAfters;
    private ContentHandlerConfigMapTable<VisitLifecycleCleanable> visitCleanables;
    private boolean rewriteEntities;
    private boolean maintainElementStack;
    private boolean reverseVisitOrderOnVisitAfter;
    private boolean terminateOnVisitorException;
    private FilterBypass filterBypass;
    private Map<String, SAXElementVisitorMap> optimizedVisitorConfig = new HashMap<String, SAXElementVisitorMap>();

    public ContentHandlerConfigMapTable<SAXVisitBefore> getVisitBefores() {
        return this.visitBefores;
    }

    public void setVisitBefores(ContentHandlerConfigMapTable<SAXVisitBefore> visitBefores) {
        this.visitBefores = visitBefores;
    }

    public ContentHandlerConfigMapTable<SAXVisitChildren> getChildVisitors() {
        return this.childVisitors;
    }

    public ContentHandlerConfigMapTable<SAXVisitAfter> getVisitAfters() {
        return this.visitAfters;
    }

    public void setVisitAfters(ContentHandlerConfigMapTable<SAXVisitAfter> visitAfters) {
        this.visitAfters = visitAfters;
    }

    public ContentHandlerConfigMapTable<VisitLifecycleCleanable> getVisitCleanables() {
        return this.visitCleanables;
    }

    public void setVisitCleanables(ContentHandlerConfigMapTable<VisitLifecycleCleanable> visitCleanables) {
        this.visitCleanables = visitCleanables;
    }

    public Map<String, SAXElementVisitorMap> getOptimizedVisitorConfig() {
        return this.optimizedVisitorConfig;
    }

    @Override
    public FilterBypass getFilterBypass() {
        return this.filterBypass;
    }

    @Override
    public Filter newFilter(ExecutionContext executionContext) {
        return new SmooksSAXFilter(executionContext);
    }

    @Override
    public void sort() throws SmooksConfigurationException {
        this.visitBefores.sort(Sorter.SortOrder.PRODUCERS_FIRST);
        this.childVisitors.sort(Sorter.SortOrder.PRODUCERS_FIRST);
        this.visitAfters.sort(Sorter.SortOrder.CONSUMERS_FIRST);
    }

    @Override
    public void addToExecutionLifecycleSets() throws SmooksConfigurationException {
        this.addToExecutionLifecycleSets(this.visitBefores);
        this.addToExecutionLifecycleSets(this.visitAfters);
    }

    public void optimizeConfig() {
        if (this.visitBefores == null || this.visitAfters == null) {
            throw new IllegalStateException("Illegal call to setChildVisitors() before setVisitBefores() and setVisitAfters() are called.");
        }
        this.extractChildVisitors();
        ArrayList starVBs = new ArrayList();
        ArrayList starVCs = new ArrayList();
        ArrayList starVAs = new ArrayList();
        ArrayList starCleanables = new ArrayList();
        if (this.visitBefores.getTable().get("*") != null) {
            starVBs.addAll(this.visitBefores.getTable().get("*"));
        }
        if (this.visitBefores.getTable().get("**") != null) {
            starVBs.addAll(this.visitBefores.getTable().get("**"));
        }
        if (this.childVisitors.getTable().get("*") != null) {
            starVCs.addAll(this.childVisitors.getTable().get("*"));
        }
        if (this.childVisitors.getTable().get("**") != null) {
            starVCs.addAll(this.childVisitors.getTable().get("**"));
        }
        if (this.visitAfters.getTable().get("*") != null) {
            starVAs.addAll(this.visitAfters.getTable().get("*"));
        }
        if (this.visitAfters.getTable().get("**") != null) {
            starVAs.addAll(this.visitAfters.getTable().get("**"));
        }
        if (this.visitCleanables.getTable().get("*") != null) {
            starCleanables.addAll(this.visitCleanables.getTable().get("*"));
        }
        if (this.visitCleanables.getTable().get("**") != null) {
            starCleanables.addAll(this.visitCleanables.getTable().get("**"));
        }
        HashSet<String> elementNames = new HashSet<String>();
        elementNames.addAll(this.visitBefores.getTable().keySet());
        elementNames.addAll(this.visitAfters.getTable().keySet());
        for (String elementName : elementNames) {
            boolean isStar;
            SAXElementVisitorMap entry = new SAXElementVisitorMap();
            List<ContentHandlerConfigMap<SAXVisitBefore>> befores = this.visitBefores.getTable().get(elementName);
            List<ContentHandlerConfigMap<SAXVisitChildren>> children = this.childVisitors.getTable().get(elementName);
            List<ContentHandlerConfigMap<SAXVisitAfter>> afters = this.visitAfters.getTable().get(elementName);
            List<ContentHandlerConfigMap<VisitLifecycleCleanable>> cleanables = this.visitCleanables.getTable().get(elementName);
            boolean bl = isStar = elementName.equals("*") || elementName.equals("**");
            if (befores != null && !isStar) {
                befores.addAll(starVBs);
            }
            entry.setVisitBefores(befores);
            if (children != null && !isStar) {
                children.addAll(starVCs);
            }
            entry.setChildVisitors(children);
            if (afters != null && !isStar) {
                afters.addAll(starVAs);
            }
            entry.setVisitAfters(afters);
            if (cleanables != null && !isStar) {
                cleanables.addAll(starCleanables);
            }
            entry.setVisitCleanables(cleanables);
            entry.initAccumulateText();
            entry.initAcquireWriterFor();
            this.optimizedVisitorConfig.put(elementName, entry);
        }
        this.rewriteEntities = ParameterAccessor.getBoolParameter("entities.rewrite", true, this);
        this.maintainElementStack = ParameterAccessor.getBoolParameter("maintain.element.stack", true, this);
        this.reverseVisitOrderOnVisitAfter = ParameterAccessor.getBoolParameter("reverse.visit.order.on.visit.after", true, this);
        this.terminateOnVisitorException = ParameterAccessor.getBoolParameter("terminate.on.visitor.exception", true, this);
        this.filterBypass = this.getFilterBypass(this.visitBefores, this.visitAfters);
    }

    public void assertSelectorsNotAccessingText() {
        this.assertSelectorsNotAccessingText(this.visitBefores);
        this.assertSelectorsNotAccessingText(this.childVisitors);
    }

    private void assertSelectorsNotAccessingText(ContentHandlerConfigMapTable saxVisitorMap) {
        Map table = saxVisitorMap.getTable();
        Collection contentHandlerMaps = table.values();
        for (List contentHandlerMapList : contentHandlerMaps) {
            for (ContentHandlerConfigMap contentHandlerMap : contentHandlerMapList) {
                SmooksResourceConfiguration resourceConfig = contentHandlerMap.getResourceConfig();
                SelectorStep selectorStep = resourceConfig.getSelectorStep();
                if (!selectorStep.accessesText()) continue;
                throw new SmooksConfigurationException("Unsupported selector '" + selectorStep.getXPathExpression() + "' on resource '" + resourceConfig + "'.  The 'text()' XPath token is only supported on SAX Visitor implementations that implement the " + SAXVisitAfter.class.getName() + " interface only.  Class '" + resourceConfig.getResource() + "' implements other SAX Visitor interfaces.");
            }
        }
    }

    public void addIndexCounters() {
        LinkedHashMap<String, SAXElementVisitorMap> optimizedVisitorConfigCopy = new LinkedHashMap<String, SAXElementVisitorMap>(this.optimizedVisitorConfig);
        Collection visitorMaps = optimizedVisitorConfigCopy.values();
        for (SAXElementVisitorMap visitorMap : visitorMaps) {
            this.addIndexCounters(visitorMap.getVisitBefores());
            this.addIndexCounters(visitorMap.getChildVisitors());
            this.addIndexCounters(visitorMap.getVisitAfters());
        }
    }

    private <T extends SAXVisitor> void addIndexCounters(List<ContentHandlerConfigMap<T>> saxVisitorMap) {
        if (saxVisitorMap == null) {
            return;
        }
        for (ContentHandlerConfigMap<T> contentHandlerMap : saxVisitorMap) {
            SmooksResourceConfiguration resourceConfig = contentHandlerMap.getResourceConfig();
            SelectorStep[] selectorSteps = resourceConfig.getSelectorSteps();
            ArrayList indexEvaluators = new ArrayList();
            for (SelectorStep selectorStep : selectorSteps) {
                indexEvaluators.clear();
                selectorStep.getEvaluators(IndexEvaluator.class, indexEvaluators);
                for (IndexEvaluator indexEvaluator : indexEvaluators) {
                    if (indexEvaluator.getCounter() != null) continue;
                    ElementIndexCounter indexCounter = new ElementIndexCounter(selectorStep);
                    indexEvaluator.setCounter(indexCounter);
                    this.addIndexCounter(indexCounter);
                }
            }
        }
    }

    private void addIndexCounter(ElementIndexCounter indexCounter) {
        List<ContentHandlerConfigMap<SAXVisitBefore>> vbs;
        SelectorStep selectorStep = indexCounter.getSelectorStep();
        QName targetElement = selectorStep.getTargetElement();
        String targetElementName = targetElement.getLocalPart();
        String targetNS = targetElement.getNamespaceURI();
        SAXElementVisitorMap visitorMap = this.optimizedVisitorConfig.get(targetElementName);
        if (visitorMap == null) {
            visitorMap = new SAXElementVisitorMap();
            this.optimizedVisitorConfig.put(targetElementName, visitorMap);
        }
        if ((vbs = visitorMap.getVisitBefores()) == null) {
            vbs = new ArrayList<ContentHandlerConfigMap<SAXVisitBefore>>();
            visitorMap.setVisitBefores(vbs);
        }
        SmooksResourceConfiguration resourceConfig = new SmooksResourceConfiguration(targetElementName);
        if (!"".equals(targetNS)) {
            resourceConfig.setSelectorNamespaceURI(targetNS);
        }
        vbs.add(0, new ContentHandlerConfigMap<ElementIndexCounter>(indexCounter, resourceConfig));
    }

    public SAXElementVisitorMap getCombinedOptimizedConfig(String[] elementNames) {
        SAXElementVisitorMap combinedConfig = new SAXElementVisitorMap();
        combinedConfig.setVisitBefores(new ArrayList<ContentHandlerConfigMap<SAXVisitBefore>>());
        combinedConfig.setChildVisitors(new ArrayList<ContentHandlerConfigMap<SAXVisitChildren>>());
        combinedConfig.setVisitAfters(new ArrayList<ContentHandlerConfigMap<SAXVisitAfter>>());
        combinedConfig.setVisitCleanables(new ArrayList<ContentHandlerConfigMap<VisitLifecycleCleanable>>());
        for (String elementName : elementNames) {
            SAXElementVisitorMap elementConfig = this.optimizedVisitorConfig.get(elementName);
            if (elementConfig == null) continue;
            List<ContentHandlerConfigMap<SAXVisitBefore>> elementVisitBefores = elementConfig.getVisitBefores();
            List<ContentHandlerConfigMap<SAXVisitChildren>> elementChildVisitors = elementConfig.getChildVisitors();
            List<ContentHandlerConfigMap<SAXVisitAfter>> elementVisitAfteres = elementConfig.getVisitAfters();
            List<ContentHandlerConfigMap<VisitLifecycleCleanable>> elementVisitCleanables = elementConfig.getVisitCleanables();
            if (elementVisitBefores != null) {
                combinedConfig.getVisitBefores().addAll(elementVisitBefores);
            }
            if (elementChildVisitors != null) {
                combinedConfig.getChildVisitors().addAll(elementChildVisitors);
            }
            if (elementVisitAfteres != null) {
                combinedConfig.getVisitAfters().addAll(elementVisitAfteres);
            }
            if (elementVisitCleanables != null) {
                combinedConfig.getVisitCleanables().addAll(elementVisitCleanables);
            }
            combinedConfig.initAccumulateText(elementConfig);
            combinedConfig.initAcquireWriterFor(elementConfig);
        }
        if (combinedConfig.getVisitBefores().isEmpty()) {
            combinedConfig.setVisitBefores(null);
        }
        if (combinedConfig.getChildVisitors().isEmpty()) {
            combinedConfig.setChildVisitors(null);
        }
        if (combinedConfig.getVisitAfters().isEmpty()) {
            combinedConfig.setVisitAfters(null);
        }
        if (combinedConfig.getVisitCleanables().isEmpty()) {
            combinedConfig.setVisitCleanables(null);
        }
        if (combinedConfig.getVisitBefores() == null && combinedConfig.getChildVisitors() == null && combinedConfig.getVisitAfters() == null) {
            return null;
        }
        return combinedConfig;
    }

    private void extractChildVisitors() {
        Set<Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitBefore>>>> beforeMappings = this.visitBefores.getTable().entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitBefore>>> beforeMapping : beforeMappings) {
            List<ContentHandlerConfigMap<SAXVisitBefore>> elementMappings = beforeMapping.getValue();
            for (ContentHandlerConfigMap<SAXVisitBefore> elementMapping : elementMappings) {
                String elementName = beforeMapping.getKey();
                SAXVisitBefore handler = elementMapping.getContentHandler();
                if (!(handler instanceof SAXVisitChildren) || handler instanceof SAXVisitAfter) continue;
                this.childVisitors.addMapping(elementName, elementMapping.getResourceConfig(), (SAXVisitChildren)((Object)handler));
            }
        }
        Set<Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitAfter>>>> afterMappings = this.visitAfters.getTable().entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<SAXVisitAfter>>> afterMapping : afterMappings) {
            List<ContentHandlerConfigMap<SAXVisitAfter>> elementMappings = afterMapping.getValue();
            for (ContentHandlerConfigMap<SAXVisitAfter> elementMapping : elementMappings) {
                String elementName = afterMapping.getKey();
                SAXVisitAfter handler = elementMapping.getContentHandler();
                if (!(handler instanceof SAXVisitChildren)) continue;
                this.childVisitors.addMapping(elementName, elementMapping.getResourceConfig(), (SAXVisitChildren)((Object)handler));
            }
        }
    }

    public boolean isRewriteEntities() {
        return this.rewriteEntities;
    }

    public boolean isMaintainElementStack() {
        return this.maintainElementStack;
    }

    public boolean isReverseVisitOrderOnVisitAfter() {
        return this.reverseVisitOrderOnVisitAfter;
    }

    public boolean isTerminateOnVisitorException() {
        return this.terminateOnVisitorException;
    }
}

