/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.EnumDecoder;
import org.milyn.javabean.decoders.StringDecoder;
import org.milyn.util.ClassUtil;

public interface DataDecoder
extends Serializable {
    public Object decode(String var1) throws DataDecodeException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private static Log logger = LogFactory.getLog(DataDecoder.class);
        private static Map<Class, Class<? extends DataDecoder>> installedDecoders;

        public static DataDecoder create(Class targetType) throws DataDecodeException {
            Class<? extends DataDecoder> decoderType = Factory.getInstance(targetType);
            if (decoderType != null) {
                if (decoderType == EnumDecoder.class) {
                    EnumDecoder decoder = new EnumDecoder();
                    decoder.setEnumType(targetType);
                    return decoder;
                }
                return Factory.newInstance(decoderType);
            }
            return null;
        }

        public static Class<? extends DataDecoder> getInstance(Class targetType) {
            Factory.loadInstalledDecoders();
            if (targetType.isEnum()) {
                return EnumDecoder.class;
            }
            return installedDecoders.get(targetType);
        }

        private static synchronized void loadInstalledDecoders() throws DataDecodeException {
            if (installedDecoders == null) {
                List<Class<DataDecoder>> decoders = ClassUtil.getClasses("META-INF/data-decoders.inf", DataDecoder.class);
                if (decoders.isEmpty()) {
                    throw new DataDecodeException("Failed to find installed DataDecoders on classpath.");
                }
                HashMap<Class, Class<? extends DataDecoder>> loadedDecoders = new HashMap<Class, Class<? extends DataDecoder>>();
                for (Class<DataDecoder> decoder : decoders) {
                    DecodeType decodeType = decoder.getAnnotation(DecodeType.class);
                    if (decodeType == null) continue;
                    for (Class type : decodeType.value()) {
                        if (loadedDecoders.containsKey(type)) {
                            logger.warn((Object)("More than one DataDecoder for type '" + type.getName() + "' is installed on the classpath.  You must manually configure decoding of this type, where required."));
                            loadedDecoders.put(type, null);
                            continue;
                        }
                        loadedDecoders.put(type, decoder);
                    }
                }
                installedDecoders = loadedDecoders;
            }
        }

        public static Map<Class, Class<? extends DataDecoder>> getInstalledDecoders() {
            Factory.loadInstalledDecoders();
            return Collections.unmodifiableMap(installedDecoders);
        }

        public static DataDecoder create(String typeAlias) throws DataDecodeException {
            if (typeAlias == null) {
                return new StringDecoder();
            }
            String className = StringDecoder.class.getPackage().getName() + "." + typeAlias + "Decoder";
            try {
                Class decoderType = ClassUtil.forName(className, DataDecoder.class);
                return Factory.newInstance(decoderType);
            }
            catch (ClassNotFoundException e) {
                try {
                    Class decoderType = ClassUtil.forName(typeAlias, DataDecoder.class);
                    return Factory.newInstance(decoderType);
                }
                catch (ClassNotFoundException e1) {
                    throw new DataDecodeException("DataDecoder Class '" + className + "' is not available on the classpath.");
                }
            }
        }

        private static DataDecoder newInstance(Class decoderType) throws DataDecodeException {
            try {
                return (DataDecoder)decoderType.newInstance();
            }
            catch (ClassCastException e) {
                throw new DataDecodeException("Class '" + decoderType.getName() + "' is not a valid DataDecoder.  It doesn't implement " + DataDecoder.class.getName());
            }
            catch (IllegalAccessException e) {
                throw new DataDecodeException("Failed to load DataDecoder Class '" + decoderType.getName() + "'.", e);
            }
            catch (InstantiationException e) {
                throw new DataDecodeException("Failed to load DataDecoder Class '" + decoderType.getName() + "'.", e);
            }
        }
    }
}

