/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.db.AbstractDataSource;
import org.milyn.db.ExternalTransactionManager;
import org.milyn.db.JdbcTransactionManager;
import org.milyn.db.JtaTransactionManager;
import org.milyn.db.TransactionManager;
import org.milyn.db.TransactionManagerType;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;

@VisitBeforeReport(summary="Bind JndiDataSource <b>${resource.parameters.datasource}</b> to ExecutionContext.", detailTemplate="reporting/JndiDataSource_before.html")
@VisitAfterReport(summary="Cleaning up JndiDataSource <b>${resource.parameters.datasource}</b>. Includes performing commit/rollback etc.", detailTemplate="reporting/JndiDataSource_after.html")
public class JndiDataSource
extends AbstractDataSource {
    @ConfigParam(name="datasource")
    private String name;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String datasourceJndi;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String transactionJndi;
    @ConfigParam(defaultVal="false")
    private boolean autoCommit;
    @ConfigParam(defaultVal="true")
    private boolean setAutoCommitAllowed;
    @ConfigParam(name="transactionManager", defaultVal="JDBC", decoder=TransactionManagerType.DataDecoder.class)
    private TransactionManagerType transactionManagerType;
    private DataSource datasource;

    public JndiDataSource() {
    }

    public JndiDataSource(String name, boolean autoCommit) {
        AssertArgument.isNotNullAndNotEmpty((String)name, (String)"name");
        this.name = name;
        this.autoCommit = autoCommit;
    }

    public String getName() {
        return this.name;
    }

    @Initialize
    public void intitialize() {
        if (this.datasourceJndi == null) {
            this.datasourceJndi = this.name;
        }
        this.datasource = (DataSource)this.lookup(this.datasourceJndi);
        if (this.transactionManagerType == TransactionManagerType.JTA) {
            if (this.transactionJndi == null || this.transactionJndi.length() == 0) {
                throw new SmooksConfigurationException("The transactionJndi attribute must be set when the JTA transaction manager is set.");
            }
            this.autoCommit = false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    private Object lookup(String jndi) {
        InitialContext context = null;
        try {
            context = new InitialContext();
            Object object = context.lookup(jndi);
            return object;
        }
        catch (NamingException e) {
            throw new SmooksConfigurationException("JNDI Context lookup failed for '" + jndi + "'.", e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new SmooksConfigurationException("Error closing Naming Context after looking up DataSource JNDI '" + this.datasourceJndi + "'.", e);
                }
            }
        }
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public TransactionManager createTransactionManager(Connection connection) {
        switch (this.transactionManagerType) {
            case JDBC: {
                return new JdbcTransactionManager(connection, this.isAutoCommit());
            }
            case JTA: {
                return new JtaTransactionManager(connection, (UserTransaction)this.lookup(this.transactionJndi), this.setAutoCommitAllowed);
            }
            case EXTERNAL: {
                return new ExternalTransactionManager(connection, this.isAutoCommit(), this.setAutoCommitAllowed);
            }
        }
        throw new SmooksException("The TransactionManager type '" + (Object)((Object)this.transactionManagerType) + "' is unknown. This is probably a bug!");
    }
}

