/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.visitors.remove;

import java.io.IOException;
import org.milyn.SmooksException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.w3c.dom.Element;

public class RemoveAttribute
implements SAXVisitBefore,
DOMVisitAfter {
    private String qName;
    private String localPart;
    private String namespace;

    @Initialize
    public void init() {
        int prefixQualifier = this.qName.indexOf(58);
        if (prefixQualifier != -1) {
            this.localPart = this.qName.substring(prefixQualifier + 1);
            if (this.namespace == null && this.qName.substring(0, prefixQualifier).equals("xmlns")) {
                this.namespace = "http://www.w3.org/2000/xmlns/";
            }
        } else {
            this.localPart = this.qName;
            if (this.namespace == null && this.localPart.equals("xmlns")) {
                this.namespace = "http://www.w3.org/2000/xmlns/";
            }
        }
    }

    @ConfigParam
    public RemoveAttribute setName(String attributeName) {
        this.qName = attributeName;
        return this;
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    public RemoveAttribute setNamespace(String attributeNamespace) {
        this.namespace = attributeNamespace;
        return this;
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (this.namespace != null) {
            element.removeAttributeNS(this.namespace, this.qName);
        } else {
            element.removeAttribute(this.qName);
        }
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.namespace != null) {
            element.removeAttributeNS(this.namespace, this.localPart);
        } else {
            element.removeAttribute(this.localPart);
        }
    }
}

