/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence.parameter;

import org.milyn.persistence.parameter.ParameterContainer;
import org.milyn.persistence.parameter.PositionalParameter;
import org.milyn.persistence.parameter.PositionalParameterIndex;

public class PositionalParameterContainer
implements ParameterContainer<PositionalParameter> {
    Object[] values;

    public PositionalParameterContainer(PositionalParameterIndex index) {
        this.values = new Object[index.size()];
    }

    @Override
    public void clear() {
        this.values = new Object[this.values.length];
    }

    @Override
    public boolean containsParameter(PositionalParameter parameter) {
        int index = parameter.getIndex();
        return this.values.length > index && this.values[index] != null;
    }

    @Override
    public Object get(PositionalParameter parameter) {
        int index = parameter.getIndex();
        return this.values[index];
    }

    @Override
    public void put(PositionalParameter parameter, Object bean) {
        this.values[parameter.getIndex()] = bean;
    }

    public Object[] getValues() {
        return (Object[])this.values.clone();
    }

    @Override
    public Object remove(PositionalParameter parameter) {
        Object old = this.get(parameter);
        if (old != null) {
            this.values[parameter.getIndex()] = null;
        }
        return old;
    }
}

