/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.jms;

import java.io.IOException;
import java.util.Properties;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.resource.URIResourceLocator;
import org.milyn.util.JNDIUtil;

public class JNDIProperties {
    private String contextFactory;
    private String providerUrl;
    private String namingFactoryUrlPkgs;
    private Properties defaultProperties = JNDIUtil.getDefaultProperties();
    private String propertiesFile;
    private Properties properties;

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getNamingFactoryUrlPkgs() {
        return this.namingFactoryUrlPkgs;
    }

    public void setNamingFactoryUrlPkgs(String namingFactoryUrl) {
        this.namingFactoryUrlPkgs = namingFactoryUrl;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public Properties toProperties() throws SmooksConfigurationException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.propertiesFile != null) {
            try {
                URIResourceLocator locator = new URIResourceLocator();
                this.properties.load(locator.getResource(this.propertiesFile));
            }
            catch (IOException e) {
                throw new SmooksConfigurationException("Failed to read JMS JNDI properties file '" + this.propertiesFile + "'.", (Throwable)e);
            }
        }
        if (this.contextFactory != null) {
            this.properties.setProperty("java.naming.factory.initial", this.contextFactory);
        }
        if (this.providerUrl != null) {
            this.properties.setProperty("java.naming.provider.url", this.providerUrl);
        }
        if (this.namingFactoryUrlPkgs != null) {
            this.properties.setProperty("java.naming.factory.url.pkgs", this.namingFactoryUrlPkgs);
        }
        if (!this.properties.isEmpty()) {
            return this.properties;
        }
        return this.defaultProperties;
    }
}

