/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.opensearch.common.inject.Binder;
import org.opensearch.common.inject.Key;
import org.opensearch.common.inject.MembersInjector;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.Provider;
import org.opensearch.common.inject.Scope;
import org.opensearch.common.inject.Stage;
import org.opensearch.common.inject.TypeLiteral;
import org.opensearch.common.inject.binder.AnnotatedBindingBuilder;
import org.opensearch.common.inject.binder.AnnotatedConstantBindingBuilder;
import org.opensearch.common.inject.binder.LinkedBindingBuilder;
import org.opensearch.common.inject.matcher.Matcher;
import org.opensearch.common.inject.spi.Message;
import org.opensearch.common.inject.spi.TypeConverter;
import org.opensearch.common.inject.spi.TypeListener;

public abstract class AbstractModule
implements Module {
    Binder binder;

    @Override
    public final synchronized void configure(Binder builder) {
        if (this.binder != null) {
            throw new IllegalStateException("Re-entry is not allowed.");
        }
        this.binder = Objects.requireNonNull(builder, "builder");
        try {
            this.configure();
        }
        finally {
            this.binder = null;
        }
    }

    protected abstract void configure();

    protected Binder binder() {
        return this.binder;
    }

    protected void bindScope(Class<? extends Annotation> scopeAnnotation, Scope scope) {
        this.binder.bindScope(scopeAnnotation, scope);
    }

    protected <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        return this.binder.bind(key);
    }

    protected <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder.bind(typeLiteral);
    }

    protected <T> AnnotatedBindingBuilder<T> bind(Class<T> clazz) {
        return this.binder.bind(clazz);
    }

    protected AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder.bindConstant();
    }

    protected void install(Module module) {
        this.binder.install(module);
    }

    protected void addError(String message, Object ... arguments) {
        this.binder.addError(message, arguments);
    }

    protected void addError(Throwable t) {
        this.binder.addError(t);
    }

    protected void addError(Message message) {
        this.binder.addError(message);
    }

    protected void requestInjection(Object instance) {
        this.binder.requestInjection(instance);
    }

    protected void requestStaticInjection(Class<?> ... types) {
        this.binder.requestStaticInjection(types);
    }

    protected void requireBinding(Key<?> key) {
        this.binder.getProvider(key);
    }

    protected void requireBinding(Class<?> type) {
        this.binder.getProvider(type);
    }

    protected <T> Provider<T> getProvider(Key<T> key) {
        return this.binder.getProvider(key);
    }

    protected <T> Provider<T> getProvider(Class<T> type) {
        return this.binder.getProvider(type);
    }

    protected void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder.convertToTypes(typeMatcher, converter);
    }

    protected Stage currentStage() {
        return this.binder.currentStage();
    }

    protected <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.binder.getMembersInjector(type);
    }

    protected <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        return this.binder.getMembersInjector(type);
    }

    protected void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder.bindListener(typeMatcher, listener);
    }
}

