/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.opensearch.action.admin.indices.streamingingestion.state.ShardIngestionState;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.opensearch.action.support.replication.PendingReplicationActions;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.common.Booleans;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.index.DerivedSourceDirectoryReader;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.concurrent.AbstractAsyncTask;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.AsyncIOProcessor;
import org.opensearch.common.util.concurrent.BufferedAsyncIOProcessor;
import org.opensearch.common.util.concurrent.RunOnce;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.Assertions;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.gateway.WriteStateException;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.ReplicationStats;
import org.opensearch.index.SegmentReplicationShardStats;
import org.opensearch.index.VersionType;
import org.opensearch.index.cache.IndexCache;
import org.opensearch.index.cache.bitset.ShardBitsetFilterCache;
import org.opensearch.index.cache.request.ShardRequestCache;
import org.opensearch.index.codec.CodecService;
import org.opensearch.index.engine.CommitStats;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.engine.IngestionEngine;
import org.opensearch.index.engine.MergedSegmentWarmerFactory;
import org.opensearch.index.engine.NRTReplicationEngine;
import org.opensearch.index.engine.ReadOnlyEngine;
import org.opensearch.index.engine.RefreshFailedEngineException;
import org.opensearch.index.engine.SafeCommitInfo;
import org.opensearch.index.engine.Segment;
import org.opensearch.index.engine.SegmentsStats;
import org.opensearch.index.fielddata.FieldDataStats;
import org.opensearch.index.fielddata.ShardFieldData;
import org.opensearch.index.flush.FlushStats;
import org.opensearch.index.get.GetStats;
import org.opensearch.index.get.ShardGetService;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.DocumentMapperForType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.Mapping;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.RootObjectMapper;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.Uid;
import org.opensearch.index.merge.MergeStats;
import org.opensearch.index.recovery.RecoveryStats;
import org.opensearch.index.refresh.RefreshStats;
import org.opensearch.index.remote.RemoteSegmentStats;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.remote.RemoteStoreStatsTrackerFactory;
import org.opensearch.index.search.stats.SearchStats;
import org.opensearch.index.search.stats.ShardSearchStats;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLease;
import org.opensearch.index.seqno.RetentionLeaseStats;
import org.opensearch.index.seqno.RetentionLeaseSyncer;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.seqno.SeqNoStats;
import org.opensearch.index.seqno.SequenceNumbers;
import org.opensearch.index.shard.AbstractIndexShardComponent;
import org.opensearch.index.shard.CheckpointRefreshListener;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.shard.GlobalCheckpointListeners;
import org.opensearch.index.shard.IllegalIndexShardStateException;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.IndexShardNotRecoveringException;
import org.opensearch.index.shard.IndexShardNotStartedException;
import org.opensearch.index.shard.IndexShardOperationPermits;
import org.opensearch.index.shard.IndexShardRecoveringException;
import org.opensearch.index.shard.IndexShardRecoveryException;
import org.opensearch.index.shard.IndexShardRelocatedException;
import org.opensearch.index.shard.IndexShardStartedException;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.index.shard.IndexingStats;
import org.opensearch.index.shard.InternalIndexingStats;
import org.opensearch.index.shard.LocalShardSnapshot;
import org.opensearch.index.shard.PrimaryReplicaSyncer;
import org.opensearch.index.shard.RefreshListeners;
import org.opensearch.index.shard.ReleasableRetryableRefreshListener;
import org.opensearch.index.shard.RemoteStoreRefreshListener;
import org.opensearch.index.shard.ReplicationGroup;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.index.shard.ShardNotInPrimaryModeException;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.shard.ShardStateMetadata;
import org.opensearch.index.shard.StoreRecovery;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.RemoteStoreFileDownloader;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.store.StoreStats;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.opensearch.index.translog.RemoteBlobStoreInternalTranslogFactory;
import org.opensearch.index.translog.RemoteFsTranslog;
import org.opensearch.index.translog.RemoteTranslogStats;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogFactory;
import org.opensearch.index.translog.TranslogRecoveryRunner;
import org.opensearch.index.translog.TranslogStats;
import org.opensearch.index.warmer.ShardIndexWarmerService;
import org.opensearch.index.warmer.WarmerStats;
import org.opensearch.indices.IndexingMemoryController;
import org.opensearch.indices.IndicesQueryCache;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.indices.pollingingest.IngestionSettings;
import org.opensearch.indices.pollingingest.PollingIngestStats;
import org.opensearch.indices.recovery.PeerRecoveryTargetService;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.recovery.RecoveryListener;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.indices.replication.checkpoint.MergedSegmentCheckpoint;
import org.opensearch.indices.replication.checkpoint.MergedSegmentPublisher;
import org.opensearch.indices.replication.checkpoint.ReferencedSegmentsCheckpoint;
import org.opensearch.indices.replication.checkpoint.ReferencedSegmentsPublisher;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.opensearch.indices.replication.common.ReplicationTimer;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.search.suggest.completion.CompletionStats;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public class IndexShard
extends AbstractIndexShardComponent
implements IndicesClusterStateService.Shard {
    private final ThreadPool threadPool;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private final Store store;
    private final InternalIndexingStats internalIndexingStats;
    private final ShardSearchStats searchStats = new ShardSearchStats();
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache requestCacheStats;
    private final ShardFieldData shardFieldData;
    private final ShardBitsetFilterCache shardBitsetFilterCache;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final Engine.Warmer warmer;
    private final SimilarityService similarityService;
    private final TranslogConfig translogConfig;
    private final IndexEventListener indexEventListener;
    private final QueryCachingPolicy cachingPolicy;
    private final Supplier<Sort> indexSortSupplier;
    final CircuitBreakerService circuitBreakerService;
    private final SearchOperationListener searchOperationListener;
    private final GlobalCheckpointListeners globalCheckpointListeners;
    private final PendingReplicationActions pendingReplicationActions;
    private final ReplicationTracker replicationTracker;
    private final SegmentReplicationCheckpointPublisher checkpointPublisher;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    private final Object postRecoveryMutex = new Object();
    private volatile long pendingPrimaryTerm;
    private final Object engineMutex = new Object();
    private final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    final EngineFactory engineFactory;
    final EngineConfigFactory engineConfigFactory;
    private final IndexingOperationListener indexingOperationListeners;
    private final Runnable globalCheckpointSyncer;
    private final RetentionLeaseSyncer retentionLeaseSyncer;
    @Nullable
    private volatile RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric externalRefreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final CounterMetric periodicFlushMetric = new CounterMetric();
    private final ShardEventListener shardEventListener = new ShardEventListener();
    private final ShardPath path;
    private final IndexShardOperationPermits indexShardOperationPermits;
    private static final EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.POST_RECOVERY);
    private static final EnumSet<IndexShardState> writeAllowedStates = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private final CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper;
    private final AtomicBoolean active = new AtomicBoolean();
    private final RefreshListeners refreshListeners;
    private final AtomicLong lastSearcherAccess = new AtomicLong();
    private final AtomicReference<Translog.Location> pendingRefreshLocation = new AtomicReference();
    private final RefreshPendingLocationListener refreshPendingLocationListener;
    private volatile boolean useRetentionLeasesInPeerRecovery;
    private final Store remoteStore;
    private final BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier;
    private final boolean isTimeSeriesIndex;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;
    private final List<ReferenceManager.RefreshListener> internalRefreshListener = new ArrayList<ReferenceManager.RefreshListener>();
    private final RemoteStoreFileDownloader fileDownloader;
    private final RecoverySettings recoverySettings;
    private final RemoteStoreSettings remoteStoreSettings;
    private final ShardMigrationState shardMigrationState;
    private DiscoveryNodes discoveryNodes;
    private final Function<ShardId, ReplicationStats> segmentReplicationStatsProvider;
    private final MergedSegmentWarmerFactory mergedSegmentWarmerFactory;
    private final Supplier<Boolean> fixedRefreshIntervalSchedulingEnabled;
    private final Supplier<TimeValue> refreshInterval;
    private final Object refreshMutex;
    private volatile AsyncShardRefreshTask refreshTask;
    private final ClusterApplierService clusterApplierService;
    private final MergedSegmentPublisher mergedSegmentPublisher;
    private final ReferencedSegmentsPublisher referencedSegmentsPublisher;
    private final Set<MergedSegmentCheckpoint> pendingMergedSegmentCheckpoints = Sets.newConcurrentHashSet();
    public Function<String, Boolean> isShardOnRemoteEnabledNode = nodeId -> {
        DiscoveryNode node = this.discoveryNodes.get((String)nodeId);
        if (node != null) {
            return node.isRemoteStoreNode();
        }
        return false;
    };
    private final AtomicBoolean primaryReplicaResyncInProgress = new AtomicBoolean();
    public static final int OPERATIONS_BLOCKED = -1;
    private final AsyncIOProcessor<Translog.Location> translogSyncProcessor;
    private final AtomicBoolean flushOrRollRunning = new AtomicBoolean();

    Runnable getGlobalCheckpointSyncer() {
        return this.globalCheckpointSyncer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi
    public IndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, Supplier<Sort> indexSortSupplier, IndexCache indexCache, MapperService mapperService, SimilarityService similarityService, EngineFactory engineFactory, EngineConfigFactory engineConfigFactory, IndexEventListener indexEventListener, CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, ThreadPool threadPool, BigArrays bigArrays, Engine.Warmer warmer, List<SearchOperationListener> searchOperationListener, List<IndexingOperationListener> listeners, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, CircuitBreakerService circuitBreakerService, BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier, @Nullable SegmentReplicationCheckpointPublisher checkpointPublisher, @Nullable Store remoteStore, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory, String nodeId2, RecoverySettings recoverySettings, RemoteStoreSettings remoteStoreSettings, boolean seedRemote, DiscoveryNodes discoveryNodes, Function<ShardId, ReplicationStats> segmentReplicationStatsProvider, MergedSegmentWarmerFactory mergedSegmentWarmerFactory, boolean shardLevelRefreshEnabled, Supplier<Boolean> fixedRefreshIntervalSchedulingEnabled, Supplier<TimeValue> refreshInterval, Object refreshMutex, ClusterApplierService clusterApplierService, @Nullable MergedSegmentPublisher mergedSegmentPublisher, @Nullable ReferencedSegmentsPublisher referencedSegmentsPublisher) throws IOException {
        super(shardRouting.shardId(), indexSettings);
        long primaryTerm;
        assert (shardRouting.initializing());
        this.shardRouting = shardRouting;
        Settings settings = indexSettings.getSettings();
        this.codecService = new CodecService(mapperService, indexSettings, this.logger);
        this.warmer = warmer;
        this.similarityService = similarityService;
        Objects.requireNonNull(store, "Store must be provided to the index shard");
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.engineConfigFactory = Objects.requireNonNull(engineConfigFactory);
        this.store = store;
        this.indexSortSupplier = indexSortSupplier;
        this.indexEventListener = indexEventListener;
        this.threadPool = threadPool;
        this.translogSyncProcessor = IndexShard.createTranslogSyncProcessor(this.logger, threadPool, this::getEngine, indexSettings.isAssignedOnRemoteNode(), () -> this.getRemoteTranslogUploadBufferInterval(remoteStoreSettings::getClusterRemoteTranslogBufferInterval));
        this.mapperService = mapperService;
        this.indexCache = indexCache;
        this.internalIndexingStats = new InternalIndexingStats(threadPool);
        ArrayList<IndexingOperationListener> listenersList = new ArrayList<IndexingOperationListener>(listeners);
        listenersList.add(this.internalIndexingStats);
        this.indexingOperationListeners = new IndexingOperationListener.CompositeListener(listenersList, this.logger);
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        this.retentionLeaseSyncer = Objects.requireNonNull(retentionLeaseSyncer);
        ArrayList<SearchOperationListener> searchListenersList = new ArrayList<SearchOperationListener>(searchOperationListener);
        searchListenersList.add(this.searchStats);
        this.searchOperationListener = new SearchOperationListener.CompositeListener(searchListenersList, this.logger);
        this.getService = new ShardGetService(indexSettings, this, mapperService);
        this.shardWarmerService = new ShardIndexWarmerService(this.shardId, indexSettings);
        this.requestCacheStats = new ShardRequestCache();
        this.shardFieldData = new ShardFieldData();
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(this.shardId, indexSettings);
        this.state = IndexShardState.CREATED;
        this.path = path;
        this.circuitBreakerService = circuitBreakerService;
        this.logger.debug("state: [CREATED]");
        this.checkIndexOnStartup = indexSettings.getValue(IndexSettings.INDEX_CHECK_ON_STARTUP);
        this.translogConfig = new TranslogConfig(this.shardId, this.shardPath().resolveTranslog(), indexSettings, bigArrays, nodeId2, seedRemote);
        String aId = shardRouting.allocationId().getId();
        this.pendingPrimaryTerm = primaryTerm = indexSettings.getIndexMetadata().primaryTerm(this.shardId.id());
        this.globalCheckpointListeners = new GlobalCheckpointListeners(this.shardId, threadPool.scheduler(), this.logger);
        this.pendingReplicationActions = new PendingReplicationActions(this.shardId, threadPool);
        this.replicationTracker = new ReplicationTracker(this.shardId, aId, indexSettings, primaryTerm, this.getInitialGlobalCheckpointForShard(indexSettings), this.globalCheckpointListeners::globalCheckpointUpdated, threadPool::absoluteTimeInMillis, (retentionLeases, listener) -> retentionLeaseSyncer.sync(this.shardId, aId, this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases, (ActionListener<ReplicationResponse>)listener), this::getSafeCommitInfo, this.pendingReplicationActions, this.isShardOnRemoteEnabledNode);
        this.cachingPolicy = IndexModule.INDEX_QUERY_CACHE_EVERYTHING_SETTING.get(settings) != false ? new QueryCachingPolicy(this){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) {
                return true;
            }
        } : new IndicesQueryCache.OpenseachUsageTrackingQueryCachingPolicy(clusterApplierService.clusterSettings());
        this.indexShardOperationPermits = new IndexShardOperationPermits(this.shardId, threadPool);
        this.readerWrapper = indexSettings.isDerivedSourceEnabled() ? reader -> {
            DirectoryReader wrappedReader = indexReaderWrapper == null ? reader : (DirectoryReader)indexReaderWrapper.apply(reader);
            return DerivedSourceDirectoryReader.wrap(wrappedReader, (CheckedBiFunction<LeafReader, Integer, BytesReference, IOException>)((CheckedBiFunction)this.getEngine().config().getDocumentMapperForTypeSupplier().get().getDocumentMapper().root()::deriveSource));
        } : indexReaderWrapper;
        this.refreshListeners = this.buildRefreshListeners();
        this.lastSearcherAccess.set(threadPool.relativeTimeInMillis());
        IndexShard.persistMetadata(path, indexSettings, shardRouting, null, this.logger);
        this.useRetentionLeasesInPeerRecovery = this.replicationTracker.hasAllPeerRecoveryRetentionLeases();
        this.refreshPendingLocationListener = new RefreshPendingLocationListener();
        this.checkpointPublisher = checkpointPublisher;
        this.remoteStore = remoteStore;
        this.translogFactorySupplier = translogFactorySupplier;
        this.isTimeSeriesIndex = mapperService == null || mapperService.documentMapper() == null ? false : mapperService.documentMapper().mappers().containsTimeStampField();
        this.remoteStoreStatsTrackerFactory = remoteStoreStatsTrackerFactory;
        this.recoverySettings = recoverySettings;
        this.remoteStoreSettings = remoteStoreSettings;
        this.fileDownloader = new RemoteStoreFileDownloader(shardRouting.shardId(), threadPool, recoverySettings);
        this.shardMigrationState = IndexShard.getShardMigrationState(indexSettings, seedRemote);
        this.discoveryNodes = discoveryNodes;
        this.segmentReplicationStatsProvider = segmentReplicationStatsProvider;
        this.mergedSegmentWarmerFactory = mergedSegmentWarmerFactory;
        this.fixedRefreshIntervalSchedulingEnabled = fixedRefreshIntervalSchedulingEnabled;
        this.refreshInterval = refreshInterval;
        this.refreshMutex = Objects.requireNonNull(refreshMutex);
        this.clusterApplierService = clusterApplierService;
        this.mergedSegmentPublisher = mergedSegmentPublisher;
        this.referencedSegmentsPublisher = referencedSegmentsPublisher;
        Object object = this.refreshMutex;
        synchronized (object) {
            if (shardLevelRefreshEnabled) {
                this.startRefreshTask();
            }
        }
    }

    private long getInitialGlobalCheckpointForShard(IndexSettings indexSettings) {
        if (indexSettings.getIndexMetadata().useIngestionSource()) {
            return -1L;
        }
        return -2L;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Store store() {
        return this.store;
    }

    public boolean isMigratingToRemote() {
        return this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_UNSEEDED || this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_SEEDED;
    }

    public boolean shouldSeedRemoteStore() {
        return this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_UNSEEDED;
    }

    public boolean isRemoteSeeded() {
        return this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_SEEDED;
    }

    public Store remoteStore() {
        return this.remoteStore;
    }

    public Sort getIndexSort() {
        return this.indexSortSupplier.get();
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SearchOperationListener getSearchOperationListener() {
        return this.searchOperationListener;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.requestCacheStats;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public boolean isSystem() {
        return this.indexSettings.getIndexMetadata().isSystem();
    }

    public String getDefaultCodecName() {
        return this.codecService.codec("default").getName();
    }

    public long getPendingPrimaryTerm() {
        return this.pendingPrimaryTerm;
    }

    public long getOperationPrimaryTerm() {
        return this.replicationTracker.getOperationPrimaryTerm();
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.cachingPolicy;
    }

    protected RemoteStoreStatsTrackerFactory getRemoteStoreStatsTrackerFactory() {
        return this.remoteStoreStatsTrackerFactory;
    }

    public String getNodeId() {
        return this.translogConfig.getNodeId();
    }

    public RecoverySettings getRecoverySettings() {
        return this.recoverySettings;
    }

    public RemoteStoreSettings getRemoteStoreSettings() {
        return this.remoteStoreSettings;
    }

    public RemoteStoreFileDownloader getFileDownloader() {
        return this.fileDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShardState(ShardRouting newRouting, long newPrimaryTerm, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer, long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable, DiscoveryNodes discoveryNodes) throws IOException {
        ShardRouting currentRouting;
        this.discoveryNodes = discoveryNodes;
        Object object = this.mutex;
        synchronized (object) {
            currentRouting = this.shardRouting;
            assert (currentRouting != null);
            if (!newRouting.shardId().equals((Object)this.shardId())) {
                throw new IllegalArgumentException("Trying to set a routing entry with shardId " + String.valueOf(newRouting.shardId()) + " on a shard with shardId " + String.valueOf(this.shardId()));
            }
            if (!newRouting.isSameAllocation(currentRouting)) {
                throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + String.valueOf(currentRouting) + ", new " + String.valueOf(newRouting));
            }
            if (currentRouting.primary() && !newRouting.primary()) {
                throw new IllegalArgumentException("illegal state: trying to move shard from primary mode to replica mode. Current " + String.valueOf(currentRouting) + ", new " + String.valueOf(newRouting));
            }
            if (newRouting.primary()) {
                this.replicationTracker.updateFromClusterManager(applyingClusterStateVersion, inSyncAllocationIds, routingTable);
            }
            if (this.state == IndexShardState.POST_RECOVERY && newRouting.active()) {
                assert (!currentRouting.active()) : "we are in POST_RECOVERY, but our shard routing is active " + String.valueOf(currentRouting);
                assert (!currentRouting.isRelocationTarget() || !currentRouting.primary() || this.replicationTracker.isPrimaryMode()) : "a primary relocation is completed by the cluster-managerr, but primary mode is not active " + String.valueOf(currentRouting);
                this.changeState(IndexShardState.STARTED, "global state is [" + String.valueOf((Object)newRouting.state()) + "]");
                if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                    this.flush(new FlushRequest(new String[0]).waitIfOngoing(true).force(true));
                }
            } else if (currentRouting.primary() && currentRouting.relocating() && this.replicationTracker.isRelocated() && (!newRouting.relocating() || !newRouting.equalsIgnoringMetadata(currentRouting))) {
                throw new IndexShardRelocatedException(this.shardId(), "Shard is marked as relocated, cannot safely move to state " + String.valueOf((Object)newRouting.state()));
            }
            assert (!newRouting.active() || this.state == IndexShardState.STARTED || this.state == IndexShardState.CLOSED) : "routing is active, but local shard state isn't. routing: " + String.valueOf(newRouting) + ", local state: " + String.valueOf((Object)this.state);
            IndexShard.persistMetadata(this.path, this.indexSettings, newRouting, currentRouting, this.logger);
            CountDownLatch shardStateUpdated = new CountDownLatch(1);
            if (newRouting.primary()) {
                if (newPrimaryTerm == this.pendingPrimaryTerm) {
                    if (currentRouting.initializing() && !currentRouting.isRelocationTarget() && newRouting.active()) {
                        this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                        this.postActivatePrimaryMode();
                    }
                } else {
                    assert (!currentRouting.primary()) : "term is only increased as part of primary promotion";
                    assert (!newRouting.initializing()) : "a started primary shard should never update its term; shard " + String.valueOf(newRouting) + ", current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    assert (newPrimaryTerm > this.pendingPrimaryTerm) : "primary terms can only go up; current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    boolean resyncStarted = this.primaryReplicaResyncInProgress.compareAndSet(false, true);
                    if (!resyncStarted) {
                        throw new IllegalStateException("cannot start resync while it's already in progress");
                    }
                    this.bumpPrimaryTerm(newPrimaryTerm, () -> {
                        shardStateUpdated.await();
                        assert (this.pendingPrimaryTerm == newPrimaryTerm) : "shard term changed on primary. expected [" + newPrimaryTerm + "] but was [" + this.pendingPrimaryTerm + "], current routing: " + String.valueOf(currentRouting) + ", new routing: " + String.valueOf(newRouting);
                        assert (this.getOperationPrimaryTerm() == newPrimaryTerm);
                        try {
                            if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                                assert (newRouting.primary() && !currentRouting.primary());
                                ReplicationTimer timer = new ReplicationTimer();
                                timer.start();
                                this.logger.debug("Resetting engine on promotion of shard [{}] to primary, startTime {}\n", (Object)this.shardId, (Object)timer.startTime());
                                this.resetEngineToGlobalCheckpoint();
                                timer.stop();
                                this.logger.info("Completed engine failover for shard [{}] in: {} ms", (Object)this.shardId, (Object)timer.time());
                                this.updateReplicationCheckpoint();
                            }
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                            if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                                this.checkpointPublisher.publish(this, this.getLatestReplicationCheckpoint());
                            }
                            this.postActivatePrimaryMode();
                            Engine engine = this.getEngine();
                            engine.translogManager().restoreLocalHistoryFromTranslog(engine.getProcessedLocalCheckpoint(), snapshot -> this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {}));
                            engine.translogManager().rollTranslogGeneration();
                            engine.fillSeqNoGaps(newPrimaryTerm);
                            this.replicationTracker.updateLocalCheckpoint(currentRouting.allocationId().getId(), this.getLocalCheckpoint());
                            primaryReplicaSyncer.accept(this, new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                                public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                                    IndexShard.this.logger.info("primary-replica resync completed with {} operations", (Object)resyncTask.getResyncedOperations());
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                }

                                public void onFailure(Exception e) {
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                                        IndexShard.this.failShard("exception during primary-replica resync", e);
                                    }
                                }
                            });
                        }
                        catch (AlreadyClosedException alreadyClosedException) {
                            // empty catch block
                        }
                    }, null);
                }
            }
            this.shardRouting = newRouting;
            assert (!this.shardRouting.primary() || !this.shardRouting.started() || this.indexShardOperationPermits.isBlocked() || this.replicationTracker.isPrimaryMode()) : "a started primary with non-pending operation term must be in primary mode " + String.valueOf(this.shardRouting);
            shardStateUpdated.countDown();
        }
        if (!currentRouting.active() && newRouting.active()) {
            this.indexEventListener.afterIndexShardStarted(this);
        }
        if (!newRouting.equals(currentRouting)) {
            this.indexEventListener.shardRoutingChanged(this, currentRouting, newRouting);
        }
        if (this.indexSettings.isSoftDeleteEnabled() && !this.useRetentionLeasesInPeerRecovery && this.state() == IndexShardState.STARTED) {
            RetentionLeases retentionLeases = this.replicationTracker.getRetentionLeases();
            HashSet<ShardRouting> shardRoutings = new HashSet<ShardRouting>(routingTable.getShards());
            shardRoutings.addAll(routingTable.assignedShards());
            if (shardRoutings.stream().allMatch(shr -> shr.assignedToNode() && retentionLeases.contains(ReplicationTracker.getPeerRecoveryRetentionLeaseId(shr)))) {
                this.useRetentionLeasesInPeerRecovery = true;
                this.turnOffTranslogRetention();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState markAsRecovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    public void relocated(String targetAllocationId, Consumer<ReplicationTracker.PrimaryContext> consumer, Runnable performSegRep) throws IllegalIndexShardStateException, IllegalStateException, InterruptedException {
        assert (this.shardRouting.primary()) : "only primaries can be marked as relocated: " + String.valueOf(this.shardRouting);
        ArrayList releasablesOnHandoffFailures = new ArrayList(2);
        try (Releasable forceRefreshes = this.refreshListeners.forceRefreshes();){
            this.indexShardOperationPermits.blockOperations(30L, TimeUnit.MINUTES, () -> {
                boolean syncTranslog;
                forceRefreshes.close();
                boolean bl = syncTranslog = (this.isRemoteTranslogEnabled() || this.isMigratingToRemote()) && Translog.Durability.ASYNC == this.indexSettings.getTranslogDurability();
                if (syncTranslog) {
                    this.maybeSync();
                }
                for (Object refreshListener : this.internalRefreshListener) {
                    if (!(refreshListener instanceof ReleasableRetryableRefreshListener)) continue;
                    releasablesOnHandoffFailures.add(((ReleasableRetryableRefreshListener)refreshListener).drainRefreshes());
                }
                releasablesOnHandoffFailures.add(this.getEngine().translogManager().drainSync());
                assert (this.indexShardOperationPermits.getActiveOperationsCount() == -1) : "in-flight operations in progress while moving shard state to relocated";
                performSegRep.run();
                this.verifyRelocatingState();
                ReplicationTracker.PrimaryContext primaryContext = this.replicationTracker.startRelocationHandoff(targetAllocationId);
                try {
                    Object refreshListener;
                    consumer.accept(primaryContext);
                    refreshListener = this.mutex;
                    synchronized (refreshListener) {
                        this.verifyRelocatingState();
                        this.replicationTracker.completeRelocationHandoff();
                    }
                }
                catch (Exception e) {
                    try {
                        this.replicationTracker.abortRelocationHandoff();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    throw e;
                }
            });
        }
        catch (TimeoutException e) {
            this.logger.warn("timed out waiting for relocation hand-off to complete");
            this.failShard("timed out waiting for relocation hand-off to complete", null);
            throw new IndexShardClosedException(this.shardId(), "timed out waiting for relocation hand-off to complete");
        }
        catch (Exception ex) {
            assert (this.replicationTracker.isPrimaryMode());
            Releasables.close(releasablesOnHandoffFailures);
            throw ex;
        }
    }

    private void maybeSync() {
        try {
            if (this.isSyncNeeded()) {
                this.sync();
            }
        }
        catch (IOException e) {
            this.logger.warn("failed to sync translog", (Throwable)e);
        }
    }

    private void verifyRelocatingState() {
        if (this.state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, this.state);
        }
        if (!this.shardRouting.relocating()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating " + String.valueOf(this.shardRouting), new Object[0]);
        }
        if (this.primaryReplicaResyncInProgress.get()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": primary relocation is forbidden while primary-replica resync is in progress " + String.valueOf(this.shardRouting), new Object[0]);
        }
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        assert (Thread.holdsLock(this.mutex));
        this.logger.debug("state: [{}]->[{}], reason [{}]", (Object)this.state, (Object)newState, (Object)reason);
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indexEventListener.indexShardStateChanged(this, previousState, newState, reason);
        return previousState;
    }

    public Engine.IndexResult applyIndexOperationOnPrimary(long version, VersionType versionType, SourceToParse sourceToParse, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimestamp, boolean isRetry) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyIndexOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, versionType, ifSeqNo, ifPrimaryTerm, autoGeneratedTimestamp, isRetry, Engine.Operation.Origin.PRIMARY, sourceToParse, null);
    }

    public Engine.IndexResult applyIndexOperationOnReplica(String id, long seqNo, long opPrimaryTerm, long version, long autoGeneratedTimeStamp, boolean isRetry, SourceToParse sourceToParse) throws IOException {
        return this.applyIndexOperation(this.getEngine(), seqNo, opPrimaryTerm, version, null, -2L, 0L, autoGeneratedTimeStamp, isRetry, Engine.Operation.Origin.REPLICA, sourceToParse, id);
    }

    private Engine.IndexResult applyIndexOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimeStamp, boolean isRetry, Engine.Operation.Origin origin, SourceToParse sourceToParse, String id) throws IOException {
        Engine.Index operation;
        if (this.indexSettings.isSegRepEnabledOrRemoteNode() && !this.routingEntry().primary()) {
            Engine.Index index = new Engine.Index(new Term("_id", Uid.encodeId(id)), new ParsedDocument(null, null, id, null, null, sourceToParse.source(), sourceToParse.getMediaType(), null), seqNo, opPrimaryTerm, version, null, Engine.Operation.Origin.REPLICA, System.nanoTime(), autoGeneratedTimeStamp, isRetry, -2L, 0L);
            return this.getEngine().index(index);
        }
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        try {
            operation = IndexShard.prepareIndex(this.docMapper(), sourceToParse, seqNo, opPrimaryTerm, version, versionType, origin, autoGeneratedTimeStamp, isRetry, ifSeqNo, ifPrimaryTerm);
            Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
            if (update != null) {
                return new Engine.IndexResult(update);
            }
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            return new Engine.IndexResult(e, version, opPrimaryTerm, seqNo);
        }
        return this.index(engine, operation);
    }

    public static Engine.Index prepareIndex(DocumentMapperForType docMapper, SourceToParse source, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long autoGeneratedIdTimestamp, boolean isRetry, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        ParsedDocument doc = docMapper.getDocumentMapper().parse(source);
        if (docMapper.getMapping() != null) {
            doc.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        Term uid = new Term("_id", Uid.encodeId(doc.id()));
        return new Engine.Index(uid, doc, seqNo, primaryTerm, version, versionType, origin, startTime, autoGeneratedIdTimestamp, isRetry, ifSeqNo, ifPrimaryTerm);
    }

    private Engine.IndexResult index(Engine engine, Engine.Index index) throws IOException {
        Engine.IndexResult result;
        this.active.set(true);
        index = this.indexingOperationListeners.preIndex(this.shardId, index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", (Object)index.id(), (Object)index.seqNo(), (Object)this.routingEntry().allocationId(), (Object)index.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)index.origin());
            }
            result = engine.index(index);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index-done [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}] result-seq# [{}] result-term [{}] failure [{}]", (Object)index.id(), (Object)index.seqNo(), (Object)this.routingEntry().allocationId(), (Object)index.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)index.origin(), (Object)result.getSeqNo(), (Object)result.getTerm(), (Object)result.getFailure());
            }
        }
        catch (Exception e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("index-fail [{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", new Object[]{index.id(), index.seqNo(), this.routingEntry().allocationId(), index.primaryTerm(), this.getOperationPrimaryTerm(), index.origin()}), (Throwable)e);
            }
            this.indexingOperationListeners.postIndex(this.shardId, index, e);
            throw e;
        }
        this.indexingOperationListeners.postIndex(this.shardId, index, result);
        return result;
    }

    public Engine.NoOpResult markSeqNoAsNoop(long seqNo, long opPrimaryTerm, String reason) throws IOException {
        return this.markSeqNoAsNoop(this.getEngine(), seqNo, opPrimaryTerm, reason, Engine.Operation.Origin.REPLICA);
    }

    private Engine.NoOpResult markSeqNoAsNoop(Engine engine, long seqNo, long opPrimaryTerm, String reason, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        long startTime = System.nanoTime();
        this.ensureWriteAllowed(origin);
        Engine.NoOp noOp = new Engine.NoOp(seqNo, opPrimaryTerm, origin, startTime, reason);
        return this.noOp(engine, noOp);
    }

    private Engine.NoOpResult noOp(Engine engine, Engine.NoOp noOp) throws IOException {
        this.active.set(true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("noop (seq# [{}])", (Object)noOp.seqNo());
        }
        return engine.noOp(noOp);
    }

    public Engine.IndexResult getFailedIndexResult(Exception e, long version) {
        return new Engine.IndexResult(e, version);
    }

    public Engine.DeleteResult getFailedDeleteResult(Exception e, long version) {
        return new Engine.DeleteResult(e, version, this.getOperationPrimaryTerm());
    }

    public Engine.DeleteResult applyDeleteOperationOnPrimary(long version, String id, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyDeleteOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, id, versionType, ifSeqNo, ifPrimaryTerm, Engine.Operation.Origin.PRIMARY);
    }

    public Engine.DeleteResult applyDeleteOperationOnReplica(long seqNo, long opPrimaryTerm, long version, String id) throws IOException {
        if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            Engine.Delete delete = new Engine.Delete(id, new Term("_id", Uid.encodeId(id)), seqNo, opPrimaryTerm, version, null, Engine.Operation.Origin.REPLICA, System.nanoTime(), -2L, 0L);
            return this.getEngine().delete(delete);
        }
        return this.applyDeleteOperation(this.getEngine(), seqNo, opPrimaryTerm, version, id, null, -2L, 0L, Engine.Operation.Origin.REPLICA);
    }

    private Engine.DeleteResult applyDeleteOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, String id, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        Engine.Delete delete = IndexShard.prepareDelete(id, seqNo, opPrimaryTerm, version, versionType, origin, ifSeqNo, ifPrimaryTerm);
        return this.delete(engine, delete);
    }

    public static Engine.Delete prepareDelete(String id, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        Term uid = new Term("_id", Uid.encodeId(id));
        return new Engine.Delete(id, uid, seqNo, primaryTerm, version, versionType, origin, startTime, ifSeqNo, ifPrimaryTerm);
    }

    private Engine.DeleteResult delete(Engine engine, Engine.Delete delete) throws IOException {
        Engine.DeleteResult result;
        this.active.set(true);
        delete = this.indexingOperationListeners.preDelete(this.shardId, delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}] (seq no [{}])", (Object)delete.uid().text(), (Object)delete.seqNo());
            }
            result = engine.delete(delete);
        }
        catch (Exception e) {
            this.indexingOperationListeners.postDelete(this.shardId, delete, e);
            throw e;
        }
        this.indexingOperationListeners.postDelete(this.shardId, delete, result);
        return result;
    }

    public Engine.GetResult get(Engine.Get get) {
        this.readAllowed();
        DocumentMapper mapper = this.mapperService.documentMapper();
        if (mapper == null) {
            return Engine.GetResult.NOT_EXISTS;
        }
        return this.getEngine().get(get, this::acquireSearcher);
    }

    public void refresh(String source) {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with source [{}]", (Object)source);
        }
        this.getEngine().refresh(source);
    }

    public long getWritingBytes() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        return engine.getWritingBytes();
    }

    public RefreshStats refreshStats() {
        int listeners = this.refreshListeners.pendingCount();
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()), this.externalRefreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.externalRefreshMetric.sum()), listeners);
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), this.periodicFlushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    public DocsStats docStats() {
        this.readAllowed();
        return this.getEngine().docStats();
    }

    public CommitStats commitStats() {
        return this.getEngine().commitStats();
    }

    public SeqNoStats seqNoStats() {
        return this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
    }

    public IndexingStats indexingStats() {
        long throttleTimeInMillis;
        boolean throttled;
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throttled = false;
            throttleTimeInMillis = 0L;
        } else {
            throttled = engine.isThrottled();
            throttleTimeInMillis = engine.getIndexThrottleTimeInMillis();
        }
        return this.internalIndexingStats.stats(throttled, throttleTimeInMillis);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchStats.stats(groups);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            RecoveryState recoveryState = this.recoveryState;
            long bytesStillToRecover = recoveryState == null ? -1L : recoveryState.getIndex().bytesStillToRecover();
            return this.store.stats(bytesStillToRecover == -1L ? -1L : bytesStillToRecover);
        }
        catch (IOException e) {
            this.failShard("Failing shard because of exception during storeStats", e);
            throw new OpenSearchException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return new MergeStats();
        }
        MergeStats mergeStats = engine.getMergeStats();
        mergeStats.addUnreferencedFileCleanUpStats(engine.unreferencedFileCleanUpsPerformed());
        return mergeStats;
    }

    public SegmentsStats segmentStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        SegmentsStats segmentsStats = this.getEngine().segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        if (this.indexSettings().isAssignedOnRemoteNode()) {
            segmentsStats.addRemoteSegmentStats(new RemoteSegmentStats(this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(this.shardId).stats()));
        }
        if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            segmentsStats.addReplicationStats(this.getReplicationStats());
        }
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public TranslogStats translogStats() {
        TranslogStats translogStats = this.getEngine().translogManager().getTranslogStats();
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            translogStats.addRemoteTranslogStats(new RemoteTranslogStats(this.remoteStoreStatsTrackerFactory.getRemoteTranslogTransferTracker(this.shardId).stats()));
        }
        return translogStats;
    }

    public CompletionStats completionStats(String ... fields) {
        this.readAllowed();
        return this.getEngine().completionStats(fields);
    }

    public PollingIngestStats pollingIngestStats() {
        return this.getEngine().pollingIngestStats();
    }

    public void flush(FlushRequest request) {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        this.logger.trace("flush with {}", (Object)request);
        this.verifyNotClosed();
        long time = System.nanoTime();
        this.getEngine().flush(force, waitIfOngoing);
        this.flushMetric.inc(System.nanoTime() - time);
    }

    public void trimTranslog() {
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            return;
        }
        this.verifyNotClosed();
        Engine engine = this.getEngine();
        engine.translogManager().trimUnreferencedTranslogFiles();
    }

    public void rollTranslogGeneration() throws IOException {
        Engine engine = this.getEngine();
        engine.translogManager().rollTranslogGeneration();
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("force merge with {}", (Object)forceMerge);
        }
        Engine engine = this.getEngine();
        engine.forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), false, false, forceMerge.forceMergeUUID());
    }

    public Version upgrade(UpgradeRequest upgrade) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgrade with {}", (Object)upgrade);
        }
        Version previousVersion = this.minimumCompatibleVersion();
        Engine engine = this.getEngine();
        engine.forceMerge(true, Integer.MAX_VALUE, false, true, upgrade.upgradeOnlyAncientSegments(), null);
        Version version = this.minimumCompatibleVersion();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgraded segments for {} from version {} to version {}", (Object)this.shardId, (Object)previousVersion, (Object)version);
        }
        return version;
    }

    public Version minimumCompatibleVersion() {
        Version luceneVersion = null;
        for (Segment segment : this.getEngine().segments(false)) {
            if (luceneVersion != null && !luceneVersion.onOrAfter(segment.getVersion())) continue;
            luceneVersion = segment.getVersion();
        }
        return luceneVersion == null ? this.indexSettings.getIndexVersionCreated().luceneVersion : luceneVersion;
    }

    public RemoteSegmentMetadata fetchLastRemoteUploadedSegmentMetadata() throws IOException {
        if (!this.indexSettings.isAssignedOnRemoteNode()) {
            throw new IllegalStateException("Index is not assigned on Remote Node");
        }
        RemoteSegmentMetadata lastUploadedMetadata = this.getRemoteDirectory().readLatestMetadataFile();
        if (lastUploadedMetadata == null) {
            throw new FileNotFoundException("No metadata file found in remote store");
        }
        return lastUploadedMetadata;
    }

    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireLastIndexCommit(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public GatedCloseable<IndexCommit> acquireLastIndexCommitAndRefresh(boolean flushFirst) throws EngineException {
        GatedCloseable<IndexCommit> indexCommit = this.acquireLastIndexCommit(flushFirst);
        this.getEngine().refresh("Snapshot for Remote Store based Shard");
        return indexCommit;
    }

    public void acquireLockOnCommitData(String snapshotId, long primaryTerm, long generation) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this.getRemoteDirectory();
        remoteSegmentStoreDirectory.acquireLock(primaryTerm, generation, snapshotId);
    }

    public void releaseLockOnCommitData(String snapshotId, long primaryTerm, long generation) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this.getRemoteDirectory();
        remoteSegmentStoreDirectory.releaseLock(primaryTerm, generation, snapshotId);
    }

    public Optional<NRTReplicationEngine> getReplicationEngine() {
        try {
            if (this.getEngine() instanceof NRTReplicationEngine) {
                return Optional.of((NRTReplicationEngine)this.getEngine());
            }
            return Optional.empty();
        }
        catch (AlreadyClosedException e) {
            this.logger.debug("failed to get ReplicationEngine", (Throwable)e);
            return Optional.empty();
        }
    }

    public void finalizeReplication(SegmentInfos infos) throws IOException {
        Optional<NRTReplicationEngine> engineOptional = this.getReplicationEngine();
        if (engineOptional.isPresent()) {
            engineOptional.get().updateSegments(infos);
            for (SegmentCommitInfo segmentCommitInfo : infos) {
                String segmentCommitInfoName = segmentCommitInfo.info.name;
                this.logger.trace(() -> new ParameterizedMessage("segment replication complete, remove segment {} from pending merged segments", (Object)segmentCommitInfoName));
                this.pendingMergedSegmentCheckpoints.removeIf(s -> s.getSegmentName().equals(segmentCommitInfoName));
            }
        }
    }

    public void cleanupRedundantPendingMergeSegment(ReferencedSegmentsCheckpoint referencedSegmentsCheckpoint) {
        ArrayList<MergedSegmentCheckpoint> pendingDeleteCheckpoints = new ArrayList<MergedSegmentCheckpoint>();
        for (MergedSegmentCheckpoint mergedSegmentCheckpoint : this.pendingMergedSegmentCheckpoints) {
            if (referencedSegmentsCheckpoint.getSegmentNames().contains(mergedSegmentCheckpoint.getSegmentName()) || !referencedSegmentsCheckpoint.isAheadOf(mergedSegmentCheckpoint)) continue;
            this.logger.trace("cleanup pending mergedSegmentCheckpoint={}, primary referencedSegmentsCheckpoint={}", (Object)mergedSegmentCheckpoint, (Object)referencedSegmentsCheckpoint);
            pendingDeleteCheckpoints.add(mergedSegmentCheckpoint);
        }
        for (MergedSegmentCheckpoint mergedSegmentCheckpoint : pendingDeleteCheckpoints) {
            this.store.deleteQuiet(mergedSegmentCheckpoint.getMetadataMap().keySet().toArray(new String[0]));
            this.pendingMergedSegmentCheckpoints.remove(mergedSegmentCheckpoint);
        }
    }

    public void addPendingMergeSegmentCheckpoint(MergedSegmentCheckpoint mergedSegmentCheckpoint) {
        this.pendingMergedSegmentCheckpoints.add(mergedSegmentCheckpoint);
    }

    public Set<MergedSegmentCheckpoint> getPendingMergedSegmentCheckpoints() {
        return this.pendingMergedSegmentCheckpoints;
    }

    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireSafeIndexCommit();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public ReplicationCheckpoint getLatestReplicationCheckpoint() {
        return this.replicationTracker.getLatestReplicationCheckpoint();
    }

    public Tuple<GatedCloseable<SegmentInfos>, ReplicationCheckpoint> getLatestSegmentInfosAndCheckpoint() {
        assert (this.indexSettings.isSegRepEnabledOrRemoteNode());
        GatedCloseable<SegmentInfos> snapshot = null;
        try {
            snapshot = this.getSegmentInfosSnapshot();
            SegmentInfos segmentInfos = snapshot.get();
            return new Tuple(snapshot, (Object)this.computeReplicationCheckpoint(segmentInfos));
        }
        catch (IOException | AlreadyClosedException e) {
            this.logger.error("Error Fetching SegmentInfos and latest checkpoint", e);
            if (snapshot != null) {
                try {
                    snapshot.close();
                }
                catch (IOException ex) {
                    throw new OpenSearchException("Error Closing SegmentInfos Snapshot", e, new Object[0]);
                }
            }
            return new Tuple(new GatedCloseable<Object>(null, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {})), (Object)this.getLatestReplicationCheckpoint());
        }
    }

    ReplicationCheckpoint computeReplicationCheckpoint(SegmentInfos segmentInfos) throws IOException {
        if (segmentInfos == null) {
            return ReplicationCheckpoint.empty(this.shardId);
        }
        ReplicationCheckpoint latestReplicationCheckpoint = this.getLatestReplicationCheckpoint();
        if (latestReplicationCheckpoint.getSegmentInfosVersion() == segmentInfos.getVersion() && latestReplicationCheckpoint.getSegmentsGen() == segmentInfos.getGeneration() && latestReplicationCheckpoint.getPrimaryTerm() == this.getOperationPrimaryTerm()) {
            return latestReplicationCheckpoint;
        }
        Map<String, StoreFileMetadata> metadataMap = this.store.getSegmentMetadataMap(segmentInfos);
        ReplicationCheckpoint checkpoint = new ReplicationCheckpoint(this.shardId, this.getOperationPrimaryTerm(), segmentInfos.getGeneration(), segmentInfos.getVersion(), metadataMap.values().stream().mapToLong(StoreFileMetadata::length).sum(), this.getEngine().config().getCodec().getName(), metadataMap);
        this.logger.trace("Recomputed ReplicationCheckpoint for shard {}", (Object)checkpoint);
        return checkpoint;
    }

    public void publishReferencedSegments() throws IOException {
        assert (this.referencedSegmentsPublisher != null);
        this.referencedSegmentsPublisher.publish(this, this.computeReferencedSegmentsCheckpoint());
    }

    public ReferencedSegmentsCheckpoint computeReferencedSegmentsCheckpoint() throws IOException {
        try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.getSegmentInfosSnapshot();){
            String[] allFiles = this.store.directory().listAll();
            HashSet segmentNames = Sets.newHashSet((Object[])new String[0]);
            for (String file : allFiles) {
                if (!file.endsWith(".si")) continue;
                String segmentName = IndexFileNames.parseSegmentName((String)file);
                segmentNames.add(segmentName);
            }
            ReferencedSegmentsCheckpoint referencedSegmentsCheckpoint = new ReferencedSegmentsCheckpoint(this.shardId, this.getOperationPrimaryTerm(), segmentInfosGatedCloseable.get().getVersion(), -1L, this.getEngine().config().getCodec().getName(), Collections.emptyMap(), segmentNames);
            return referencedSegmentsCheckpoint;
        }
    }

    public void publishMergedSegment(SegmentCommitInfo segmentCommitInfo) throws IOException {
        assert (this.mergedSegmentPublisher != null);
        this.mergedSegmentPublisher.publish(this, this.computeMergeSegmentCheckpoint(segmentCommitInfo));
    }

    public MergedSegmentCheckpoint computeMergeSegmentCheckpoint(SegmentCommitInfo segmentCommitInfo) throws IOException {
        try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.getSegmentInfosSnapshot();){
            SegmentInfos segmentInfos = new SegmentInfos(Version.LATEST.major);
            segmentInfos.add(segmentCommitInfo);
            Map<String, StoreFileMetadata> segmentMetadataMap = this.store.getSegmentMetadataMap(segmentInfos);
            MergedSegmentCheckpoint mergedSegmentCheckpoint = new MergedSegmentCheckpoint(this.shardId, this.getOperationPrimaryTerm(), segmentInfosGatedCloseable.get().getVersion(), segmentMetadataMap.values().stream().mapToLong(StoreFileMetadata::length).sum(), this.getEngine().config().getCodec().getName(), segmentMetadataMap, segmentCommitInfo.info.name);
            return mergedSegmentCheckpoint;
        }
    }

    public boolean isSegmentReplicationAllowed() {
        if (!this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            this.logger.trace("Attempting to perform segment replication when it is not enabled on the index");
            return false;
        }
        if (this.getReplicationTracker().isPrimaryMode()) {
            this.logger.trace("Shard is in primary mode and cannot perform segment replication as a replica.");
            return false;
        }
        if (this.routingEntry().primary()) {
            this.logger.trace("Shard routing is marked primary thus cannot perform segment replication as replica");
            return false;
        }
        if (!this.state().equals((Object)IndexShardState.STARTED) && !(this.state() == IndexShardState.POST_RECOVERY && this.shardRouting.state() == ShardRoutingState.INITIALIZING)) {
            this.logger.trace(() -> new ParameterizedMessage("Shard is not started or recovering {} {} and cannot perform segment replication as a replica", (Object)this.state(), (Object)this.shardRouting.state()));
            return false;
        }
        if (this.getReplicationEngine().isEmpty()) {
            this.logger.trace(() -> new ParameterizedMessage("Shard does not have the correct engine type to perform segment replication {}.", this.getEngine().getClass()));
            return false;
        }
        return true;
    }

    public final boolean shouldProcessCheckpoint(ReplicationCheckpoint requestCheckpoint) {
        if (!this.isSegmentReplicationAllowed()) {
            return false;
        }
        ReplicationCheckpoint localCheckpoint = this.getLatestReplicationCheckpoint();
        if (!requestCheckpoint.isAheadOf(localCheckpoint)) {
            this.logger.trace(() -> new ParameterizedMessage("Ignoring new replication checkpoint - Shard is already on checkpoint {} that is ahead of {}", (Object)localCheckpoint, (Object)requestCheckpoint));
            return false;
        }
        return true;
    }

    public final boolean shouldProcessMergedSegmentCheckpoint(ReplicationCheckpoint requestCheckpoint) {
        return this.isSegmentReplicationAllowed() && requestCheckpoint.getPrimaryTerm() >= this.getOperationPrimaryTerm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Store.MetadataSnapshot snapshotStoreMetadata() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "snapshotting store metadata under mutex";
        GatedCloseable<IndexCommit> wrappedIndexCommit = null;
        this.store.incRef();
        try {
            Object object = this.engineMutex;
            synchronized (object) {
                Engine engine = this.getEngineOrNull();
                if (engine != null) {
                    wrappedIndexCommit = engine.acquireLastIndexCommit(false);
                }
                if (wrappedIndexCommit == null) {
                    Store.MetadataSnapshot metadataSnapshot = this.store.getMetadata(null, true);
                    return metadataSnapshot;
                }
            }
            object = this.store.getMetadata(wrappedIndexCommit.get());
            return object;
        }
        finally {
            this.store.decRef();
            IOUtils.close(wrappedIndexCommit);
        }
    }

    public Map<String, StoreFileMetadata> getSegmentMetadataMap() throws IOException {
        try (GatedCloseable<SegmentInfos> snapshot = this.getSegmentInfosSnapshot();){
            Map<String, StoreFileMetadata> map = this.store.getSegmentMetadataMap(snapshot.get());
            return map;
        }
    }

    public void failShard(String reason, @Nullable Exception e) {
        this.getEngine().failEngine(reason, e);
    }

    public Engine.SearcherSupplier acquireSearcherSupplier() {
        return this.acquireSearcherSupplier(Engine.SearcherScope.EXTERNAL);
    }

    public Engine.SearcherSupplier acquireSearcherSupplier(Engine.SearcherScope scope) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        return engine.acquireSearcherSupplier(this::wrapSearcher, scope);
    }

    public Engine.Searcher acquireSearcher(String source) {
        return this.acquireSearcher(source, Engine.SearcherScope.EXTERNAL);
    }

    private void markSearcherAccessed() {
        this.lastSearcherAccess.lazySet(this.threadPool.relativeTimeInMillis());
    }

    private Engine.Searcher acquireSearcher(String source, Engine.SearcherScope scope) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        return engine.acquireSearcher(source, scope, this::wrapSearcher);
    }

    private Engine.Searcher wrapSearcher(Engine.Searcher searcher) {
        Engine.Searcher searcher2;
        block7: {
            assert (OpenSearchDirectoryReader.unwrap((DirectoryReader)searcher.getDirectoryReader()) != null) : "DirectoryReader must be an instance or OpenSearchDirectoryReader";
            boolean success = false;
            try {
                Engine.Searcher newSearcher;
                Engine.Searcher searcher3 = newSearcher = this.readerWrapper == null ? searcher : IndexShard.wrapSearcher(searcher, this.readerWrapper);
                assert (newSearcher != null);
                success = true;
                searcher2 = newSearcher;
                if (success) break block7;
            }
            catch (IOException ex) {
                try {
                    throw new OpenSearchException("failed to wrap searcher", (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close((boolean)success, (Releasable[])new Releasable[]{searcher});
                    }
                    throw throwable;
                }
            }
            Releasables.close((boolean)success, (Releasable[])new Releasable[]{searcher});
        }
        return searcher2;
    }

    public static Engine.Searcher wrapSearcher(Engine.Searcher engineSearcher, CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper) throws IOException {
        assert (readerWrapper != null);
        OpenSearchDirectoryReader openSearchDirectoryReader = OpenSearchDirectoryReader.getOpenSearchDirectoryReader(engineSearcher.getDirectoryReader());
        if (openSearchDirectoryReader == null) {
            throw new IllegalStateException("Can't wrap non opensearch directory reader");
        }
        NonClosingReaderWrapper nonClosingReaderWrapper = new NonClosingReaderWrapper(engineSearcher.getDirectoryReader());
        DirectoryReader reader = (DirectoryReader)readerWrapper.apply((Object)nonClosingReaderWrapper);
        if (reader != nonClosingReaderWrapper) {
            if (reader.getReaderCacheHelper() != openSearchDirectoryReader.getReaderCacheHelper()) {
                throw new IllegalStateException("wrapped directory reader doesn't delegate IndexReader#getCoreCacheKey, wrappers must override this method and delegate to the original readers core cache key. Wrapped readers can't be used as cache keys since their are used only per request which would lead to subtle bugs");
            }
            if (OpenSearchDirectoryReader.getOpenSearchDirectoryReader(reader) != openSearchDirectoryReader) {
                throw new IllegalStateException("wrapped directory reader hides actual OpenSearchDirectoryReader but shouldn't");
            }
        }
        if (reader == nonClosingReaderWrapper) {
            return engineSearcher;
        }
        return new Engine.Searcher(engineSearcher.source(), (IndexReader)reader, engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), () -> IOUtils.close((Closeable[])new Closeable[]{reader, engineSearcher}));
    }

    public void onCheckpointPublished(ReplicationCheckpoint checkpoint) {
        this.replicationTracker.startReplicationLagTimers(checkpoint);
    }

    public void resetToWriteableEngine() throws IOException, InterruptedException, TimeoutException {
        this.indexShardOperationPermits.blockOperations(30L, TimeUnit.MINUTES, () -> this.resetEngineToGlobalCheckpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine, boolean deleted) throws IOException {
        Object object = this.engineMutex;
        synchronized (object) {
            Engine engine;
            block16: {
                try {
                    Object object2 = this.mutex;
                    synchronized (object2) {
                        this.changeState(IndexShardState.CLOSED, reason);
                    }
                }
                catch (Throwable throwable) {
                    Engine engine2;
                    block17: {
                        engine2 = this.currentEngineReference.getAndSet(null);
                        try {
                            if (engine2 == null || !flushEngine) break block17;
                            engine2.flushAndClose();
                        }
                        catch (Throwable throwable2) {
                            IOUtils.close((Closeable[])new Closeable[]{engine2, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions, this.refreshTask});
                            if (deleted && engine2 != null && this.isPrimaryMode()) {
                                engine2.translogManager().onDelete();
                            }
                            this.indexShardOperationPermits.close();
                            throw throwable2;
                        }
                    }
                    IOUtils.close((Closeable[])new Closeable[]{engine2, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions, this.refreshTask});
                    if (deleted && engine2 != null && this.isPrimaryMode()) {
                        engine2.translogManager().onDelete();
                    }
                    this.indexShardOperationPermits.close();
                    throw throwable;
                }
                engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (engine == null || !flushEngine) break block16;
                    engine.flushAndClose();
                }
                catch (Throwable throwable) {
                    IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions, this.refreshTask});
                    if (deleted && engine != null && this.isPrimaryMode()) {
                        engine.translogManager().onDelete();
                    }
                    this.indexShardOperationPermits.close();
                    throw throwable;
                }
            }
            IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners, this.pendingReplicationActions, this.refreshTask});
            if (deleted && engine != null && this.isPrimaryMode()) {
                engine.translogManager().onDelete();
            }
            this.indexShardOperationPermits.close();
        }
    }

    public RemoteSegmentStoreDirectory getRemoteDirectory() {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        assert (this.remoteStore.directory() instanceof FilterDirectory) : "Store.directory is not an instance of FilterDirectory";
        FilterDirectory remoteStoreDirectory = (FilterDirectory)this.remoteStore.directory();
        FilterDirectory byteSizeCachingStoreDirectory = (FilterDirectory)remoteStoreDirectory.getDelegate();
        Directory remoteDirectory = byteSizeCachingStoreDirectory.getDelegate();
        return (RemoteSegmentStoreDirectory)remoteDirectory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRemoteSegmentStoreInSync() {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        try {
            RemoteSegmentStoreDirectory directory = this.getRemoteDirectory();
            if (directory.readLatestMetadataFile() == null) return false;
            Set<String> uploadFiles = directory.getSegmentsUploadedToRemoteStore().keySet();
            try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.getSegmentInfosSnapshot();){
                Collection localSegmentInfosFiles = segmentInfosGatedCloseable.get().files(true);
                HashSet localFiles = new HashSet(localSegmentInfosFiles);
                localFiles.removeAll(RemoteStoreRefreshListener.EXCLUDE_FILES);
                if (uploadFiles.containsAll(localFiles)) {
                    boolean bl = true;
                    return bl;
                }
                this.logger.debug(() -> new ParameterizedMessage("RemoteSegmentStoreSyncStatus localSize={} remoteSize={}", (Object)localFiles.size(), (Object)uploadFiles.size()));
                return false;
            }
        }
        catch (AlreadyClosedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.error("Exception while reading latest metadata", e);
        }
        return false;
    }

    public void waitForRemoteStoreSync() throws IOException {
        this.waitForRemoteStoreSync(() -> {});
    }

    public void waitForRemoteStoreSync(Runnable onProgress) throws IOException {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        RemoteSegmentStoreDirectory directory = this.getRemoteDirectory();
        int segmentUploadeCount = 0;
        if (!this.shardRouting.primary()) {
            return;
        }
        long startNanos = System.nanoTime();
        while (System.nanoTime() - startNanos < this.getRecoverySettings().internalRemoteUploadTimeout().nanos()) {
            try {
                if (this.isRemoteSegmentStoreInSync()) {
                    return;
                }
                if (directory.getSegmentsUploadedToRemoteStore().size() > segmentUploadeCount) {
                    onProgress.run();
                    this.logger.debug("Uploaded segment count {}", (Object)directory.getSegmentsUploadedToRemoteStore().size());
                    segmentUploadeCount = directory.getSegmentsUploadedToRemoteStore().size();
                }
                try {
                    Thread.sleep(TimeValue.timeValueSeconds((long)30L).millis());
                }
                catch (InterruptedException ie) {
                    throw new OpenSearchException("Interrupted waiting for completion of [{}]", (Throwable)ie, new Object[0]);
                }
            }
            catch (AlreadyClosedException e) {
                return;
            }
        }
        throw new IOException("Failed to upload to remote segment store within remote upload timeout of " + this.getRecoverySettings().internalRemoteUploadTimeout().getMinutes() + " minutes");
    }

    public void preRecovery() {
        IndexShardState currentState = this.state;
        if (currentState == IndexShardState.CLOSED) {
            throw new IndexShardNotRecoveringException(this.shardId, currentState);
        }
        assert (currentState == IndexShardState.RECOVERING) : "expected a recovering shard " + String.valueOf(this.shardId) + " but got " + String.valueOf((Object)currentState);
        this.indexEventListener.beforeIndexShardRecovery(this, this.indexSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.postRecoveryMutex;
        synchronized (object) {
            this.getEngine().refresh("post_recovery");
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.state == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(this.shardId);
                }
                if (this.state == IndexShardState.STARTED) {
                    throw new IndexShardStartedException(this.shardId);
                }
                this.recoveryState.setStage(RecoveryState.Stage.DONE);
                this.changeState(IndexShardState.POST_RECOVERY, reason);
            }
        }
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long recoverLocallyUpToGlobalCheckpoint() {
        Optional<SequenceNumbers.CommitInfo> safeCommit;
        long globalCheckpoint;
        this.validateLocalRecoveryState();
        try {
            String translogUUID = (String)this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
            globalCheckpoint = Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), translogUUID);
            safeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
        }
        catch (org.apache.lucene.index.IndexNotFoundException e) {
            this.logger.trace("skip local recovery as no index commit found");
            return -2L;
        }
        catch (Exception e) {
            this.logger.debug("skip local recovery as failed to find the safe commit", (Throwable)e);
            return -2L;
        }
        try {
            Object translogRecoveryRunner;
            this.maybeCheckIndex();
            this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
            if (!safeCommit.isPresent()) {
                this.logger.trace("skip local recovery as no safe commit found");
                return -2L;
            }
            assert (safeCommit.get().localCheckpoint <= globalCheckpoint) : safeCommit.get().localCheckpoint + " > " + globalCheckpoint;
            if (safeCommit.get().localCheckpoint == globalCheckpoint) {
                this.logger.trace("skip local recovery as the safe commit is up to date; safe commit {} global checkpoint {}", (Object)safeCommit.get(), (Object)globalCheckpoint);
                this.recoveryState.getTranslog().totalLocal(0);
                return globalCheckpoint + 1L;
            }
            if (this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE || IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(this.indexSettings.getSettings()).booleanValue()) {
                this.logger.trace("skip local recovery as the index was closed or not allowed to write; safe commit {} global checkpoint {}", (Object)safeCommit.get(), (Object)globalCheckpoint);
                this.recoveryState.getTranslog().totalLocal(0);
                return safeCommit.get().localCheckpoint + 1L;
            }
            try {
                translogRecoveryRunner = snapshot -> {
                    this.recoveryState.getTranslog().totalLocal(snapshot.totalOperations());
                    int recoveredOps = this.runTranslogRecovery(this.getEngine(), snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, this.recoveryState.getTranslog()::incrementRecoveredOperations);
                    this.recoveryState.getTranslog().totalLocal(recoveredOps);
                    return recoveredOps;
                };
                this.innerOpenEngineAndTranslog(() -> globalCheckpoint);
                this.getEngine().translogManager().recoverFromTranslog((TranslogRecoveryRunner)translogRecoveryRunner, this.getEngine().getProcessedLocalCheckpoint(), globalCheckpoint);
                this.logger.trace("shard locally recovered up to {}", (Object)this.getEngine().getSeqNoStats(globalCheckpoint));
            }
            finally {
                translogRecoveryRunner = this.engineMutex;
                synchronized (translogRecoveryRunner) {
                    IOUtils.close((Closeable)this.currentEngineReference.getAndSet(null));
                }
            }
        }
        catch (Exception e) {
            this.logger.debug((Message)new ParameterizedMessage("failed to recover shard locally up to global checkpoint {}", (Object)globalCheckpoint), (Throwable)e);
            return -2L;
        }
        try {
            Optional<SequenceNumbers.CommitInfo> newSafeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
            assert (newSafeCommit.isPresent()) : "no safe commit found after local recovery";
            return newSafeCommit.get().localCheckpoint + 1L;
        }
        catch (Exception e) {
            this.logger.debug((Message)new ParameterizedMessage("failed to find the safe commit after recovering shard locally up to global checkpoint {}", (Object)globalCheckpoint), (Throwable)e);
            return -2L;
        }
    }

    public long recoverLocallyAndFetchStartSeqNo(boolean localTranslog) {
        if (localTranslog) {
            return this.recoverLocallyUpToGlobalCheckpoint();
        }
        return this.recoverLocallyUptoLastCommit();
    }

    private long recoverLocallyUptoLastCommit() {
        long seqNo;
        assert (this.indexSettings.isAssignedOnRemoteNode()) : "Remote translog store is not enabled";
        this.validateLocalRecoveryState();
        try {
            seqNo = Long.parseLong((String)this.store.readLastCommittedSegmentsInfo().getUserData().get("max_seq_no"));
        }
        catch (org.apache.lucene.index.IndexNotFoundException e) {
            this.logger.error("skip local recovery as no index commit found");
            return -2L;
        }
        catch (Exception e) {
            this.logger.error("skip local recovery as failed to find the safe commit", (Throwable)e);
            return -2L;
        }
        try {
            this.maybeCheckIndex();
            this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
            this.recoveryState.getTranslog().totalLocal(0);
        }
        catch (Exception e) {
            this.logger.error("check index failed during fetch seqNo", (Throwable)e);
            return -2L;
        }
        return seqNo;
    }

    private void validateLocalRecoveryState() {
        assert (!Thread.holdsLock(this.mutex)) : "recover locally under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
    }

    public void trimOperationOfPreviousPrimaryTerms(long aboveSeqNo) {
        this.getEngine().translogManager().trimOperationsFromTranslog(this.getOperationPrimaryTerm(), aboveSeqNo);
    }

    public long getMaxSeenAutoIdTimestamp() {
        return this.getEngine().getMaxSeenAutoIdTimestamp();
    }

    public void updateMaxUnsafeAutoIdTimestamp(long maxSeenAutoIdTimestampFromPrimary) {
        this.getEngine().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampFromPrimary);
    }

    public Engine.Result applyTranslogOperation(Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        return this.applyTranslogOperation(this.getEngine(), operation, origin);
    }

    private Engine.Result applyTranslogOperation(Engine engine, Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        VersionType versionType = origin == Engine.Operation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        return switch (operation.opType()) {
            case Translog.Operation.Type.INDEX -> {
                Translog.Index index = (Translog.Index)operation;
                yield this.applyIndexOperation(engine, index.seqNo(), index.primaryTerm(), index.version(), versionType, -2L, 0L, index.getAutoGeneratedIdTimestamp(), true, origin, new SourceToParse(this.shardId.getIndexName(), index.id(), index.source(), MediaTypeRegistry.xContentType((BytesReference)index.source()), index.routing()), index.id());
            }
            case Translog.Operation.Type.DELETE -> {
                Translog.Delete delete = (Translog.Delete)operation;
                yield this.applyDeleteOperation(engine, delete.seqNo(), delete.primaryTerm(), delete.version(), delete.id(), versionType, -2L, 0L, origin);
            }
            case Translog.Operation.Type.NO_OP -> {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                yield this.markSeqNoAsNoop(engine, noOp.seqNo(), noOp.primaryTerm(), noOp.reason(), origin);
            }
            default -> throw new IllegalStateException("No operation defined for [" + String.valueOf(operation) + "]");
        };
    }

    int runTranslogRecovery(Engine engine, Translog.Snapshot snapshot, Engine.Operation.Origin origin, Runnable onOperationRecovered) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            try {
                this.logger.trace("[translog] recover op {}", (Object)operation);
                Engine.Result result = this.applyTranslogOperation(engine, operation, origin);
                switch (result.getResultType()) {
                    case FAILURE: {
                        throw result.getFailure();
                    }
                    case MAPPING_UPDATE_REQUIRED: {
                        throw new IllegalArgumentException("unexpected mapping update: " + String.valueOf(result.getRequiredMappingUpdate()));
                    }
                    case SUCCESS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown result type [" + String.valueOf((Object)result.getResultType()) + "]"));
                    }
                }
                ++opsRecovered;
                onOperationRecovered.run();
            }
            catch (Exception e) {
                if (origin == Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY && ExceptionsHelper.status((Throwable)e) == RestStatus.BAD_REQUEST) {
                    this.logger.info("ignoring recovery of a corrupt translog entry", (Throwable)e);
                    continue;
                }
                throw ExceptionsHelper.convertToRuntime((Exception)e);
            }
        }
        return opsRecovered;
    }

    private void loadGlobalCheckpointToReplicationTracker() throws IOException {
        String translogUUID = (String)this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        long globalCheckpoint = Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), translogUUID);
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, "read from translog checkpoint");
    }

    public void openEngineAndRecoverFromTranslog() throws IOException {
        this.openEngineAndRecoverFromTranslog(true);
    }

    public void openEngineAndRecoverFromTranslog(boolean syncFromRemote) throws IOException {
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        this.maybeCheckIndex();
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        RecoveryState.Translog translogRecoveryStats = this.recoveryState.getTranslog();
        TranslogRecoveryRunner translogRecoveryRunner = snapshot -> {
            translogRecoveryStats.totalOperations(snapshot.totalOperations());
            translogRecoveryStats.totalOperationsOnStart(snapshot.totalOperations());
            return this.runTranslogRecovery(this.getEngine(), snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, translogRecoveryStats::incrementRecoveredOperations);
        };
        if (!(this.indexSettings.isRemoteSnapshot() || this.indexSettings.isRemoteTranslogStoreEnabled() || this.indexSettings.getIndexMetadata().useIngestionSource())) {
            this.loadGlobalCheckpointToReplicationTracker();
        }
        if (this.isSnapshotV2Restore()) {
            this.translogConfig.setDownloadRemoteTranslogOnInit(false);
        }
        this.innerOpenEngineAndTranslog(this.replicationTracker, syncFromRemote);
        if (this.isSnapshotV2Restore()) {
            this.translogConfig.setDownloadRemoteTranslogOnInit(true);
        }
        this.getEngine().translogManager().recoverFromTranslog(translogRecoveryRunner, this.getEngine().getProcessedLocalCheckpoint(), Long.MAX_VALUE);
    }

    public void openEngineAndSkipTranslogRecovery() throws IOException {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        this.openEngineAndSkipTranslogRecovery(true);
    }

    public void openEngineAndSkipTranslogRecoveryFromSnapshot() throws IOException {
        assert (this.routingEntry().isSearchOnly() || this.routingEntry().recoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "not a snapshot recovery [" + String.valueOf(this.routingEntry()) + "]";
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        this.maybeCheckIndex();
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        this.openEngineAndSkipTranslogRecovery(this.routingEntry().isSearchOnly());
    }

    void openEngineAndSkipTranslogRecovery(boolean syncFromRemote) throws IOException {
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
        this.loadGlobalCheckpointToReplicationTracker();
        this.innerOpenEngineAndTranslog(this.replicationTracker, syncFromRemote);
        assert (!this.routingEntry().isSearchOnly() || this.translogStats().estimatedNumberOfOperations() == 0) : "Translog is expected to be empty but holds " + this.translogStats().estimatedNumberOfOperations() + "Operations.";
        this.getEngine().translogManager().skipTranslogRecovery();
    }

    private void innerOpenEngineAndTranslog(LongSupplier globalCheckpointSupplier) throws IOException {
        this.innerOpenEngineAndTranslog(globalCheckpointSupplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerOpenEngineAndTranslog(LongSupplier globalCheckpointSupplier, boolean syncFromRemote) throws IOException {
        boolean bl = syncFromRemote = syncFromRemote && !this.indexSettings.isRemoteSnapshot();
        assert (!Thread.holdsLock(this.mutex)) : "opening engine under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        EngineConfig config = this.newEngineConfig(globalCheckpointSupplier);
        config.setEnableGcDeletes(false);
        this.updateRetentionLeasesOnReplica(this.loadRetentionLeases());
        assert (!this.recoveryState.getRecoverySource().expectEmptyRetentionLeases() || this.getRetentionLeases().leases().isEmpty()) : "expected empty set of retention leases with recovery source [" + String.valueOf(this.recoveryState.getRecoverySource()) + "] but got " + String.valueOf(this.getRetentionLeases());
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.currentEngineReference.get() == null) : "engine is running";
            this.verifyNotClosed();
            if (this.indexSettings.isRemoteStoreEnabled() || this.isRemoteSeeded()) {
                if (syncFromRemote) {
                    this.syncSegmentsFromRemoteSegmentStore(false);
                }
                if (this.shardRouting.primary()) {
                    if (this.indexSettings.isRemoteTranslogStoreEnabled()) {
                        if (syncFromRemote) {
                            this.syncRemoteTranslogAndUpdateGlobalCheckpoint();
                        } else if (!this.isSnapshotV2Restore()) {
                            this.deleteTranslogFilesFromRemoteTranslog();
                        }
                    }
                } else if (syncFromRemote) {
                    SegmentInfos lastCommittedSegmentInfos = this.store().readLastCommittedSegmentsInfo();
                    String translogUUID = (String)lastCommittedSegmentInfos.userData.get("translog_uuid");
                    long checkpoint = Long.parseLong((String)lastCommittedSegmentInfos.userData.get("local_checkpoint"));
                    Translog.createEmptyTranslog(this.shardPath().resolveTranslog(), this.shardId(), checkpoint, this.getPendingPrimaryTerm(), translogUUID, FileChannel::open);
                }
            }
            Engine newEngine = this.engineFactory.newReadWriteEngine(config);
            this.onNewEngine(newEngine);
            this.currentEngineReference.set(newEngine);
            if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                this.updateReplicationCheckpoint();
            }
            this.active.set(true);
        }
        this.onSettingsChanged();
        if (this.indexSettings.getIndexMetadata().useIngestionSource()) {
            return;
        }
        assert (this.assertSequenceNumbersInCommit());
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
    }

    private boolean isSnapshotV2Restore() {
        return this.routingEntry().recoverySource().getType() == RecoverySource.Type.SNAPSHOT && ((RecoverySource.SnapshotRecoverySource)this.routingEntry().recoverySource()).pinnedTimestamp() > 0L;
    }

    private boolean assertSequenceNumbersInCommit() throws IOException {
        Map<String, String> userData = this.fetchUserData();
        assert (userData.containsKey("local_checkpoint")) : "commit point doesn't contains a local checkpoint";
        assert (userData.containsKey("max_seq_no")) : "commit point doesn't contains a maximum sequence number";
        assert (userData.containsKey("history_uuid")) : "commit point doesn't contains a history uuid";
        assert (userData.get("history_uuid").equals(this.getHistoryUUID())) : "commit point history uuid [" + userData.get("history_uuid") + "] is different than engine [" + this.getHistoryUUID() + "]";
        assert (userData.containsKey("max_unsafe_auto_id_timestamp")) : "opening index which was created post 5.5.0 but max_unsafe_auto_id_timestamp is not found in commit";
        return true;
    }

    private Map<String, String> fetchUserData() throws IOException {
        return SegmentInfos.readLatestCommit((Directory)this.store.directory()).getUserData();
    }

    private void onNewEngine(Engine newEngine) {
        assert (Thread.holdsLock(this.engineMutex));
        this.refreshListeners.setCurrentRefreshLocationSupplier(newEngine.translogManager()::getTranslogLastWriteLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "restart recovery under mutex";
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.refreshListeners.pendingCount() == 0) : "we can't restart with pending listeners";
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet(null));
            this.resetRecoveryStage();
        }
    }

    public void resetRecoveryStage() {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + String.valueOf(this.routingEntry()) + "]";
        assert (this.currentEngineReference.get() == null);
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState().setStage(RecoveryState.Stage.INIT);
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        Engine engine = this.getEngine();
        engine.refresh("recovery_finalization");
        engine.config().setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!readAllowedStates.contains((Object)state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + readAllowedStates.toString(), new Object[0]);
        }
    }

    public boolean isReadAllowed() {
        return readAllowedStates.contains((Object)this.state);
    }

    private void ensureWriteAllowed(Engine.Operation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin.isRecovery()) {
            if (state != IndexShardState.RECOVERING) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when recovering, origin [" + String.valueOf((Object)origin) + "]", new Object[0]);
            }
        } else {
            if (origin == Engine.Operation.Origin.PRIMARY) {
                assert (this.assertPrimaryMode());
            } else if (origin == Engine.Operation.Origin.REPLICA) {
                assert (this.assertReplicationTarget());
            } else {
                assert (origin == Engine.Operation.Origin.LOCAL_RESET);
                assert (this.getActiveOperationsCount() == -1) : "locally resetting without blocking operations, active operations are [" + String.valueOf(this.getActiveOperations()) + "]";
            }
            if (!writeAllowedStates.contains((Object)state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + String.valueOf(writeAllowedStates) + ", origin [" + String.valueOf((Object)origin) + "]", new Object[0]);
            }
        }
    }

    private boolean assertPrimaryMode() {
        assert (this.shardRouting.primary() && this.replicationTracker.isPrimaryMode()) : "shard " + String.valueOf(this.shardRouting) + " is not a primary shard in primary mode";
        return true;
    }

    public boolean isPrimaryMode() {
        return this.shardRouting.primary() && this.replicationTracker.isPrimaryMode();
    }

    private boolean assertReplicationTarget() {
        assert (!this.replicationTracker.isPrimaryMode()) : "shard " + String.valueOf(this.shardRouting) + " in primary mode cannot be a replication target";
        return true;
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    private void verifyNotClosed(Exception suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IndexShardClosedException exc = new IndexShardClosedException(this.shardId, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    protected final void verifyActive() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard is active", new Object[0]);
        }
    }

    public long getIndexBufferRAMBytesUsed() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        try {
            return engine.getIndexBufferRAMBytesUsed();
        }
        catch (AlreadyClosedException ex) {
            return 0L;
        }
    }

    public void addShardFailureCallback(Consumer<ShardFailure> onShardFailure) {
        this.shardEventListener.delegates.add(onShardFailure);
    }

    public void flushOnIdle(long inactiveTimeNS) {
        boolean wasActive;
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null && System.nanoTime() - engineOrNull.getLastWriteNanos() >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.logger.debug("flushing shard on inactive");
            this.threadPool.executor("flush").execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                        IndexShard.this.logger.warn("failed to flush shard on inactive", (Throwable)e);
                    }
                }

                @Override
                protected void doRun() {
                    IndexShard.this.flush(new FlushRequest(new String[0]).waitIfOngoing(false).force(false));
                    IndexShard.this.periodicFlushMetric.inc();
                }
            });
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public ShardPath shardPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverFromLocalShards(Consumer<MappingMetadata> mappingUpdateConsumer, List<IndexShard> localShards, ActionListener<Boolean> listener) throws IOException {
        assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
        ArrayList<LocalShardSnapshot> snapshots = new ArrayList<LocalShardSnapshot>();
        ActionListener recoveryListener = ActionListener.runBefore(listener, () -> IOUtils.close((Iterable)snapshots));
        boolean success = false;
        try {
            for (IndexShard shard : localShards) {
                snapshots.add(new LocalShardSnapshot(shard));
            }
            assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromLocalShards(mappingUpdateConsumer, this, snapshots, (ActionListener<Boolean>)recoveryListener);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.close(snapshots);
            }
        }
    }

    public void recoverFromStore(ActionListener<Boolean> listener) {
        assert (this.shardRouting.primary() || this.shardRouting.isSearchOnly()) : "recover from store only makes sense if the shard is a primary shard or an untracked search only replica";
        assert (this.shardRouting.initializing()) : "can only start recovery on initializing shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        storeRecovery.recoverFromStore(this, listener);
    }

    public void restoreFromRemoteStore(ActionListener<Boolean> listener) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        storeRecovery.recoverFromRemoteStore(this, listener);
    }

    public void restoreFromSnapshotAndRemoteStore(Repository repository, RepositoriesService repositoriesService, ActionListener<Boolean> listener) {
        try {
            assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
            assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)this.recoveryState().getRecoverySource();
            if (recoverySource.pinnedTimestamp() != 0L) {
                storeRecovery.recoverShallowSnapshotV2(this, repository, repositoriesService, listener, this.remoteStoreSettings.getSegmentsPathFixedPrefix(), this.threadPool);
            } else {
                storeRecovery.recoverFromSnapshotAndRemoteStore(this, repository, repositoriesService, listener, this.remoteStoreSettings.getSegmentsPathFixedPrefix(), this.threadPool);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void restoreFromRepository(Repository repository, ActionListener<Boolean> listener) {
        try {
            assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
            assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + String.valueOf(this.recoveryState.getRecoverySource());
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromRepository(this, repository, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public boolean shouldPeriodicallyFlush() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldPeriodicallyFlush();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean shouldRollTranslogGeneration() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.translogManager().shouldRollTranslogGeneration();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void onSettingsChanged() {
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null) {
            boolean disableTranslogRetention = this.indexSettings.isSoftDeleteEnabled() && this.useRetentionLeasesInPeerRecovery;
            engineOrNull.onSettingsChanged(disableTranslogRetention ? TimeValue.MINUS_ONE : this.indexSettings.getTranslogRetentionAge(), disableTranslogRetention ? new ByteSizeValue(-1L) : this.indexSettings.getTranslogRetentionSize(), this.indexSettings.getSoftDeleteRetentionOperations());
        }
    }

    private void turnOffTranslogRetention() {
        this.logger.debug("turn off the translog retention for the replication group {} as it starts using retention leases exclusively in peer recoveries", (Object)this.shardId);
        this.threadPool.generic().execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                if (IndexShard.this.state != IndexShardState.CLOSED) {
                    IndexShard.this.logger.warn("failed to turn off translog retention", (Throwable)e);
                }
            }

            @Override
            protected void doRun() {
                IndexShard.this.onSettingsChanged();
                IndexShard.this.trimTranslog();
            }
        });
    }

    public Closeable acquireHistoryRetentionLock() {
        return this.getEngine().acquireHistoryRetentionLock();
    }

    public Translog.Snapshot getHistoryOperations(String reason, long startingSeqNo, long endSeqNo, boolean accurateCount) throws IOException {
        return this.getEngine().newChangesSnapshot(reason, startingSeqNo, endSeqNo, true, accurateCount);
    }

    public Translog.Snapshot getHistoryOperationsFromTranslog(long startingSeqNo, long endSeqNo) throws IOException {
        assert (!this.indexSettings.isSegRepEnabledOrRemoteNode()) : "unsupported operation for segment replication enabled indices or remote store backed indices";
        return this.getEngine().translogManager().newChangesSnapshot(startingSeqNo, endSeqNo, true);
    }

    public boolean hasCompleteHistoryOperations(String reason, long startingSeqNo) {
        return this.getEngine().hasCompleteOperationHistory(reason, startingSeqNo);
    }

    public long getMinRetainedSeqNo() {
        return this.getEngine().getMinRetainedSeqNo();
    }

    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNo) throws IOException {
        return this.getEngine().countNumberOfHistoryOperations(source, fromSeqNo, toSeqNo);
    }

    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) throws IOException {
        return this.getEngine().newChangesSnapshot(source, fromSeqNo, toSeqNo, requiredFullRange, accurateCount);
    }

    public List<Segment> segments(boolean verbose) {
        return this.getEngine().segments(verbose);
    }

    public String getHistoryUUID() {
        return this.getEngine().getHistoryUUID();
    }

    public IndexEventListener getIndexEventListener() {
        return this.indexEventListener;
    }

    public void activateThrottling() {
        try {
            this.getEngine().activateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    public void deactivateThrottling() {
        try {
            this.getEngine().deactivateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    private void handleRefreshException(Exception e) {
        if (!(e instanceof AlreadyClosedException)) {
            if (e instanceof RefreshFailedEngineException) {
                RefreshFailedEngineException rfee = (RefreshFailedEngineException)((Object)e);
                if (!(rfee.getCause() instanceof InterruptedException || rfee.getCause() instanceof ClosedByInterruptException || rfee.getCause() instanceof ThreadInterruptedException || this.state == IndexShardState.CLOSED)) {
                    this.logger.warn("Failed to perform engine refresh", (Throwable)e);
                }
            } else if (this.state != IndexShardState.CLOSED) {
                this.logger.warn("Failed to perform engine refresh", (Throwable)e);
            }
        }
    }

    public void writeIndexingBuffer() {
        try {
            Engine engine = this.getEngine();
            engine.writeIndexingBuffer();
        }
        catch (Exception e) {
            this.handleRefreshException(e);
        }
    }

    public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateLocalCheckpoint(allocationId, checkpoint);
    }

    public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
    }

    public void updateVisibleCheckpointForShard(String allocationId, ReplicationCheckpoint visibleCheckpoint) {
        if (this.isPrimaryMode()) {
            this.verifyNotClosed();
            this.replicationTracker.updateVisibleCheckpointForShard(allocationId, visibleCheckpoint);
        }
    }

    public Set<SegmentReplicationShardStats> getReplicationStatsForTrackedReplicas() {
        return this.replicationTracker.getSegmentReplicationStats();
    }

    public ReplicationStats getReplicationStats() {
        if (this.indexSettings.isSegRepEnabledOrRemoteNode() && !this.routingEntry().primary()) {
            return this.segmentReplicationStatsProvider.apply(this.shardId);
        }
        return ReplicationStats.empty();
    }

    public void addGlobalCheckpointListener(long waitingForGlobalCheckpoint, GlobalCheckpointListeners.GlobalCheckpointListener listener, TimeValue timeout) {
        this.globalCheckpointListeners.add(waitingForGlobalCheckpoint, listener, timeout);
    }

    private void ensureSoftDeletesEnabled(String feature) {
        if (!this.indexSettings.isSoftDeleteEnabled()) {
            String message = feature + " requires soft deletes but " + String.valueOf(this.indexSettings.getIndex()) + " does not have soft deletes enabled";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    public RetentionLeases getRetentionLeases() {
        return (RetentionLeases)this.getRetentionLeases(false).v2();
    }

    public Tuple<Boolean, RetentionLeases> getRetentionLeases(boolean expireLeases) {
        assert (!expireLeases || this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getRetentionLeases(expireLeases);
    }

    public RetentionLeaseStats getRetentionLeaseStats() {
        this.verifyNotClosed();
        return new RetentionLeaseStats(this.getRetentionLeases());
    }

    public RetentionLease addRetentionLease(String id, long retainingSequenceNumber, String source, ActionListener<ReplicationResponse> listener) {
        RetentionLease retentionLease;
        block9: {
            Objects.requireNonNull(listener);
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled("retention leases");
            Closeable ignore = this.acquireHistoryRetentionLock();
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.addRetentionLease(id, actualRetainingSequenceNumber, source, listener);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public RetentionLease renewRetentionLease(String id, long retainingSequenceNumber, String source) {
        RetentionLease retentionLease;
        block9: {
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled("retention leases");
            Closeable ignore = this.acquireHistoryRetentionLock();
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.renewRetentionLease(id, actualRetainingSequenceNumber, source);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public void removeRetentionLease(String id, ActionListener<ReplicationResponse> listener) {
        Objects.requireNonNull(listener);
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.ensureSoftDeletesEnabled("retention leases");
        this.replicationTracker.removeRetentionLease(id, listener);
    }

    public void updateRetentionLeasesOnReplica(RetentionLeases retentionLeases) {
        assert (this.assertReplicationTarget());
        this.verifyNotClosed();
        this.replicationTracker.updateRetentionLeasesOnReplica(retentionLeases);
    }

    public RetentionLeases loadRetentionLeases() throws IOException {
        this.verifyNotClosed();
        return this.replicationTracker.loadRetentionLeases(this.path.getShardStatePath());
    }

    public void persistRetentionLeases() throws WriteStateException {
        this.verifyNotClosed();
        this.replicationTracker.persistRetentionLeases(this.path.getShardStatePath());
    }

    public boolean assertRetentionLeasesPersisted() throws IOException {
        return this.replicationTracker.assertRetentionLeasesPersisted(this.path.getShardStatePath());
    }

    public void syncRetentionLeases() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.renewPeerRecoveryRetentionLeases();
        Tuple<Boolean, RetentionLeases> retentionLeases = this.getRetentionLeases(true);
        if (((Boolean)retentionLeases.v1()).booleanValue()) {
            this.logger.trace("syncing retention leases [{}] after expiration check", retentionLeases.v2());
            this.retentionLeaseSyncer.sync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases.v2(), (ActionListener<ReplicationResponse>)ActionListener.wrap(r -> {}, e -> this.logger.warn((Message)new ParameterizedMessage("failed to sync retention leases [{}] after expiration check", (Object)retentionLeases), (Throwable)e)));
        } else {
            this.logger.trace("background syncing retention leases [{}] after expiration check", retentionLeases.v2());
            this.retentionLeaseSyncer.backgroundSync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases.v2());
        }
    }

    public void initiateTracking(String allocationId) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.initiateTracking(allocationId);
    }

    public void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        assert (this.assertPrimaryMode());
        this.replicationTracker.markAllocationIdAsInSync(allocationId, localCheckpoint);
    }

    public long getLocalCheckpoint() {
        return this.getEngine().getPersistedLocalCheckpoint();
    }

    public long getProcessedLocalCheckpoint() {
        return this.getEngine().getProcessedLocalCheckpoint();
    }

    public long getLastKnownGlobalCheckpoint() {
        return this.replicationTracker.getGlobalCheckpoint();
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.getEngine().getLastSyncedGlobalCheckpoint();
    }

    public Map<String, Long> getInSyncGlobalCheckpoints() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getInSyncGlobalCheckpoints();
    }

    public void maybeSyncGlobalCheckpoint(String reason) {
        boolean asyncDurability;
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "only call maybeSyncGlobalCheckpoint on primary shard";
        if (!this.replicationTracker.isPrimaryMode()) {
            return;
        }
        assert (this.assertPrimaryMode());
        SeqNoStats stats = this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
        boolean bl = asyncDurability = this.indexSettings().getTranslogDurability() == Translog.Durability.ASYNC;
        if (stats.getMaxSeqNo() == stats.getGlobalCheckpoint() || asyncDurability) {
            boolean syncNeeded;
            Map<String, Long> globalCheckpoints = this.getInSyncGlobalCheckpoints();
            long globalCheckpoint = this.replicationTracker.getGlobalCheckpoint();
            boolean bl2 = syncNeeded = asyncDurability && (stats.getGlobalCheckpoint() < stats.getMaxSeqNo() || this.replicationTracker.pendingInSync()) || StreamSupport.stream(globalCheckpoints.values().spliterator(), false).anyMatch(v -> v < globalCheckpoint);
            if (syncNeeded && this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN) {
                this.logger.trace("syncing global checkpoint for [{}]", (Object)reason);
                this.globalCheckpointSyncer.run();
            }
        }
    }

    public ReplicationGroup getReplicationGroup() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        ReplicationGroup replicationGroup = this.replicationTracker.getReplicationGroup();
        this.pendingReplicationActions.accept(replicationGroup);
        return replicationGroup;
    }

    public PendingReplicationActions getPendingReplicationActions() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.pendingReplicationActions;
    }

    public void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        assert (this.assertReplicationTarget());
        long localCheckpoint = this.getLocalCheckpoint();
        if (globalCheckpoint > localCheckpoint) {
            assert (this.state() != IndexShardState.POST_RECOVERY && this.state() != IndexShardState.STARTED || this.indexSettings.isAssignedOnRemoteNode()) : "supposedly in-sync shard copy received a global checkpoint [" + globalCheckpoint + "] that is higher than its local checkpoint [" + localCheckpoint + "]";
            return;
        }
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateWithPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        assert (this.shardRouting.primary() && this.shardRouting.isRelocationTarget()) : "only primary relocation target can update allocation IDs from primary context: " + String.valueOf(this.shardRouting);
        assert (primaryContext.getCheckpointStates().containsKey(this.routingEntry().allocationId().getId())) : "primary context [" + String.valueOf(primaryContext) + "] does not contain relocation target [" + String.valueOf(this.routingEntry()) + "]";
        String allocationId = this.routingEntry().allocationId().getId();
        if (this.isRemoteStoreEnabled() || this.isMigratingToRemote()) {
            allocationId = primaryContext.getRoutingTable().primaryShard().allocationId().getId();
        }
        assert (this.getLocalCheckpoint() == primaryContext.getCheckpointStates().get(allocationId).getLocalCheckpoint() || this.indexSettings().getTranslogDurability() == Translog.Durability.ASYNC) : "local checkpoint [" + this.getLocalCheckpoint() + "] does not match checkpoint from primary context [" + String.valueOf(primaryContext) + "]";
        Object object = this.mutex;
        synchronized (object) {
            this.replicationTracker.activateWithPrimaryContext(primaryContext);
        }
        this.postActivatePrimaryMode();
    }

    private void postActivatePrimaryMode() {
        if (this.indexSettings.isAssignedOnRemoteNode()) {
            try {
                this.getEngine().translogManager().syncTranslog();
            }
            catch (IOException e) {
                this.logger.error("Failed to sync translog to remote from new primary", (Throwable)e);
            }
        }
        this.ensurePeerRecoveryRetentionLeasesExist();
    }

    private void ensurePeerRecoveryRetentionLeasesExist() {
        this.threadPool.generic().execute(() -> this.replicationTracker.createMissingPeerRecoveryRetentionLeases((ActionListener<Void>)ActionListener.wrap(r -> this.logger.trace("created missing peer recovery retention leases"), e -> this.logger.debug("failed creating missing peer recovery retention leases", (Throwable)e))));
    }

    public boolean pendingInSync() {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.pendingInSync();
    }

    public void noopUpdate() {
        this.internalIndexingStats.noopUpdate();
    }

    public void maybeCheckIndex() {
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.isTrue((String)this.checkIndexOnStartup) || "checksum".equals(this.checkIndexOnStartup)) {
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
    }

    void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            catch (IOException e) {
                this.store.markStoreCorrupted(e);
                throw e;
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        long timeNS = System.nanoTime();
        if (!Lucene.indexExists(this.store.directory())) {
            return;
        }
        try (BytesStreamOutput os = new BytesStreamOutput();
             PrintStream out = new PrintStream((OutputStream)((Object)os), false, StandardCharsets.UTF_8.name());){
            if ("checksum".equals(this.checkIndexOnStartup)) {
                IOException corrupt = null;
                Store.MetadataSnapshot metadata = this.snapshotStoreMetadata();
                for (Map.Entry<String, StoreFileMetadata> entry : metadata.asMap().entrySet()) {
                    try {
                        Store.checkIntegrity(entry.getValue(), this.store.directory());
                        out.println("checksum passed: " + entry.getKey());
                    }
                    catch (IOException exc) {
                        out.println("checksum failed: " + entry.getKey());
                        exc.printStackTrace(out);
                        corrupt = exc;
                    }
                }
                out.flush();
                if (corrupt != null) {
                    this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                    throw corrupt;
                }
            } else {
                CheckIndex.Status status = this.store.checkIndex(out);
                out.flush();
                if (!status.clean) {
                    if (this.state == IndexShardState.CLOSED) {
                        return;
                    }
                    this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                    throw new IOException("index check failure");
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
            }
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS))));
    }

    Engine getEngine() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throw new AlreadyClosedException("engine is closed");
        }
        return engine;
    }

    protected Engine getEngineOrNull() {
        return this.currentEngineReference.get();
    }

    public void startRecovery(RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, RecoveryListener recoveryListener, RepositoriesService repositoriesService, Consumer<MappingMetadata> mappingUpdateConsumer, IndicesService indicesService) {
        this.logger.debug("startRecovery type={}", (Object)recoveryState.getRecoverySource().getType());
        assert (recoveryState.getRecoverySource().equals(this.shardRouting.recoverySource()));
        switch (recoveryState.getRecoverySource().getType()) {
            case EMPTY_STORE: 
            case EXISTING_STORE: {
                this.executeRecovery("from store", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)this::recoverFromStore));
                break;
            }
            case REMOTE_STORE: {
                this.executeRecovery("from remote store", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.restoreFromRemoteStore((ActionListener<Boolean>)l)));
                break;
            }
            case PEER: {
                try {
                    this.markAsRecovering("from " + String.valueOf(recoveryState.getSourceNode()), recoveryState);
                    recoveryTargetService.startRecovery(this, recoveryState.getSourceNode(), recoveryListener);
                }
                catch (Exception e) {
                    this.failShard("corrupted preexisting index", e);
                    recoveryListener.onFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                }
                break;
            }
            case SNAPSHOT: {
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)recoveryState.getRecoverySource();
                if (recoverySource.isSearchableSnapshot()) {
                    this.executeRecovery("from snapshot (remote)", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)this::recoverFromStore));
                    break;
                }
                if (recoverySource.remoteStoreIndexShallowCopy()) {
                    String repo = recoverySource.snapshot().getRepository();
                    this.executeRecovery("from snapshot and remote store", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.restoreFromSnapshotAndRemoteStore(repositoriesService.repository(repo), repositoriesService, (ActionListener<Boolean>)l)));
                    break;
                }
                String repo = recoverySource.snapshot().getRepository();
                this.executeRecovery("from snapshot", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.restoreFromRepository(repositoriesService.repository(repo), (ActionListener<Boolean>)l)));
                break;
            }
            case LOCAL_SHARDS: {
                int numShards;
                Set<Object> requiredShards;
                IndexMetadata indexMetadata = this.indexSettings().getIndexMetadata();
                Index resizeSourceIndex = indexMetadata.getResizeSourceIndex();
                ArrayList<IndexShard> startedShards = new ArrayList<IndexShard>();
                IndexService sourceIndexService = indicesService.indexService(resizeSourceIndex);
                if (sourceIndexService != null) {
                    requiredShards = IndexMetadata.selectRecoverFromShards(this.shardId().id(), sourceIndexService.getMetadata(), indexMetadata.getNumberOfShards());
                    for (IndexShard shard : sourceIndexService) {
                        if (shard.state() != IndexShardState.STARTED || !requiredShards.contains(shard.shardId())) continue;
                        startedShards.add(shard);
                    }
                    numShards = requiredShards.size();
                } else {
                    numShards = -1;
                    requiredShards = Collections.emptySet();
                }
                if (numShards == startedShards.size()) {
                    assert (!requiredShards.isEmpty());
                    this.executeRecovery("from local shards", recoveryState, recoveryListener, (CheckedConsumer<ActionListener<Boolean>, Exception>)((CheckedConsumer)l -> this.recoverFromLocalShards(mappingUpdateConsumer, startedShards.stream().filter(s -> requiredShards.contains(s.shardId())).collect(Collectors.toList()), (ActionListener<Boolean>)l)));
                    break;
                }
                Object e = numShards == -1 ? new IndexNotFoundException(resizeSourceIndex) : new IllegalStateException("not all required shards of index " + String.valueOf(resizeSourceIndex) + " are started yet, expected " + numShards + " found " + startedShards.size() + " can't recover shard " + String.valueOf(this.shardId()));
                throw e;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery source " + String.valueOf(recoveryState.getRecoverySource()));
            }
        }
    }

    private void executeRecovery(String reason, RecoveryState recoveryState, RecoveryListener recoveryListener, CheckedConsumer<ActionListener<Boolean>, Exception> action) {
        this.markAsRecovering(reason, recoveryState);
        this.threadPool.generic().execute(ActionRunnable.wrap(ActionListener.wrap(r -> {
            if (r.booleanValue()) {
                recoveryListener.onDone(recoveryState);
            }
        }, e -> recoveryListener.onFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true)), action));
    }

    public boolean isRelocatedPrimary() {
        assert (this.shardRouting.primary()) : "only call isRelocatedPrimary on primary shard";
        return this.replicationTracker.isRelocated();
    }

    public RetentionLease addPeerRecoveryRetentionLease(String nodeId, long globalCheckpoint, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        assert (!this.indexSettings.isSoftDeleteEnabled());
        return this.replicationTracker.addPeerRecoveryRetentionLease(nodeId, globalCheckpoint, listener);
    }

    public RetentionLease cloneLocalPeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.cloneLocalPeerRecoveryRetentionLease(nodeId, listener);
    }

    public void removePeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.removePeerRecoveryRetentionLease(nodeId, listener);
    }

    public List<RetentionLease> getPeerRecoveryRetentionLeases() {
        return this.replicationTracker.getPeerRecoveryRetentionLeases();
    }

    public boolean useRetentionLeasesInPeerRecovery() {
        return this.useRetentionLeasesInPeerRecovery;
    }

    private SafeCommitInfo getSafeCommitInfo() {
        Engine engine = this.getEngineOrNull();
        return engine == null ? SafeCommitInfo.EMPTY : engine.getSafeCommitInfo();
    }

    private static void persistMetadata(ShardPath shardPath, IndexSettings indexSettings, ShardRouting newRouting, @Nullable ShardRouting currentRouting, Logger logger) throws IOException {
        assert (newRouting != null) : "newRouting must not be null";
        ShardId shardId = newRouting.shardId();
        if (currentRouting == null || currentRouting.primary() != newRouting.primary() || !currentRouting.allocationId().equals(newRouting.allocationId())) {
            assert (currentRouting == null || currentRouting.isSameAllocation(newRouting));
            String writeReason = currentRouting == null ? "initial state with allocation id [" + String.valueOf(newRouting.allocationId()) + "]" : "routing changed from " + String.valueOf(currentRouting) + " to " + String.valueOf(newRouting);
            logger.trace("{} writing shard state, reason [{}]", (Object)shardId, (Object)writeReason);
            ShardStateMetadata.IndexDataLocation indexDataLocation = IndexSettings.SEARCHABLE_SNAPSHOT_REPOSITORY.exists(indexSettings.getSettings()) ? ShardStateMetadata.IndexDataLocation.REMOTE : ShardStateMetadata.IndexDataLocation.LOCAL;
            ShardStateMetadata newShardStateMetadata = new ShardStateMetadata(newRouting.primary(), indexSettings.getUUID(), newRouting.allocationId(), indexDataLocation);
            ShardStateMetadata.FORMAT.writeAndCleanup(newShardStateMetadata, shardPath.getShardStatePath());
        } else {
            logger.trace("{} skip writing shard state, has been written before", (Object)shardId);
        }
    }

    private DocumentMapperForType docMapper() {
        return this.mapperService.documentMapperWithAutoCreate();
    }

    private EngineConfig newEngineConfig(LongSupplier globalCheckpointSupplier) throws IOException {
        boolean isReadOnlyReplica;
        Sort indexSort = this.indexSortSupplier.get();
        Engine.Warmer warmer = reader -> {
            assert (!Thread.holdsLock(this.mutex)) : "warming engine under mutex";
            assert (reader != null);
            if (this.warmer != null) {
                this.warmer.warm(reader);
            }
        };
        this.internalRefreshListener.clear();
        this.internalRefreshListener.add(new RefreshMetricUpdater(this.refreshMetric));
        if (this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            this.internalRefreshListener.add(new ReplicationCheckpointUpdater());
        }
        if (this.checkpointPublisher != null && this.shardRouting.primary() && this.indexSettings.isSegRepLocalEnabled()) {
            this.internalRefreshListener.add(new CheckpointRefreshListener(this, this.checkpointPublisher));
        }
        if (this.isRemoteStoreEnabled() || this.isMigratingToRemote()) {
            this.internalRefreshListener.add(new RemoteStoreRefreshListener(this, this.checkpointPublisher, this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(this.shardId()), this.remoteStoreSettings));
        }
        boolean bl = isReadOnlyReplica = this.indexSettings.isSegRepEnabledOrRemoteNode() && (!this.shardRouting.primary() || this.shardRouting.isRelocationTarget() && this.recoveryState.getStage() != RecoveryState.Stage.FINALIZE);
        if (this.shouldSeedRemoteStore()) {
            isReadOnlyReplica = false;
        }
        return this.engineConfigFactory.newEngineConfig(this.shardId, this.threadPool, this.indexSettings, warmer, this.store, this.indexSettings.getMergePolicy(this.isTimeSeriesIndex), this.mapperService != null ? this.mapperService.indexAnalyzer() : null, this.similarityService.similarity(this.mapperService), this.engineConfigFactory.newCodecServiceOrDefault(this.indexSettings, this.mapperService, this.logger, this.codecService), this.shardEventListener, this.indexCache != null ? this.indexCache.query() : null, this.cachingPolicy, this.translogConfig, IndexingMemoryController.SHARD_INACTIVE_TIME_SETTING.get(this.indexSettings.getSettings()), Arrays.asList(this.refreshListeners, this.refreshPendingLocationListener), this.internalRefreshListener, indexSort, this.circuitBreakerService, globalCheckpointSupplier, this.replicationTracker::getRetentionLeases, this::getOperationPrimaryTerm, this.tombstoneDocSupplier(), isReadOnlyReplica, this::enableUploadToRemoteTranslog, this.translogFactorySupplier.apply(this.indexSettings, this.shardRouting), this.isTimeSeriesDescSortOptimizationEnabled() ? DataStream.TIMESERIES_LEAF_SORTER : null, () -> this.docMapper(), this.mergedSegmentWarmerFactory.get(this), this.clusterApplierService);
    }

    private boolean isRemoteStoreEnabled() {
        return this.remoteStore != null && this.shardRouting.primary();
    }

    public boolean isRemoteTranslogEnabled() {
        return this.indexSettings() != null && this.indexSettings().isRemoteTranslogStoreEnabled();
    }

    public boolean isStartedPrimary() {
        return this.getReplicationTracker().isPrimaryMode() && this.state() == IndexShardState.STARTED;
    }

    public boolean enableUploadToRemoteTranslog() {
        return this.isStartedPrimary() || this.shouldSeedRemoteStore() && this.hasOneRemoteSegmentSyncHappened();
    }

    private boolean hasOneRemoteSegmentSyncHappened() {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        RemoteSegmentStoreDirectory rd = this.getRemoteDirectory();
        AtomicBoolean segment_n_uploaded = new AtomicBoolean(false);
        rd.getSegmentsUploadedToRemoteStore().forEach((key, value) -> {
            if (key.startsWith("segments")) {
                segment_n_uploaded.set(true);
            }
        });
        return segment_n_uploaded.get();
    }

    public boolean isTimeSeriesDescSortOptimizationEnabled() {
        return this.isTimeSeriesIndex && this.getIndexSort() == null;
    }

    public boolean isRemoteSnapshot() {
        return this.indexSettings != null && this.indexSettings.isRemoteSnapshot();
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.acquirePrimaryOperationPermit(onPermitAcquired, executorOnDelay, debugInfo, false);
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo, boolean forceExecution) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquirePrimaryOperationPermit should only be called on primary shard: " + String.valueOf(this.shardRouting);
        this.indexShardOperationPermits.acquire(this.wrapPrimaryOperationPermitListener(onPermitAcquired), executorOnDelay, forceExecution, debugInfo);
    }

    public void acquireAllPrimaryOperationsPermits(ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquireAllPrimaryOperationsPermits should only be called on primary shard: " + String.valueOf(this.shardRouting);
        this.asyncBlockOperations(this.wrapPrimaryOperationPermitListener(onPermitAcquired), timeout.duration(), timeout.timeUnit());
    }

    private ActionListener<Releasable> wrapPrimaryOperationPermitListener(ActionListener<Releasable> listener) {
        return ActionListener.delegateFailure(listener, (l, r) -> {
            if (this.replicationTracker.isPrimaryMode()) {
                l.onResponse(r);
            } else {
                r.close();
                l.onFailure((Exception)((Object)new ShardNotInPrimaryModeException(this.shardId, this.state)));
            }
        });
    }

    private void asyncBlockOperations(ActionListener<Releasable> onPermitAcquired, long timeout, TimeUnit timeUnit) {
        Releasable forceRefreshes = this.refreshListeners.forceRefreshes();
        ActionListener wrappedListener = ActionListener.wrap(r -> {
            forceRefreshes.close();
            onPermitAcquired.onResponse(r);
        }, e -> {
            forceRefreshes.close();
            onPermitAcquired.onFailure(e);
        });
        try {
            this.indexShardOperationPermits.asyncBlockOperations((ActionListener<Releasable>)wrappedListener, timeout, timeUnit);
        }
        catch (Exception e2) {
            forceRefreshes.close();
            throw e2;
        }
    }

    public void runUnderPrimaryPermit(Runnable runnable, Consumer<Exception> onFailure, String executorOnDelay, Object debugInfo) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "runUnderPrimaryPermit should only be called on primary shard but was " + String.valueOf(this.shardRouting);
        ActionListener onPermitAcquired = ActionListener.wrap(releasable -> {
            try (Releasable ignore = releasable;){
                runnable.run();
            }
        }, onFailure);
        this.acquirePrimaryOperationPermit((ActionListener<Releasable>)onPermitAcquired, executorOnDelay, debugInfo);
    }

    private <E extends Exception> void bumpPrimaryTerm(final long newPrimaryTerm, final CheckedRunnable<E> onBlocked, final @Nullable ActionListener<Releasable> combineWithAction) {
        assert (Thread.holdsLock(this.mutex));
        assert (newPrimaryTerm > this.pendingPrimaryTerm || newPrimaryTerm >= this.pendingPrimaryTerm && combineWithAction != null);
        assert (this.getOperationPrimaryTerm() <= this.pendingPrimaryTerm);
        final CountDownLatch termUpdated = new CountDownLatch(1);
        this.asyncBlockOperations(new ActionListener<Releasable>(){
            final /* synthetic */ IndexShard this$0;
            {
                this.this$0 = this$0;
            }

            public void onFailure(Exception e) {
                try {
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onFailure(e);
                    }
                }
            }

            private void innerFail(Exception e) {
                try {
                    this.this$0.failShard("exception during primary term transition", e);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Releasable releasable) {
                RunOnce releaseOnce = new RunOnce(() -> ((Releasable)releasable).close());
                try {
                    assert (this.this$0.getOperationPrimaryTerm() <= this.this$0.pendingPrimaryTerm);
                    termUpdated.await();
                    if (this.this$0.getOperationPrimaryTerm() < newPrimaryTerm) {
                        this.this$0.replicationTracker.setOperationPrimaryTerm(newPrimaryTerm);
                        onBlocked.run();
                    }
                }
                catch (Exception e) {
                    if (combineWithAction == null) {
                        releaseOnce.run();
                    }
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onResponse((Object)releasable);
                    } else {
                        releaseOnce.run();
                    }
                }
            }
        }, 30L, TimeUnit.MINUTES);
        this.pendingPrimaryTerm = newPrimaryTerm;
        termUpdated.countDown();
    }

    public void acquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, false, listener -> this.indexShardOperationPermits.acquire((ActionListener<Releasable>)listener, executorOnDelay, true, debugInfo));
    }

    public void acquireAllReplicaOperationsPermits(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, true, listener -> this.asyncBlockOperations((ActionListener<Releasable>)listener, timeout.duration(), timeout.timeUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerAcquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, boolean allowCombineOperationWithPrimaryTermUpdate, Consumer<ActionListener<Releasable>> operationExecutor) {
        this.verifyNotClosed();
        ActionListener operationListener = ActionListener.delegateFailure(onPermitAcquired, (delegatedListener, releasable) -> {
            if (opPrimaryTerm < this.getOperationPrimaryTerm()) {
                releasable.close();
                String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", this.shardId, opPrimaryTerm, this.getOperationPrimaryTerm());
                delegatedListener.onFailure((Exception)new IllegalStateException(message));
            } else {
                assert (this.assertReplicationTarget());
                try {
                    this.updateGlobalCheckpointOnReplica(globalCheckpoint, "operation");
                    this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
                }
                catch (Exception e) {
                    releasable.close();
                    delegatedListener.onFailure(e);
                    return;
                }
                delegatedListener.onResponse(releasable);
            }
        });
        if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
                    IndexShardState shardState = this.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        throw new IndexShardNotStartedException(this.shardId, shardState);
                    }
                    this.bumpPrimaryTerm(opPrimaryTerm, () -> {
                        this.updateGlobalCheckpointOnReplica(globalCheckpoint, "primary term transition");
                        long currentGlobalCheckpoint = this.getLastKnownGlobalCheckpoint();
                        long maxSeqNo = this.seqNoStats().getMaxSeqNo();
                        this.logger.info("detected new primary with primary term [{}], global checkpoint [{}], max_seq_no [{}]", (Object)opPrimaryTerm, (Object)currentGlobalCheckpoint, (Object)maxSeqNo);
                        if (currentGlobalCheckpoint < maxSeqNo && !this.indexSettings.isSegRepEnabledOrRemoteNode()) {
                            this.resetEngineToGlobalCheckpoint();
                        } else {
                            this.getEngine().translogManager().rollTranslogGeneration();
                        }
                    }, (ActionListener<Releasable>)(allowCombineOperationWithPrimaryTermUpdate ? operationListener : null));
                    if (allowCombineOperationWithPrimaryTermUpdate) {
                        this.logger.debug("operation execution has been combined with primary term update");
                        return;
                    }
                }
            }
        }
        assert (opPrimaryTerm <= this.pendingPrimaryTerm) : "operation primary term [" + opPrimaryTerm + "] should be at most [" + this.pendingPrimaryTerm + "]";
        operationExecutor.accept((ActionListener<Releasable>)operationListener);
    }

    private boolean requirePrimaryTermUpdate(long opPrimaryTerm, boolean allPermits) {
        return opPrimaryTerm > this.pendingPrimaryTerm || allPermits && opPrimaryTerm > this.getOperationPrimaryTerm();
    }

    public int getActiveOperationsCount() {
        return this.indexShardOperationPermits.getActiveOperationsCount();
    }

    public List<String> getActiveOperations() {
        return this.indexShardOperationPermits.getActiveOperations();
    }

    private static AsyncIOProcessor<Translog.Location> createTranslogSyncProcessor(Logger logger, ThreadPool threadPool, Supplier<Engine> engineSupplier, boolean bufferAsyncIoProcessor, Supplier<TimeValue> bufferIntervalSupplier) {
        assert (!bufferAsyncIoProcessor || Objects.nonNull(bufferIntervalSupplier)) : "If bufferAsyncIoProcessor is true, then the bufferIntervalSupplier needs to be non null";
        ThreadContext threadContext = threadPool.getThreadContext();
        final CheckedConsumer writeConsumer = candidates -> {
            try {
                ((Engine)engineSupplier.get()).translogManager().ensureTranslogSynced(candidates.stream().map(Tuple::v1));
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (IOException ex) {
                logger.debug("failed to sync translog", (Throwable)ex);
                throw ex;
            }
        };
        if (bufferAsyncIoProcessor) {
            return new BufferedAsyncIOProcessor<Translog.Location>(logger, 102400, threadContext, threadPool, bufferIntervalSupplier){

                @Override
                protected void write(List<Tuple<Translog.Location, Consumer<Exception>>> candidates) throws IOException {
                    writeConsumer.accept(candidates);
                }

                @Override
                protected String getBufferProcessThreadPoolName() {
                    return "translog_sync";
                }
            };
        }
        return new AsyncIOProcessor<Translog.Location>(logger, 1024, threadContext){

            @Override
            protected void write(List<Tuple<Translog.Location, Consumer<Exception>>> candidates) throws IOException {
                writeConsumer.accept(candidates);
            }
        };
    }

    public final void sync(Translog.Location location, Consumer<Exception> syncListener) {
        this.verifyNotClosed();
        this.translogSyncProcessor.put(location, syncListener);
    }

    public void sync() throws IOException {
        this.verifyNotClosed();
        this.getEngine().translogManager().syncTranslog();
    }

    public boolean isSyncNeeded() {
        return this.getEngine().translogManager().isTranslogSyncNeeded();
    }

    public Translog.Durability getTranslogDurability() {
        return this.indexSettings.getTranslogDurability();
    }

    public void afterWriteOperation() {
        if ((this.shouldPeriodicallyFlush() || this.shouldRollTranslogGeneration()) && this.flushOrRollRunning.compareAndSet(false, true)) {
            if (this.shouldPeriodicallyFlush()) {
                this.logger.debug("submitting async flush request");
                AbstractRunnable flush = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to flush index", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws IOException {
                        IndexShard.this.flush(new FlushRequest(new String[0]));
                        IndexShard.this.periodicFlushMetric.inc();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(flush);
            } else if (this.shouldRollTranslogGeneration()) {
                this.logger.debug("submitting async roll translog generation request");
                AbstractRunnable roll = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to roll translog generation", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws Exception {
                        IndexShard.this.rollTranslogGeneration();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(roll);
            } else {
                this.flushOrRollRunning.compareAndSet(true, false);
            }
        }
    }

    private RefreshListeners buildRefreshListeners() {
        return new RefreshListeners(this.indexSettings::getMaxRefreshListeners, () -> this.refresh("too_many_listeners"), this.logger, this.threadPool.getThreadContext(), this.externalRefreshMetric);
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    EngineConfigFactory getEngineConfigFactory() {
        return this.engineConfigFactory;
    }

    ReplicationTracker getReplicationTracker() {
        return this.replicationTracker;
    }

    public boolean scheduledRefresh() {
        this.verifyNotClosed();
        boolean listenerNeedsRefresh = this.refreshListeners.refreshNeeded();
        if (this.isReadAllowed() && (listenerNeedsRefresh || this.getEngine().refreshNeeded())) {
            if (!listenerNeedsRefresh && this.isSearchIdleSupported() && this.isSearchIdle() && !this.indexSettings.isExplicitRefresh() && this.active.get()) {
                Engine engine = this.getEngine();
                engine.maybePruneDeletes();
                this.setRefreshPending(engine);
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("refresh with source [schedule]");
            }
            return this.getEngine().maybeRefresh("schedule");
        }
        Engine engine = this.getEngine();
        engine.maybePruneDeletes();
        return false;
    }

    public final boolean isSearchIdle() {
        return this.threadPool.relativeTimeInMillis() - this.lastSearcherAccess.get() >= this.indexSettings.getSearchIdleAfter().getMillis();
    }

    public final boolean isSearchIdleSupported() {
        if (this.isRemoteTranslogEnabled() || this.indexSettings.isAssignedOnRemoteNode()) {
            return false;
        }
        return !this.indexSettings.isSegRepEnabledOrRemoteNode() || this.indexSettings.getNumberOfReplicas() == 0;
    }

    final long getLastSearcherAccess() {
        return this.lastSearcherAccess.get();
    }

    public final boolean hasRefreshPending() {
        return this.pendingRefreshLocation.get() != null;
    }

    private void setRefreshPending(Engine engine) {
        Translog.Location lastWriteLocation = engine.translogManager().getTranslogLastWriteLocation();
        this.pendingRefreshLocation.updateAndGet(curr -> {
            if (curr == null || curr.compareTo(lastWriteLocation) <= 0) {
                return lastWriteLocation;
            }
            return curr;
        });
    }

    public final void awaitShardSearchActive(Consumer<Boolean> listener) {
        boolean isSearchIdle = this.isSearchIdle();
        this.markSearcherAccessed();
        Translog.Location location = this.pendingRefreshLocation.get();
        if (location != null) {
            if (isSearchIdle) {
                SearchOperationListener searchOperationListener = this.getSearchOperationListener();
                searchOperationListener.onSearchIdleReactivation();
            }
            this.addRefreshListener(location, b -> {
                this.pendingRefreshLocation.compareAndSet(location, null);
                listener.accept(true);
            });
        } else {
            listener.accept(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(Translog.Location location, Consumer<Boolean> listener) {
        boolean readAllowed;
        if (this.isReadAllowed()) {
            readAllowed = true;
        } else {
            Object object = this.postRecoveryMutex;
            synchronized (object) {
                readAllowed = this.isReadAllowed();
            }
        }
        if (readAllowed && !this.isSegmentReplicationAllowed()) {
            this.refreshListeners.addOrNotify(location, listener);
        } else {
            listener.accept(false);
        }
    }

    private void updateReplicationCheckpoint() {
        Tuple<GatedCloseable<SegmentInfos>, ReplicationCheckpoint> tuple = this.getLatestSegmentInfosAndCheckpoint();
        try (GatedCloseable ignored = (GatedCloseable)tuple.v1();){
            this.replicationTracker.setLatestReplicationCheckpoint((ReplicationCheckpoint)tuple.v2());
        }
        catch (IOException e) {
            throw new OpenSearchException("Error Closing SegmentInfos Snapshot", (Throwable)e, new Object[0]);
        }
    }

    private EngineConfig.TombstoneDocSupplier tombstoneDocSupplier() {
        RootObjectMapper.Builder noopRootMapper = new RootObjectMapper.Builder("__noop");
        final DocumentMapper noopDocumentMapper = this.mapperService != null ? new DocumentMapper.Builder(noopRootMapper, this.mapperService).build(this.mapperService) : null;
        return new EngineConfig.TombstoneDocSupplier(){
            final /* synthetic */ IndexShard this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ParsedDocument newDeleteTombstoneDoc(String id) {
                return this.this$0.docMapper().getDocumentMapper().createDeleteTombstoneDoc(this.this$0.shardId.getIndexName(), id);
            }

            @Override
            public ParsedDocument newNoopTombstoneDoc(String reason) {
                return noopDocumentMapper.createNoopTombstoneDoc(this.this$0.shardId.getIndexName(), reason);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEngineToGlobalCheckpoint() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "resetting engine under mutex";
        assert (this.getActiveOperationsCount() == -1) : "resetting engine without blocking operations; active operations are [" + String.valueOf(this.getActiveOperations()) + "]";
        this.sync();
        SeqNoStats seqNoStats = this.seqNoStats();
        TranslogStats translogStats = this.translogStats();
        this.flush(new FlushRequest(new String[0]).waitIfOngoing(true));
        final SetOnce newEngineReference = new SetOnce();
        long globalCheckpoint = this.getLastKnownGlobalCheckpoint();
        assert (globalCheckpoint == this.getLastSyncedGlobalCheckpoint());
        Object object = this.engineMutex;
        synchronized (object) {
            this.verifyNotClosed();
            ReadOnlyEngine readOnlyEngine = new ReadOnlyEngine(this, this.newEngineConfig(this.replicationTracker), seqNoStats, translogStats, false, Function.identity(), true){
                final /* synthetic */ IndexShard this$0;
                {
                    this.this$0 = this$0;
                    super(config, seqNoStats, translogStats, obtainLock, readerWrapperFunction, requireCompleteHistory);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) {
                    Object object = this.this$0.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireLastIndexCommit(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GatedCloseable<IndexCommit> acquireSafeIndexCommit() {
                    Object object = this.this$0.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireSafeIndexCommit();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
                    Object object = this.this$0.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).getSegmentInfosSnapshot();
                    }
                }

                @Override
                public void close() throws IOException {
                    assert (Thread.holdsLock(this.this$0.engineMutex));
                    Engine newEngine = (Engine)newEngineReference.get();
                    if (newEngine == this.this$0.currentEngineReference.get()) {
                        newEngine = null;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), newEngine});
                }
            };
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet(readOnlyEngine));
            if (this.indexSettings.isRemoteStoreEnabled() || this.isRemoteSeeded()) {
                this.syncSegmentsFromRemoteSegmentStore(false);
            }
            if ((this.indexSettings.isRemoteTranslogStoreEnabled() || this.isRemoteSeeded()) && this.shardRouting.primary()) {
                this.syncRemoteTranslogAndUpdateGlobalCheckpoint();
            }
            newEngineReference.set((Object)this.engineFactory.newReadWriteEngine(this.newEngineConfig(this.replicationTracker)));
            this.onNewEngine((Engine)newEngineReference.get());
        }
        TranslogRecoveryRunner translogRunner = snapshot -> this.runTranslogRecovery((Engine)newEngineReference.get(), snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {});
        long recoverUpto = this.isRemoteTranslogEnabled() || this.indexSettings().isSegRepEnabledOrRemoteNode() ? Long.MAX_VALUE : globalCheckpoint;
        ((Engine)newEngineReference.get()).translogManager().recoverFromTranslog(translogRunner, ((Engine)newEngineReference.get()).getProcessedLocalCheckpoint(), recoverUpto);
        ((Engine)newEngineReference.get()).refresh("reset_engine");
        Object object2 = this.engineMutex;
        synchronized (object2) {
            this.verifyNotClosed();
            IOUtils.close((Closeable)this.currentEngineReference.getAndSet((Engine)newEngineReference.get()));
            this.active.set(true);
        }
        this.onSettingsChanged();
    }

    private void syncRemoteTranslogAndUpdateGlobalCheckpoint() throws IOException {
        this.syncTranslogFilesFromRemoteTranslog();
        this.loadGlobalCheckpointToReplicationTracker();
    }

    public void deleteTranslogFilesFromRemoteTranslog() throws IOException {
        TranslogFactory translogFactory = this.translogFactorySupplier.apply(this.indexSettings, this.shardRouting);
        assert (translogFactory instanceof RemoteBlobStoreInternalTranslogFactory);
        Repository repository = ((RemoteBlobStoreInternalTranslogFactory)translogFactory).getRepository();
        RemoteFsTranslog.cleanup(repository, this.shardId, this.getThreadPool(), this.indexSettings.getRemoteStorePathStrategy(), this.remoteStoreSettings, this.indexSettings().isTranslogMetadataEnabled());
    }

    public void deleteRemoteStoreContents() throws IOException {
        this.deleteTranslogFilesFromRemoteTranslog();
        this.getRemoteDirectory().delete();
    }

    public void syncTranslogFilesFromRemoteTranslog() throws IOException {
        TranslogFactory translogFactory = this.translogFactorySupplier.apply(this.indexSettings, this.shardRouting);
        assert (translogFactory instanceof RemoteBlobStoreInternalTranslogFactory);
        Repository repository = ((RemoteBlobStoreInternalTranslogFactory)translogFactory).getRepository();
        this.syncTranslogFilesFromGivenRemoteTranslog(repository, this.shardId, this.indexSettings.getRemoteStorePathStrategy(), this.indexSettings().isTranslogMetadataEnabled(), 0L);
    }

    public void syncTranslogFilesFromGivenRemoteTranslog(Repository repository, ShardId shardId, RemoteStorePathStrategy remoteStorePathStrategy, boolean isTranslogMetadataEnabled, long timestamp) throws IOException {
        RemoteFsTranslog.download(repository, shardId, this.getThreadPool(), this.shardPath().resolveTranslog(), remoteStorePathStrategy, this.remoteStoreSettings, this.logger, this.shouldSeedRemoteStore(), isTranslogMetadataEnabled, timestamp);
    }

    public void syncSegmentsFromRemoteSegmentStore(boolean overrideLocal) throws IOException {
        this.syncSegmentsFromRemoteSegmentStore(overrideLocal, () -> {});
    }

    public void syncSegmentsFromRemoteSegmentStore(boolean overrideLocal, Runnable onFileSync) throws IOException {
        boolean syncSegmentSuccess = false;
        long startTimeMs = System.currentTimeMillis();
        assert (this.indexSettings.isRemoteStoreEnabled() || this.isRemoteSeeded());
        this.logger.trace("Downloading segments from remote segment store");
        RemoteSegmentStoreDirectory remoteDirectory = this.getRemoteDirectory();
        RemoteSegmentMetadata remoteSegmentMetadata = remoteDirectory.init();
        Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegments = remoteDirectory.getSegmentsUploadedToRemoteStore().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("segments")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.store.incRef();
        this.remoteStore.incRef();
        try {
            Object storeDirectory;
            if (this.recoveryState.getStage() == RecoveryState.Stage.INDEX) {
                storeDirectory = new StoreRecovery.StatsDirectoryWrapper(this.store.directory(), this.recoveryState.getIndex());
                for (String file : uploadedSegments.keySet()) {
                    long checksum = Long.parseLong(uploadedSegments.get(file).getChecksum());
                    if (overrideLocal || !this.localDirectoryContains((Directory)storeDirectory, file, checksum)) {
                        this.recoveryState.getIndex().addFileDetail(file, uploadedSegments.get(file).getLength(), false);
                        continue;
                    }
                    this.recoveryState.getIndex().addFileDetail(file, uploadedSegments.get(file).getLength(), true);
                }
            } else {
                storeDirectory = this.store.directory();
            }
            if (!this.indexSettings.isWarmIndex()) {
                this.copySegmentFiles((Directory)storeDirectory, remoteDirectory, null, uploadedSegments, overrideLocal, onFileSync);
            }
            if (remoteSegmentMetadata != null) {
                SegmentInfos infosSnapshot = this.store.buildSegmentInfos(remoteSegmentMetadata.getSegmentInfosBytes(), remoteSegmentMetadata.getGeneration());
                long processedLocalCheckpoint = Long.parseLong((String)infosSnapshot.getUserData().get("local_checkpoint"));
                for (String file : List.of(this.store.directory().listAll())) {
                    if (!file.startsWith("segments")) continue;
                    this.store.deleteQuiet(file);
                }
                assert (Arrays.stream(this.store.directory().listAll()).filter(f -> f.startsWith("segments")).findAny().isEmpty() || this.indexSettings.isWarmIndex()) : "There should not be any segments file in the dir";
                this.store.commitSegmentInfos(infosSnapshot, processedLocalCheckpoint, processedLocalCheckpoint);
            }
            syncSegmentSuccess = true;
        }
        catch (IOException e) {
            throw new IndexShardRecoveryException(this.shardId, "Exception while copying segment files from remote segment store", e);
        }
        finally {
            this.logger.trace("syncSegmentsFromRemoteSegmentStore success={} elapsedTime={}", (Object)syncSegmentSuccess, (Object)(System.currentTimeMillis() - startTimeMs));
            this.store.decRef();
            this.remoteStore.decRef();
        }
    }

    public void syncSegmentsFromGivenRemoteSegmentStore(boolean overrideLocal, RemoteSegmentStoreDirectory sourceRemoteDirectory, RemoteSegmentMetadata remoteSegmentMetadata, boolean pinnedTimestamp) throws IOException {
        block21: {
            this.logger.trace("Downloading segments from given remote segment store");
            RemoteSegmentStoreDirectory remoteDirectory = null;
            if (this.remoteStore != null) {
                remoteDirectory = this.getRemoteDirectory();
                remoteDirectory.init();
                this.remoteStore.incRef();
            }
            Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegments = sourceRemoteDirectory.getSegmentsUploadedToRemoteStore();
            this.store.incRef();
            try {
                Object storeDirectory;
                if (this.recoveryState.getStage() == RecoveryState.Stage.INDEX) {
                    storeDirectory = new StoreRecovery.StatsDirectoryWrapper(this.store.directory(), this.recoveryState.getIndex());
                    for (String file : uploadedSegments.keySet()) {
                        long checksum = Long.parseLong(uploadedSegments.get(file).getChecksum());
                        if (overrideLocal || !this.localDirectoryContains((Directory)storeDirectory, file, checksum)) {
                            this.recoveryState.getIndex().addFileDetail(file, uploadedSegments.get(file).getLength(), false);
                            continue;
                        }
                        this.recoveryState.getIndex().addFileDetail(file, uploadedSegments.get(file).getLength(), true);
                    }
                } else {
                    storeDirectory = this.store.directory();
                }
                String segmentsNFile = this.copySegmentFiles((Directory)storeDirectory, sourceRemoteDirectory, remoteDirectory, uploadedSegments, overrideLocal, () -> {});
                if (pinnedTimestamp) {
                    SegmentInfos infosSnapshot = this.store.buildSegmentInfos(remoteSegmentMetadata.getSegmentInfosBytes(), remoteSegmentMetadata.getGeneration());
                    long processedLocalCheckpoint = Long.parseLong((String)infosSnapshot.getUserData().get("local_checkpoint"));
                    for (String file : List.of(this.store.directory().listAll())) {
                        if (!file.startsWith("segments")) continue;
                        this.store.deleteQuiet(file);
                    }
                    assert (Arrays.stream(this.store.directory().listAll()).filter(f -> f.startsWith("segments")).findAny().isEmpty() || this.indexSettings.isWarmIndex()) : "There should not be any segments file in the dir";
                    this.store.commitSegmentInfos(infosSnapshot, processedLocalCheckpoint, processedLocalCheckpoint);
                    break block21;
                }
                if (segmentsNFile == null) break block21;
                try (BufferedChecksumIndexInput indexInput = new BufferedChecksumIndexInput(storeDirectory.openInput(segmentsNFile, IOContext.READONCE));){
                    long commitGeneration = SegmentInfos.generationFromSegmentsFileName((String)segmentsNFile);
                    SegmentInfos infosSnapshot = SegmentInfos.readCommit((Directory)this.store.directory(), (ChecksumIndexInput)indexInput, (long)commitGeneration);
                    long processedLocalCheckpoint = Long.parseLong((String)infosSnapshot.getUserData().get("local_checkpoint"));
                    if (this.remoteStore != null) {
                        this.store.commitSegmentInfos(infosSnapshot, processedLocalCheckpoint, processedLocalCheckpoint);
                    } else {
                        this.store.directory().sync(infosSnapshot.files(true));
                        this.store.directory().syncMetaData();
                    }
                }
            }
            catch (IOException e) {
                throw new IndexShardRecoveryException(this.shardId, "Exception while copying segment files from remote segment store", e);
            }
            finally {
                this.store.decRef();
                if (this.remoteStore != null) {
                    this.remoteStore.decRef();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copySegmentFiles(Directory storeDirectory, RemoteSegmentStoreDirectory sourceRemoteDirectory, RemoteSegmentStoreDirectory targetRemoteDirectory, Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegments, boolean overrideLocal, Runnable onFileSync) throws IOException {
        String segmentNFile;
        block11: {
            HashSet<String> toDownloadSegments = new HashSet<String>();
            HashSet<String> skippedSegments = new HashSet<String>();
            segmentNFile = null;
            try {
                if (overrideLocal) {
                    for (String file : storeDirectory.listAll()) {
                        storeDirectory.deleteFile(file);
                    }
                }
                for (String file : uploadedSegments.keySet()) {
                    long checksum = Long.parseLong(uploadedSegments.get(file).getChecksum());
                    if (overrideLocal || !this.localDirectoryContains(storeDirectory, file, checksum)) {
                        toDownloadSegments.add(file);
                    } else {
                        skippedSegments.add(file);
                    }
                    if (!file.startsWith("segments")) continue;
                    assert (segmentNFile == null) : "There should be only one SegmentInfosSnapshot file";
                    segmentNFile = file;
                }
                if (toDownloadSegments.isEmpty()) break block11;
                try {
                    this.fileDownloader.download((Directory)sourceRemoteDirectory, storeDirectory, (Directory)targetRemoteDirectory, toDownloadSegments, onFileSync);
                }
                catch (Exception e) {
                    throw new IOException("Error occurred when downloading segments from remote store", e);
                }
            }
            finally {
                this.logger.trace("Downloaded segments here: {}", toDownloadSegments);
                this.logger.trace("Skipped download for segments here: {}", skippedSegments);
            }
        }
        return segmentNFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean localDirectoryContains(Directory localDirectory, String file, long checksum) throws IOException {
        try (IndexInput indexInput = localDirectory.openInput(file, IOContext.READONCE);){
            if (checksum == CodecUtil.retrieveChecksum((IndexInput)indexInput)) {
                boolean bl = true;
                return bl;
            }
            this.logger.warn("Checksum mismatch between local and remote segment file: {}, will override local file", (Object)file);
            if (!this.isReadAllowed()) {
                localDirectory.deleteFile(file);
                return false;
            }
            this.failShard("Local copy of segment " + file + " has a different checksum than the version in remote store", null);
            return false;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.logger.debug("File {} does not exist in local FS, downloading from remote store", (Object)file);
            return false;
        }
        catch (IOException e) {
            this.logger.warn("Exception while reading checksum of file: {}, this can happen if file is corrupted", (Object)file);
            localDirectory.deleteFile(file);
        }
        return false;
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.getEngine().getMaxSeqNoOfUpdatesOrDeletes();
    }

    public void advanceMaxSeqNoOfUpdatesOrDeletes(long seqNo) {
        this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    public void verifyShardBeforeIndexClosing() throws IllegalStateException {
        this.getEngine().verifyEngineBeforeIndexClosing();
    }

    RetentionLeaseSyncer getRetentionLeaseSyncer() {
        return this.retentionLeaseSyncer;
    }

    public GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
        return this.getEngine().getSegmentInfosSnapshot();
    }

    private TimeValue getRemoteTranslogUploadBufferInterval(Supplier<TimeValue> clusterRemoteTranslogBufferIntervalSupplier) {
        assert (Objects.nonNull(clusterRemoteTranslogBufferIntervalSupplier)) : "remote translog buffer interval supplier is null";
        if (this.indexSettings().isRemoteTranslogBufferIntervalExplicit()) {
            return this.indexSettings().getRemoteTranslogUploadBufferInterval();
        }
        return clusterRemoteTranslogBufferIntervalSupplier.get();
    }

    public AsyncIOProcessor<Translog.Location> getTranslogSyncProcessor() {
        return this.translogSyncProcessor;
    }

    static ShardMigrationState getShardMigrationState(IndexSettings indexSettings, boolean shouldSeed) {
        if (indexSettings.isAssignedOnRemoteNode() && indexSettings.isRemoteStoreEnabled()) {
            return ShardMigrationState.REMOTE_NON_MIGRATING;
        }
        if (indexSettings.isAssignedOnRemoteNode()) {
            return shouldSeed ? ShardMigrationState.REMOTE_MIGRATING_UNSEEDED : ShardMigrationState.REMOTE_MIGRATING_SEEDED;
        }
        return ShardMigrationState.DOCREP_NON_MIGRATING;
    }

    @Override
    public void updateShardIngestionState(IndexMetadata indexMetadata) {
        if (!indexMetadata.useIngestionSource()) {
            return;
        }
        IngestionSettings ingestionSettings = IngestionSettings.builder().setIsPaused(indexMetadata.getIngestionStatus().isPaused()).build();
        this.updateShardIngestionState(ingestionSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShardIngestionState(IngestionSettings ingestionSettings) {
        Object object = this.engineMutex;
        synchronized (object) {
            if (!(this.getEngineOrNull() instanceof IngestionEngine)) {
                return;
            }
            IngestionEngine ingestionEngine = (IngestionEngine)this.getEngineOrNull();
            ingestionEngine.updateIngestionSettings(ingestionSettings);
        }
    }

    @Override
    public ShardIngestionState getIngestionState() {
        Engine engine = this.getEngineOrNull();
        if (!this.indexSettings.getIndexMetadata().useIngestionSource() || !(engine instanceof IngestionEngine)) {
            throw new OpenSearchException("Unable to retrieve ingestion state as the shard does not have ingestion enabled.", new Object[0]);
        }
        IngestionEngine ingestionEngine = (IngestionEngine)engine;
        return ingestionEngine.getIngestionState();
    }

    public void startRefreshTask() {
        assert (Thread.holdsLock(this.refreshMutex));
        assert (Objects.isNull(this.refreshTask));
        this.refreshTask = new AsyncShardRefreshTask(this, this);
    }

    public void stopRefreshTask() {
        assert (Thread.holdsLock(this.refreshMutex));
        assert (Objects.nonNull(this.refreshTask));
        this.refreshTask.close();
        this.refreshTask = null;
    }

    public AsyncShardRefreshTask getRefreshTask() {
        return this.refreshTask;
    }

    class ShardEventListener
    implements Engine.EventListener {
        private final CopyOnWriteArrayList<Consumer<ShardFailure>> delegates = new CopyOnWriteArrayList();

        ShardEventListener() {
        }

        @Override
        public void onFailedEngine(String reason, @Nullable Exception failure) {
            ShardFailure shardFailure = new ShardFailure(IndexShard.this.shardRouting, reason, failure);
            for (Consumer<ShardFailure> listener : this.delegates) {
                try {
                    listener.accept(shardFailure);
                }
                catch (Exception inner) {
                    inner.addSuppressed(failure);
                    IndexShard.this.logger.warn("exception while notifying engine failure", (Throwable)inner);
                }
            }
        }
    }

    private class RefreshPendingLocationListener
    implements ReferenceManager.RefreshListener {
        Translog.Location lastWriteLocation;

        private RefreshPendingLocationListener() {
        }

        public void beforeRefresh() {
            try {
                this.lastWriteLocation = IndexShard.this.getEngine().translogManager().getTranslogLastWriteLocation();
            }
            catch (AlreadyClosedException exc) {
                this.lastWriteLocation = null;
            }
        }

        public void afterRefresh(boolean didRefresh) {
            if (didRefresh && this.lastWriteLocation != null) {
                IndexShard.this.pendingRefreshLocation.updateAndGet(pendingLocation -> {
                    if (pendingLocation == null || pendingLocation.compareTo(this.lastWriteLocation) <= 0) {
                        return null;
                    }
                    return pendingLocation;
                });
            }
        }
    }

    static enum ShardMigrationState {
        REMOTE_NON_MIGRATING,
        REMOTE_MIGRATING_SEEDED,
        REMOTE_MIGRATING_UNSEEDED,
        DOCREP_NON_MIGRATING;

    }

    private static final class NonClosingReaderWrapper
    extends FilterDirectoryReader {
        private NonClosingReaderWrapper(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return reader;
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new NonClosingReaderWrapper(in);
        }

        protected void doClose() throws IOException {
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    @ExperimentalApi
    public final class AsyncShardRefreshTask
    extends AbstractAsyncTask {
        private final IndexShard indexShard;
        private final Logger logger;

        public AsyncShardRefreshTask(IndexShard this$0, IndexShard indexShard) {
            super(indexShard.logger, indexShard.threadPool, this$0.refreshInterval.get(), true, this$0.fixedRefreshIntervalSchedulingEnabled);
            this.logger = indexShard.logger;
            this.indexShard = indexShard;
            this.rescheduleIfNecessary();
        }

        @Override
        protected boolean mustReschedule() {
            return this.indexShard.state != IndexShardState.CLOSED && this.indexShard.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN;
        }

        @Override
        protected void runInternal() {
            this.indexShard.scheduledRefresh();
        }

        @Override
        protected String getThreadPool() {
            return "refresh";
        }

        public String toString() {
            return "shard_refresh";
        }
    }

    private static class RefreshMetricUpdater
    implements ReferenceManager.RefreshListener {
        private final MeanMetric refreshMetric;
        private long currentRefreshStartTime;
        private Thread callingThread = null;

        private RefreshMetricUpdater(MeanMetric refreshMetric) {
            this.refreshMetric = refreshMetric;
        }

        public void beforeRefresh() throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread == null) : "beforeRefresh was called by " + this.callingThread.getName() + " without a corresponding call to afterRefresh";
                this.callingThread = Thread.currentThread();
            }
            this.currentRefreshStartTime = System.nanoTime();
        }

        public void afterRefresh(boolean didRefresh) throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread != null) : "afterRefresh called but not beforeRefresh";
                assert (this.callingThread == Thread.currentThread()) : "beforeRefreshed called by a different thread. current [" + Thread.currentThread().getName() + "], thread that called beforeRefresh [" + this.callingThread.getName() + "]";
                this.callingThread = null;
            }
            this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        }
    }

    private class ReplicationCheckpointUpdater
    implements ReferenceManager.RefreshListener {
        private ReplicationCheckpointUpdater() {
        }

        public void beforeRefresh() throws IOException {
        }

        public void afterRefresh(boolean didRefresh) throws IOException {
            if (didRefresh) {
                IndexShard.this.updateReplicationCheckpoint();
            }
        }
    }

    @PublicApi(since="1.0.0")
    public static final class ShardFailure {
        public final ShardRouting routing;
        public final String reason;
        @Nullable
        public final Exception cause;

        public ShardFailure(ShardRouting routing, String reason, @Nullable Exception cause) {
            this.routing = routing;
            this.reason = reason;
            this.cause = cause;
        }
    }
}

