/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.Nullable;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitAdapter;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.filterrewrite.DateHistogramAggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.MatchAllFilter;

class DateHistogramAggregator
extends BucketsAggregator
implements SizedBucketAggregator,
StarTreePreComputeCollector {
    private static final Logger logger = LogManager.getLogger(DateHistogramAggregator.class);
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;
    private final String starTreeDateDimension;
    private boolean starTreeDateRoundingRequired = true;
    private final FilterRewriteOptimizationContext filterRewriteOptimizationContext;
    private final String fieldName;
    private final boolean fieldIndexSort;
    private int noOpCollectorsUsed;
    private int singleValuedCollectorsUsed;
    private int multiValuedCollectorsUsed;
    private int skipListCollectorsUsed;

    DateHistogramAggregator(String name, AggregatorFactories factories, final Rounding rounding, final Rounding.Prepared preparedRounding, BucketOrder order, boolean keyed, long minDocCount, @Nullable LongBounds extendedBounds, final @Nullable LongBounds hardBounds, final ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = preparedRounding;
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), cardinality);
        DateHistogramAggregatorBridge bridge = new DateHistogramAggregatorBridge(this){
            final /* synthetic */ DateHistogramAggregator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected boolean canOptimize() {
                return this.canOptimize(valuesSourceConfig, rounding);
            }

            @Override
            protected void prepare() throws IOException {
                this.buildRanges(this.this$0.context);
            }

            @Override
            protected Rounding getRounding(long low, long high) {
                return rounding;
            }

            @Override
            protected Rounding.Prepared getRoundingPrepared() {
                return preparedRounding;
            }

            @Override
            protected long[] processHardBounds(long[] bounds) {
                return super.processHardBounds(bounds, hardBounds);
            }

            @Override
            protected Function<Long, Long> bucketOrdProducer() {
                return key -> this.this$0.bucketOrds.add(0L, preparedRounding.round((long)key));
            }
        };
        this.filterRewriteOptimizationContext = new FilterRewriteOptimizationContext(bridge, parent, this.subAggregators.length, this.context);
        this.fieldName = this.valuesSource instanceof ValuesSource.Numeric.FieldData ? ((ValuesSource.Numeric.FieldData)this.valuesSource).getIndexFieldName() : null;
        this.fieldIndexSort = this.fieldName == null ? false : this.context.getQueryShardContext().indexSortedOnField(this.fieldName);
        this.starTreeDateDimension = this.context.getQueryShardContext().getStarTreeQueryContext() != null ? this.fetchStarTreeCalendarUnit() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null) {
            StarTreeBucketCollector starTreeBucketCollector = this.getStarTreeBucketCollector(ctx, supportedStarTree, null);
            StarTreeQueryHelper.preComputeBucketsWithStarTree(starTreeBucketCollector);
            return true;
        }
        return this.filterRewriteOptimizationContext.tryOptimize(ctx, this::incrementBucketDocCount, DateHistogramAggregatorBridge.segmentMatchAll(this.context, ctx), this.collectableSubAggregators);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            ++this.noOpCollectorsUsed;
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        DocValuesSkipper skipper = null;
        if (this.fieldName != null) {
            skipper = ctx.reader().getDocValuesSkipper(this.fieldName);
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (skipper != null && singleton != null && this.hardBounds == null && this.parent == null) {
            ++this.skipListCollectorsUsed;
            return new HistogramSkiplistLeafCollector(singleton, skipper, this.preparedRounding, this.bucketOrds, sub, this);
        }
        if (singleton != null) {
            ++this.singleValuedCollectorsUsed;
            return new LeafBucketCollectorBase(this, sub, values){
                final /* synthetic */ DateHistogramAggregator this$0;
                {
                    this.this$0 = this$0;
                    super(sub2, values);
                }

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (singleton.advanceExact(doc)) {
                        long value = singleton.longValue();
                        this.this$0.collectValue(sub, doc, owningBucketOrd, this.this$0.preparedRounding.round(value));
                    }
                }
            };
        }
        ++this.multiValuedCollectorsUsed;
        return new LeafBucketCollectorBase(this, sub, values){
            final /* synthetic */ DateHistogramAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub2, values2);
            }

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = this.this$0.preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        this.this$0.collectValue(sub, doc, owningBucketOrd, rounded);
                        previousRounded = rounded;
                    }
                }
            }
        };
    }

    private void collectValue(LeafBucketCollector sub, int doc, long owningBucketOrd, long rounded) throws IOException {
        if (this.hardBounds == null || this.hardBounds.contain(rounded)) {
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, rounded);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(sub, doc, bucketOrd);
            } else {
                this.collectBucket(sub, doc, bucketOrd);
            }
        }
    }

    private String fetchStarTreeCalendarUnit() {
        if (this.rounding.unit() == null) {
            return null;
        }
        CompositeDataCubeFieldType compositeMappedFieldType = (CompositeDataCubeFieldType)this.context.mapperService().getCompositeFieldTypes().iterator().next();
        DateDimension starTreeDateDimension = (DateDimension)compositeMappedFieldType.getDimensions().stream().filter(dim -> dim.getField().equals(this.fieldName)).findFirst().orElseThrow(() -> new AssertionError((Object)String.format(Locale.ROOT, "Date dimension '%s' not found", this.fieldName)));
        DateTimeUnitAdapter dateTimeUnitRounding = new DateTimeUnitAdapter(this.rounding.unit());
        DateTimeUnitRounding rounding = starTreeDateDimension.findClosestValidInterval(dateTimeUnitRounding);
        String dimensionName = this.fieldName + "_" + rounding.shortName();
        if (rounding.shortName().equals(this.rounding.unit().shortName())) {
            this.starTreeDateRoundingRequired = false;
        }
        return dimensionName;
    }

    @Override
    public List<DimensionFilter> getDimensionFilters() {
        return StarTreeQueryHelper.collectDimensionFilters(new MatchAllFilter(this.fieldName, this.starTreeDateDimension), this.subAggregators);
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(final LeafReaderContext ctx, final CompositeIndexFieldInfo starTree, StarTreeBucketCollector parentCollector) throws IOException {
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        final SortedNumericStarTreeValuesIterator valuesIterator = (SortedNumericStarTreeValuesIterator)starTreeValues.getDimensionValuesIterator(this.starTreeDateDimension);
        final SortedNumericStarTreeValuesIterator docCountsIterator = StarTreeQueryHelper.getDocCountsIterator(starTreeValues, starTree);
        return new StarTreeBucketCollector(this, starTreeValues, parentCollector == null ? StarTreeQueryHelper.getStarTreeResult(starTreeValues, this.context, this.getDimensionFilters()) : null){
            final /* synthetic */ DateHistogramAggregator this$0;
            {
                this.this$0 = this$0;
                super(starTreeValues, matchingDocsBitSet);
            }

            @Override
            public void setSubCollectors() throws IOException {
                for (Aggregator aggregator : this.this$0.subAggregators) {
                    this.subCollectors.add(((StarTreePreComputeCollector)((Object)aggregator.unwrapAggregator())).getStarTreeBucketCollector(ctx, starTree, this));
                }
            }

            @Override
            public void collectStarTreeEntry(int starTreeEntry, long owningBucketOrd) throws IOException {
                if (!valuesIterator.advanceExact(starTreeEntry)) {
                    return;
                }
                int count = valuesIterator.entryValueCount();
                for (int i = 0; i < count; ++i) {
                    long dimensionValue;
                    long l = dimensionValue = this.this$0.starTreeDateRoundingRequired ? this.this$0.preparedRounding.round(valuesIterator.nextValue()) : valuesIterator.nextValue();
                    if (!docCountsIterator.advanceExact(starTreeEntry)) continue;
                    long metricValue = docCountsIterator.nextValue();
                    long bucketOrd = this.this$0.bucketOrds.add(owningBucketOrd, dimensionValue);
                    this.this$0.collectStarTreeBucket(this, metricValue, bucketOrd, starTreeEntry);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.keyed, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("total_buckets", this.bucketOrds.size());
        this.filterRewriteOptimizationContext.populateDebugInfo(add);
        add.accept("no_op_collectors_used", this.noOpCollectorsUsed);
        add.accept("single_valued_collectors_used", this.singleValuedCollectorsUsed);
        add.accept("multi_valued_collectors_used", this.multiValuedCollectorsUsed);
        add.accept("skip_list_collectors_used", this.skipListCollectorsUsed);
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(this.bucketOrds.get(bucket), unitSize);
        }
        return 1.0;
    }

    private static class HistogramSkiplistLeafCollector
    extends LeafBucketCollector {
        private final NumericDocValues values;
        private final DocValuesSkipper skipper;
        private final Rounding.Prepared preparedRounding;
        private final LongKeyedBucketOrds bucketOrds;
        private final LeafBucketCollector sub;
        private final BucketsAggregator aggregator;
        private int upToInclusive = -1;
        private boolean upToSameBucket;
        private long upToBucketIndex;

        HistogramSkiplistLeafCollector(NumericDocValues values, DocValuesSkipper skipper, Rounding.Prepared preparedRounding, LongKeyedBucketOrds bucketOrds, LeafBucketCollector sub, BucketsAggregator aggregator) {
            this.values = values;
            this.skipper = skipper;
            this.preparedRounding = preparedRounding;
            this.bucketOrds = bucketOrds;
            this.sub = sub;
            this.aggregator = aggregator;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.sub != null) {
                this.sub.setScorer(scorer);
            }
        }

        private void advanceSkipper(int doc, long owningBucketOrd) throws IOException {
            if (doc > this.skipper.maxDocID(0)) {
                this.skipper.advance(doc);
            }
            this.upToSameBucket = false;
            if (this.skipper.minDocID(0) > doc) {
                this.upToInclusive = this.skipper.minDocID(0) - 1;
                return;
            }
            this.upToInclusive = this.skipper.maxDocID(0);
            for (int level = 0; level < this.skipper.numLevels(); ++level) {
                int totalDocsAtLevel = this.skipper.maxDocID(level) - this.skipper.minDocID(level) + 1;
                long minBucket = this.preparedRounding.round(this.skipper.minValue(level));
                long maxBucket = this.preparedRounding.round(this.skipper.maxValue(level));
                if (this.skipper.docCount(level) != totalDocsAtLevel || minBucket != maxBucket) break;
                this.upToInclusive = this.skipper.maxDocID(level);
                this.upToSameBucket = true;
                this.upToBucketIndex = this.bucketOrds.add(owningBucketOrd, maxBucket);
                if (this.upToBucketIndex >= 0L) continue;
                this.upToBucketIndex = -1L - this.upToBucketIndex;
            }
        }

        @Override
        public void collect(int doc, long owningBucketOrd) throws IOException {
            if (doc > this.upToInclusive) {
                this.advanceSkipper(doc, owningBucketOrd);
            }
            if (this.upToSameBucket) {
                this.aggregator.incrementBucketDocCount(this.upToBucketIndex, 1L);
                this.sub.collect(doc, this.upToBucketIndex);
            } else if (this.values.advanceExact(doc)) {
                long value = this.values.longValue();
                long bucketIndex = this.bucketOrds.add(owningBucketOrd, this.preparedRounding.round(value));
                if (bucketIndex < 0L) {
                    bucketIndex = -1L - bucketIndex;
                    this.aggregator.collectExistingBucket(this.sub, doc, bucketIndex);
                } else {
                    this.aggregator.collectBucket(this.sub, doc, bucketIndex);
                }
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            this.collect(doc, 0L);
        }

        public void collect(DocIdStream stream) throws IOException {
            while (true) {
                int upToExclusive;
                if ((upToExclusive = this.upToInclusive + 1) < 0) {
                    upToExclusive = Integer.MAX_VALUE;
                }
                if (this.upToSameBucket) {
                    if (this.sub == NO_OP_COLLECTOR) {
                        long count = stream.count(upToExclusive);
                        this.aggregator.incrementBucketDocCount(this.upToBucketIndex, count);
                    } else {
                        int[] count = new int[]{0};
                        stream.forEach(upToExclusive, doc -> {
                            this.sub.collect(doc, this.upToBucketIndex);
                            count[0] = count[0] + 1;
                        });
                        this.aggregator.incrementBucketDocCount(this.upToBucketIndex, count[0]);
                    }
                } else {
                    stream.forEach(upToExclusive, this::collect);
                }
                if (!stream.mayHaveRemaining()) break;
                this.advanceSkipper(upToExclusive, 0L);
            }
        }
    }
}

