/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.azure.ai.openai.models.ChatCompletionStreamOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.azure.openai.AzureOpenAiResponseFormat;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AzureOpenAiChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="deployment_name")
    private String deploymentName;
    @JsonProperty(value="response_format")
    private AzureOpenAiResponseFormat responseFormat;
    @JsonProperty(value="seed")
    private Long seed;
    @JsonProperty(value="log_probs")
    private Boolean logprobs;
    @JsonProperty(value="top_log_probs")
    private Integer topLogProbs;
    @JsonIgnore
    private AzureChatEnhancementConfiguration enhancements;
    @JsonProperty(value="stream_options")
    private ChatCompletionStreamOptions streamOptions;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private List<FunctionCallback> toolCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;

    @JsonIgnore
    public List<FunctionCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<FunctionCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean isInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AzureOpenAiChatOptions fromOptions(AzureOpenAiChatOptions fromOptions) {
        return AzureOpenAiChatOptions.builder().deploymentName(fromOptions.getDeploymentName()).frequencyPenalty(fromOptions.getFrequencyPenalty() != null ? fromOptions.getFrequencyPenalty() : null).logitBias(fromOptions.getLogitBias()).maxTokens(fromOptions.getMaxTokens()).N(fromOptions.getN()).presencePenalty(fromOptions.getPresencePenalty() != null ? fromOptions.getPresencePenalty() : null).stop(fromOptions.getStop()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).user(fromOptions.getUser()).functionCallbacks(fromOptions.getFunctionCallbacks()).functions(fromOptions.getFunctions()).responseFormat(fromOptions.getResponseFormat()).seed(fromOptions.getSeed()).logprobs(fromOptions.isLogprobs()).topLogprobs(fromOptions.getTopLogProbs()).enhancements(fromOptions.getEnhancements()).toolContext(fromOptions.getToolContext()).internalToolExecutionEnabled(fromOptions.isInternalToolExecutionEnabled()).streamOptions(fromOptions.getStreamOptions()).toolCallbacks(fromOptions.getToolCallbacks()).toolNames(fromOptions.getToolNames()).build();
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonIgnore
    public String getModel() {
        return this.getDeploymentName();
    }

    @JsonIgnore
    public void setModel(String model) {
        this.setDeploymentName(model);
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @Deprecated
    @JsonIgnore
    public List<FunctionCallback> getFunctionCallbacks() {
        return this.getToolCallbacks();
    }

    @Deprecated
    @JsonIgnore
    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.setToolCallbacks(functionCallbacks);
    }

    @Deprecated
    @JsonIgnore
    public Set<String> getFunctions() {
        return this.getToolNames();
    }

    public void setFunctions(Set<String> functions) {
        this.setToolNames(functions);
    }

    public AzureOpenAiResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(AzureOpenAiResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public Boolean isLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogProbs() {
        return this.topLogProbs;
    }

    public void setTopLogProbs(Integer topLogProbs) {
        this.topLogProbs = topLogProbs;
    }

    public AzureChatEnhancementConfiguration getEnhancements() {
        return this.enhancements;
    }

    public void setEnhancements(AzureChatEnhancementConfiguration enhancements) {
        this.enhancements = enhancements;
    }

    @Deprecated
    @JsonIgnore
    public Boolean getProxyToolCalls() {
        return this.internalToolExecutionEnabled != null ? Boolean.valueOf(this.internalToolExecutionEnabled == false) : null;
    }

    @Deprecated
    @JsonIgnore
    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.internalToolExecutionEnabled = proxyToolCalls != null ? Boolean.valueOf(proxyToolCalls == false) : null;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public ChatCompletionStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(ChatCompletionStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public AzureOpenAiChatOptions copy() {
        return AzureOpenAiChatOptions.fromOptions(this);
    }

    public static class Builder {
        protected AzureOpenAiChatOptions options;

        public Builder() {
            this.options = new AzureOpenAiChatOptions();
        }

        public Builder(AzureOpenAiChatOptions options) {
            this.options = options;
        }

        public Builder deploymentName(String deploymentName) {
            this.options.deploymentName = deploymentName;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder N(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder user(String user) {
            this.options.user = user;
            return this;
        }

        @Deprecated
        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.toolCallbacks(functionCallbacks);
        }

        @Deprecated
        public Builder functions(Set<String> functionNames) {
            return this.toolNames(functionNames);
        }

        @Deprecated
        public Builder function(String functionName) {
            return this.toolNames(functionName);
        }

        public Builder responseFormat(AzureOpenAiResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        @Deprecated
        public Builder proxyToolCalls(Boolean proxyToolCalls) {
            if (proxyToolCalls != null) {
                this.options.setInternalToolExecutionEnabled(proxyToolCalls == false);
            }
            return this;
        }

        public Builder seed(Long seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.topLogProbs = topLogprobs;
            return this;
        }

        public Builder enhancements(AzureChatEnhancementConfiguration enhancements) {
            this.options.enhancements = enhancements;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder streamOptions(ChatCompletionStreamOptions streamOptions) {
            this.options.streamOptions = streamOptions;
            return this;
        }

        public Builder toolCallbacks(List<FunctionCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(FunctionCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public AzureOpenAiChatOptions build() {
            return this.options;
        }
    }
}

