/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.qdrant;

import io.micrometer.observation.ObservationRegistry;
import io.qdrant.client.QdrantClient;
import io.qdrant.client.QdrantGrpcClient;
import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.ai.vectorstore.qdrant.QdrantVectorStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={QdrantVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={QdrantVectorStoreProperties.class})
public class QdrantVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={QdrantConnectionDetails.class})
    PropertiesQdrantConnectionDetails qdrantConnectionDetails(QdrantVectorStoreProperties properties) {
        return new PropertiesQdrantConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public QdrantClient qdrantClient(QdrantVectorStoreProperties properties, QdrantConnectionDetails connectionDetails) {
        QdrantGrpcClient.Builder grpcClientBuilder = QdrantGrpcClient.newBuilder((String)connectionDetails.getHost(), (int)connectionDetails.getPort(), (boolean)properties.isUseTls());
        if (connectionDetails.getApiKey() != null) {
            grpcClientBuilder.withApiKey(connectionDetails.getApiKey());
        }
        return new QdrantClient(grpcClientBuilder.build());
    }

    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public QdrantVectorStore vectorStore(EmbeddingModel embeddingModel, QdrantVectorStoreProperties properties, QdrantClient qdrantClient, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        return ((QdrantVectorStore.Builder)((QdrantVectorStore.Builder)QdrantVectorStore.builder((QdrantClient)qdrantClient, (EmbeddingModel)embeddingModel).collectionName(properties.getCollectionName()).initializeSchema(properties.isInitializeSchema()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy).build();
    }

    static class PropertiesQdrantConnectionDetails
    implements QdrantConnectionDetails {
        private final QdrantVectorStoreProperties properties;

        PropertiesQdrantConnectionDetails(QdrantVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }

        @Override
        public int getPort() {
            return this.properties.getPort();
        }

        @Override
        public String getApiKey() {
            return this.properties.getApiKey();
        }
    }
}

