/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

public abstract class AbstractFunctionRegistry
implements FunctionRegistry {
    @Autowired
    private Environment environment = new StandardEnvironment();

    @Override
    public <T> T lookup(Class<?> type, String name) {
        String functionDefinitionName = !StringUtils.hasText((String)name) && this.environment.containsProperty("spring.cloud.function.definition") ? this.environment.getProperty("spring.cloud.function.definition") : name;
        return this.doLookup(type, functionDefinitionName);
    }

    protected abstract <T> T doLookup(Class<?> var1, String var2);
}

