/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.admin;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BindingCleaner;
import org.springframework.cloud.stream.binder.rabbit.admin.RabbitAdminException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriUtils;

public class RabbitBindingCleaner
implements BindingCleaner {
    private static final Log logger = LogFactory.getLog(RabbitBindingCleaner.class);
    private static final String PREFIX_DELIMITER = ".";
    public static final String BINDER_PREFIX = "binder.";

    public Map<String, List<String>> clean(String entity, boolean isJob) {
        return this.clean("http://localhost:15672/api", "guest", "guest", "/", BINDER_PREFIX, entity, isJob);
    }

    public Map<String, List<String>> clean(String adminUri, String user, String pw, String vhost, String binderPrefix, String entity, boolean isJob) {
        try {
            WebClient client = WebClient.builder().filter(ExchangeFilterFunctions.basicAuthentication((String)user, (String)pw)).build();
            URI uri = new URI(adminUri);
            return this.doClean(client, uri, vhost == null ? "/" : vhost, binderPrefix == null ? BINDER_PREFIX : binderPrefix, entity, isJob);
        }
        catch (URISyntaxException e) {
            throw new RabbitAdminException("Couldn't create a Client", e);
        }
    }

    private Map<String, List<String>> doClean(WebClient client, URI uri, String vhost, String binderPrefix, String entity, boolean isJob) {
        LinkedList<String> removedQueues = isJob ? null : this.findStreamQueues(client, uri, vhost, binderPrefix, entity);
        List<String> removedExchanges = this.findExchanges(client, uri, vhost, binderPrefix, entity);
        if (removedQueues != null) {
            removedQueues.descendingIterator().forEachRemaining(q -> {
                this.deleteQueue(client, uri, vhost, (String)q);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("deleted queue: " + q));
                }
            });
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        if (removedQueues.size() > 0) {
            results.put("queues", removedQueues);
        }
        removedExchanges.forEach(exchange -> {
            this.deleteExchange(client, uri, vhost, (String)exchange);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deleted exchange: " + exchange));
            }
        });
        if (removedExchanges.size() > 0) {
            results.put("exchanges", removedExchanges);
        }
        return results;
    }

    private void deleteQueue(WebClient client, URI uri, String vhost, String q) {
        URI deleteURI = uri.resolve("/api/queues/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + q);
        client.delete().uri(deleteURI).retrieve().toEntity(Void.class).block(Duration.ofSeconds(10L));
    }

    private void deleteExchange(WebClient client, URI uri, String vhost, String ex) {
        URI deleteURI = uri.resolve("/api/exchanges/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + ex);
        client.delete().uri(deleteURI).retrieve().toEntity(Void.class).block(Duration.ofSeconds(10L));
    }

    private LinkedList<String> findStreamQueues(WebClient client, URI uri, String vhost, String binderPrefix, String stream) {
        String queueNamePrefix = this.adjustPrefix(AbstractBinder.applyPrefix((String)binderPrefix, (String)stream));
        List<Map<String, Object>> queues = this.getQueues(client, uri, vhost);
        return queues.stream().filter(q -> ((String)q.get("name")).startsWith(queueNamePrefix)).map(q -> this.checkNoConsumers((Map<String, Object>)q)).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<Map<String, Object>> getQueues(WebClient client, URI uri, String vhost) {
        URI getUri = uri.resolve("/api/queues/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/");
        return (List)client.get().uri(getUri).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<List<Map<String, Object>>>(){}).block(Duration.ofSeconds(10L));
    }

    private String adjustPrefix(String prefix) {
        if (prefix.endsWith("*")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix + PREFIX_DELIMITER;
    }

    private String checkNoConsumers(Map<String, Object> queue) {
        if ((Integer)queue.get("consumers") != 0) {
            throw new RabbitAdminException("Queue " + queue.get("name") + " is in use");
        }
        return (String)queue.get("name");
    }

    private List<String> findExchanges(WebClient client, URI uri, String vhost, String binderPrefix, String entity) {
        List<Map<String, Object>> exchanges = this.getExchanges(client, uri, vhost);
        String exchangeNamePrefix = this.adjustPrefix(AbstractBinder.applyPrefix((String)binderPrefix, (String)entity));
        List<String> exchangesToRemove = exchanges.stream().filter(e -> ((String)e.get("name")).startsWith(exchangeNamePrefix)).map(e -> {
            List<Map<String, Object>> bindingsBySource = this.getBindingsBySource(client, uri, vhost, (String)e.get("name"));
            return Collections.singletonMap((String)e.get("name"), bindingsBySource);
        }).map(bindingsMap -> this.hasNoForeignBindings((Map<String, List<Map<String, Object>>>)bindingsMap, exchangeNamePrefix)).collect(Collectors.toList());
        exchangesToRemove.stream().map(exchange -> this.getExchangeBindingsByDestination(client, uri, vhost, (String)exchange)).forEach(bindings -> {
            if (bindings.size() > 0) {
                throw new RabbitAdminException("Cannot delete exchange " + ((Map)bindings.get(0)).get("destination") + "; it is a destination: " + bindings);
            }
        });
        return exchangesToRemove;
    }

    private List<Map<String, Object>> getExchangeBindingsByDestination(WebClient client, URI uri, String vhost, String name) {
        String exchange = "".equals(name) ? "amq.default" : name;
        URI getUri = uri.resolve("/api/exchanges/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + UriUtils.encodePathSegment((String)exchange, (Charset)StandardCharsets.UTF_8) + "/bindings/destination");
        return (List)client.get().uri(getUri).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<List<Map<String, Object>>>(){}).block(Duration.ofSeconds(10L));
    }

    private List<Map<String, Object>> getBindingsBySource(WebClient client, URI uri, String vhost, String name) {
        String exchange = "".equals(name) ? "amq.default" : name;
        URI getUri = uri.resolve("/api/exchanges/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + UriUtils.encodePathSegment((String)exchange, (Charset)StandardCharsets.UTF_8) + "/bindings/source");
        return (List)client.get().uri(getUri).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<List<Map<String, Object>>>(){}).block(Duration.ofSeconds(10L));
    }

    private List<Map<String, Object>> getExchanges(WebClient client, URI uri, String vhost) {
        URI getUri = uri.resolve("/api/exchanges/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/");
        return (List)client.get().uri(getUri).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<List<Map<String, Object>>>(){}).block(Duration.ofSeconds(10L));
    }

    private String hasNoForeignBindings(Map<String, List<Map<String, Object>>> bindings, String exchangeNamePrefix) {
        Map.Entry<String, List<Map<String, Object>>> next = bindings.entrySet().iterator().next();
        for (Map<String, Object> binding : next.getValue()) {
            if ("queue".equals(binding.get("destination_type")) && ((String)binding.get("destination")).startsWith(exchangeNamePrefix)) continue;
            throw new RabbitAdminException("Cannot delete exchange " + next.getKey() + "; it has bindings: " + bindings);
        }
        return next.getKey();
    }
}

