/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.properties;

import jakarta.validation.constraints.Min;
import java.util.Optional;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RabbitProducerProperties
extends RabbitCommonProperties {
    private boolean compress;
    private boolean batchingEnabled;
    private int batchSize = 100;
    private int batchBufferLimit = 10000;
    private int batchTimeout = 5000;
    private String batchingStrategyBeanName;
    private boolean transacted;
    private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;
    private String[] headerPatterns = new String[]{"*"};
    private Expression delayExpression;
    private String routingKey;
    private Expression routingKeyExpression;
    private String confirmAckChannel;
    private boolean useConfirmHeader;
    private ProducerType producerType = ProducerType.AMQP;
    private String streamMessageConverterBeanName;
    private AlternateExchange alternateExchange;
    private boolean superStream;

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setDeliveryMode(MessageDeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public String[] getHeaderPatterns() {
        return this.headerPatterns;
    }

    public void setHeaderPatterns(String[] replyHeaderPatterns) {
        this.headerPatterns = replyHeaderPatterns;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    @Min(value=1L, message="Batch Size should be greater than zero.")
    public @Min(value=1L, message="Batch Size should be greater than zero.") int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Min(value=1L, message="Batch Buffer Limit should be greater than zero.")
    public @Min(value=1L, message="Batch Buffer Limit should be greater than zero.") int getBatchBufferLimit() {
        return this.batchBufferLimit;
    }

    public void setBatchBufferLimit(int batchBufferLimit) {
        this.batchBufferLimit = batchBufferLimit;
    }

    @Min(value=1L, message="Batch Timeout should be greater than zero.")
    public @Min(value=1L, message="Batch Timeout should be greater than zero.") int getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(int batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public Expression getDelayExpression() {
        return this.delayExpression;
    }

    public void setDelayExpression(Expression delayExpression) {
        this.delayExpression = delayExpression;
    }

    public Expression getRoutingKeyExpression() {
        return Optional.ofNullable(this.routingKeyExpression).orElseGet(() -> Optional.ofNullable(this.routingKey).map(LiteralExpression::new).orElse(null));
    }

    public void setRoutingKeyExpression(Expression routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public String getConfirmAckChannel() {
        return this.confirmAckChannel;
    }

    public void setConfirmAckChannel(String confirmAckChannel) {
        this.confirmAckChannel = confirmAckChannel;
    }

    public String getBatchingStrategyBeanName() {
        return this.batchingStrategyBeanName;
    }

    public void setBatchingStrategyBeanName(String batchingStrategyBeanName) {
        this.batchingStrategyBeanName = batchingStrategyBeanName;
    }

    public boolean isUseConfirmHeader() {
        return this.useConfirmHeader;
    }

    public void setUseConfirmHeader(boolean useConfirmHeader) {
        this.useConfirmHeader = useConfirmHeader;
    }

    public ProducerType getProducerType() {
        return this.producerType;
    }

    public void setProducerType(ProducerType producerType) {
        Assert.notNull((Object)((Object)producerType), (String)"'producerType' cannot be null");
        this.producerType = producerType;
    }

    public String getStreamMessageConverterBeanName() {
        return this.streamMessageConverterBeanName;
    }

    public void setStreamMessageConverterBeanName(String streamMessageConverterBeanName) {
        this.streamMessageConverterBeanName = streamMessageConverterBeanName;
    }

    @Nullable
    public AlternateExchange getAlternateExchange() {
        return this.alternateExchange;
    }

    public void setAlternateExchange(AlternateExchange alternate) {
        this.alternateExchange = alternate;
    }

    public boolean isSuperStream() {
        return this.superStream;
    }

    public void setSuperStream(boolean superStream) {
        this.superStream = superStream;
    }

    public static enum ProducerType {
        STREAM_SYNC,
        STREAM_ASYNC,
        AMQP;

    }

    public static class AlternateExchange {
        private String name;
        private boolean exists = false;
        private String type = "topic";
        private Binding binding;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isExists() {
            return this.exists;
        }

        public void setExists(boolean exists) {
            this.exists = exists;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public void setBinding(Binding binding) {
            this.binding = binding;
        }

        public static class Binding {
            private String routingKey = "#";
            private String queue;

            public String getRoutingKey() {
                return this.routingKey;
            }

            public void setRoutingKey(String routingKey) {
                this.routingKey = routingKey;
            }

            public String getQueue() {
                return this.queue;
            }

            public void setQueue(String queue) {
                this.queue = queue;
            }
        }
    }
}

