/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.graph;

import java.util.function.Supplier;
import org.springframework.integration.graph.IntegrationNode;
import org.springframework.integration.graph.SendTimers;
import org.springframework.integration.graph.SendTimersAware;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.Statistics;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;

public class MessageChannelNode
extends IntegrationNode
implements SendTimersAware {
    private Supplier<SendTimers> sendTimers;

    public MessageChannelNode(int nodeId, String name, MessageChannel channel) {
        super(nodeId, name, channel, channel instanceof MessageChannelMetrics ? new Stats((MessageChannelMetrics)channel) : new IntegrationNode.Stats());
    }

    @Nullable
    public SendTimers getSendTimers() {
        return this.sendTimers != null ? this.sendTimers.get() : null;
    }

    @Override
    public void sendTimers(Supplier<SendTimers> timers) {
        this.sendTimers = timers;
    }

    public static final class Stats
    extends IntegrationNode.Stats {
        private final MessageChannelMetrics channel;

        Stats(MessageChannelMetrics channel) {
            this.channel = channel;
        }

        @Override
        protected boolean isAvailable() {
            return this.channel.isCountsEnabled();
        }

        public boolean isCountsEnabled() {
            return this.channel.isCountsEnabled();
        }

        public boolean isLoggingEnabled() {
            return this.channel.isLoggingEnabled();
        }

        public long getSendCount() {
            return this.channel.getSendCountLong();
        }

        public long getSendErrorCount() {
            return this.channel.getSendErrorCountLong();
        }

        public double getTimeSinceLastSend() {
            return this.channel.getTimeSinceLastSend();
        }

        public double getMeanSendRate() {
            return this.channel.getMeanSendRate();
        }

        public double getMeanErrorRate() {
            return this.channel.getMeanErrorRate();
        }

        public double getMeanErrorRatio() {
            return this.channel.getMeanErrorRatio();
        }

        public double getMeanSendDuration() {
            return this.channel.getMeanSendDuration();
        }

        public double getMinSendDuration() {
            return this.channel.getMinSendDuration();
        }

        public double getMaxSendDuration() {
            return this.channel.getMaxSendDuration();
        }

        public double getStandardDeviationSendDuration() {
            return this.channel.getStandardDeviationSendDuration();
        }

        public Statistics getSendDuration() {
            return this.channel.getSendDuration();
        }

        public Statistics getSendRate() {
            return this.channel.getSendRate();
        }

        public Statistics getErrorRate() {
            return this.channel.getErrorRate();
        }

        public boolean isStatsEnabled() {
            return this.channel.isStatsEnabled();
        }
    }
}

