/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.support.management.metrics.MetricsCaptor;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;

public interface IntegrationManagement
extends DisposableBean {
    public static final String METER_PREFIX = "spring.integration.";
    public static final String SEND_TIMER_NAME = "spring.integration.send";
    public static final String RECEIVE_COUNTER_NAME = "spring.integration.receive";

    @ManagedAttribute(description="Use to disable debug logging during normal message flow")
    public void setLoggingEnabled(boolean var1);

    @ManagedAttribute
    public boolean isLoggingEnabled();

    @Deprecated
    @ManagedOperation
    public void reset();

    @Deprecated
    @ManagedAttribute(description="Enable message counting statistics")
    public void setCountsEnabled(boolean var1);

    @Deprecated
    @ManagedAttribute
    public boolean isCountsEnabled();

    public ManagementOverrides getOverrides();

    default public void registerMetricsCaptor(MetricsCaptor captor) {
    }

    default public void destroy() {
    }

    public static class ManagementOverrides {
        public boolean loggingConfigured;
        public boolean countsConfigured;
        public boolean statsConfigured;
        public boolean metricsConfigured;
    }
}

