/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcLogoutEndpointFilter;
import org.springframework.security.oauth2.server.authorization.oidc.web.authentication.OidcLogoutAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OidcLogoutEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private final List<AuthenticationConverter> logoutRequestConverters = new ArrayList<AuthenticationConverter>();
    private Consumer<List<AuthenticationConverter>> logoutRequestConvertersConsumer = logoutRequestConverters -> {};
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
    private Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders -> {};
    private AuthenticationSuccessHandler logoutResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;

    OidcLogoutEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OidcLogoutEndpointConfigurer logoutRequestConverter(AuthenticationConverter logoutRequestConverter) {
        Assert.notNull((Object)logoutRequestConverter, (String)"logoutRequestConverter cannot be null");
        this.logoutRequestConverters.add(logoutRequestConverter);
        return this;
    }

    public OidcLogoutEndpointConfigurer logoutRequestConverters(Consumer<List<AuthenticationConverter>> logoutRequestConvertersConsumer) {
        Assert.notNull(logoutRequestConvertersConsumer, (String)"logoutRequestConvertersConsumer cannot be null");
        this.logoutRequestConvertersConsumer = logoutRequestConvertersConsumer;
        return this;
    }

    public OidcLogoutEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OidcLogoutEndpointConfigurer authenticationProviders(Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer) {
        Assert.notNull(authenticationProvidersConsumer, (String)"authenticationProvidersConsumer cannot be null");
        this.authenticationProvidersConsumer = authenticationProvidersConsumer;
        return this;
    }

    public OidcLogoutEndpointConfigurer logoutResponseHandler(AuthenticationSuccessHandler logoutResponseHandler) {
        this.logoutResponseHandler = logoutResponseHandler;
        return this;
    }

    public OidcLogoutEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        String logoutEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getOidcLogoutEndpoint()) : authorizationServerSettings.getOidcLogoutEndpoint();
        this.requestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(logoutEndpointUri, HttpMethod.GET.name()), new AntPathRequestMatcher(logoutEndpointUri, HttpMethod.POST.name())});
        List<AuthenticationProvider> authenticationProviders = OidcLogoutEndpointConfigurer.createDefaultAuthenticationProviders(httpSecurity);
        if (!this.authenticationProviders.isEmpty()) {
            authenticationProviders.addAll(0, this.authenticationProviders);
        }
        this.authenticationProvidersConsumer.accept(authenticationProviders);
        authenticationProviders.forEach(authenticationProvider -> httpSecurity.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        AuthenticationManager authenticationManager = (AuthenticationManager)httpSecurity.getSharedObject(AuthenticationManager.class);
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        String logoutEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getOidcLogoutEndpoint()) : authorizationServerSettings.getOidcLogoutEndpoint();
        OidcLogoutEndpointFilter oidcLogoutEndpointFilter = new OidcLogoutEndpointFilter(authenticationManager, logoutEndpointUri);
        List<AuthenticationConverter> authenticationConverters = OidcLogoutEndpointConfigurer.createDefaultAuthenticationConverters();
        if (!this.logoutRequestConverters.isEmpty()) {
            authenticationConverters.addAll(0, this.logoutRequestConverters);
        }
        this.logoutRequestConvertersConsumer.accept(authenticationConverters);
        oidcLogoutEndpointFilter.setAuthenticationConverter((AuthenticationConverter)new DelegatingAuthenticationConverter(authenticationConverters));
        if (this.logoutResponseHandler != null) {
            oidcLogoutEndpointFilter.setAuthenticationSuccessHandler(this.logoutResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            oidcLogoutEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        httpSecurity.addFilterBefore((Filter)this.postProcess(oidcLogoutEndpointFilter), LogoutFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private static List<AuthenticationConverter> createDefaultAuthenticationConverters() {
        ArrayList<AuthenticationConverter> authenticationConverters = new ArrayList<AuthenticationConverter>();
        authenticationConverters.add(new OidcLogoutAuthenticationConverter());
        return authenticationConverters;
    }

    private static List<AuthenticationProvider> createDefaultAuthenticationProviders(HttpSecurity httpSecurity) {
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OidcLogoutAuthenticationProvider oidcLogoutAuthenticationProvider = new OidcLogoutAuthenticationProvider(OAuth2ConfigurerUtils.getRegisteredClientRepository(httpSecurity), OAuth2ConfigurerUtils.getAuthorizationService(httpSecurity), (SessionRegistry)httpSecurity.getSharedObject(SessionRegistry.class));
        authenticationProviders.add(oidcLogoutAuthenticationProvider);
        return authenticationProviders;
    }
}

