/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.net.URL;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.util.Assert;

public interface ClaimAccessor {
    public Map<String, Object> getClaims();

    default public <T> T getClaim(String claim) {
        return (T)(!this.hasClaim(claim) ? null : this.getClaims().get(claim));
    }

    default public boolean hasClaim(String claim) {
        Assert.notNull((Object)claim, (String)"claim cannot be null");
        return this.getClaims().containsKey(claim);
    }

    default public String getClaimAsString(String claim) {
        return !this.hasClaim(claim) ? null : (String)ClaimConversionService.getSharedInstance().convert(this.getClaims().get(claim), String.class);
    }

    default public Boolean getClaimAsBoolean(String claim) {
        if (!this.hasClaim(claim)) {
            return null;
        }
        Object claimValue = this.getClaims().get(claim);
        Boolean convertedValue = (Boolean)ClaimConversionService.getSharedInstance().convert(claimValue, Boolean.class);
        Assert.notNull((Object)convertedValue, () -> "Unable to convert claim '" + claim + "' of type '" + claimValue.getClass() + "' to Boolean.");
        return convertedValue;
    }

    default public Instant getClaimAsInstant(String claim) {
        if (!this.hasClaim(claim)) {
            return null;
        }
        Object claimValue = this.getClaims().get(claim);
        Instant convertedValue = (Instant)ClaimConversionService.getSharedInstance().convert(claimValue, Instant.class);
        Assert.notNull((Object)convertedValue, () -> "Unable to convert claim '" + claim + "' of type '" + claimValue.getClass() + "' to Instant.");
        return convertedValue;
    }

    default public URL getClaimAsURL(String claim) {
        if (!this.hasClaim(claim)) {
            return null;
        }
        Object claimValue = this.getClaims().get(claim);
        URL convertedValue = (URL)ClaimConversionService.getSharedInstance().convert(claimValue, URL.class);
        Assert.notNull((Object)convertedValue, () -> "Unable to convert claim '" + claim + "' of type '" + claimValue.getClass() + "' to URL.");
        return convertedValue;
    }

    default public Map<String, Object> getClaimAsMap(String claim) {
        if (!this.hasClaim(claim)) {
            return null;
        }
        TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(Object.class);
        TypeDescriptor targetDescriptor = TypeDescriptor.map(Map.class, (TypeDescriptor)TypeDescriptor.valueOf(String.class), (TypeDescriptor)TypeDescriptor.valueOf(Object.class));
        Object claimValue = this.getClaims().get(claim);
        Map convertedValue = (Map)ClaimConversionService.getSharedInstance().convert(claimValue, sourceDescriptor, targetDescriptor);
        Assert.notNull((Object)convertedValue, () -> "Unable to convert claim '" + claim + "' of type '" + claimValue.getClass() + "' to Map.");
        return convertedValue;
    }

    default public List<String> getClaimAsStringList(String claim) {
        if (!this.hasClaim(claim)) {
            return null;
        }
        TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(Object.class);
        TypeDescriptor targetDescriptor = TypeDescriptor.collection(List.class, (TypeDescriptor)TypeDescriptor.valueOf(String.class));
        Object claimValue = this.getClaims().get(claim);
        List convertedValue = (List)ClaimConversionService.getSharedInstance().convert(claimValue, sourceDescriptor, targetDescriptor);
        Assert.notNull((Object)convertedValue, () -> "Unable to convert claim '" + claim + "' of type '" + claimValue.getClass() + "' to List.");
        return convertedValue;
    }
}

