/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.springett.parsers.cpe.ICpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.util.Relation;
import us.springett.parsers.cpe.util.Status;
import us.springett.parsers.cpe.util.Validate;
import us.springett.parsers.cpe.values.LogicalValue;
import us.springett.parsers.cpe.values.Part;

public class Cpe
implements ICpe,
Serializable {
    private static final long serialVersionUID = 545319492322631053L;
    private final Part part;
    private final String vendor;
    private final String product;
    private final String version;
    private final String update;
    private final String edition;
    private final String language;
    private final String swEdition;
    private final String targetSw;
    private final String targetHw;
    private final String other;

    public Cpe(Part part, String vendor, String product, String version, String update, String edition, String language, String swEdition, String targetSw, String targetHw, String other) throws CpeValidationException {
        this.validate(vendor, product, version, update, edition, language, swEdition, targetSw, targetHw, other);
        this.part = part;
        this.vendor = vendor;
        this.product = product;
        this.version = version;
        this.update = update;
        this.edition = edition;
        this.language = language;
        this.swEdition = swEdition;
        this.targetSw = targetSw;
        this.targetHw = targetHw;
        this.other = other;
    }

    private void validate(String vendor1, String product1, String version1, String update1, String edition1, String language1, String swEdition1, String targetSw1, String targetHw1, String other1) throws CpeValidationException {
        Status status = Validate.component(vendor1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid vendor component: " + status.getMessage());
        }
        status = Validate.component(product1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid product component: " + status.getMessage());
        }
        status = Validate.component(version1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid version component: " + status.getMessage());
        }
        status = Validate.component(update1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid update component: " + status.getMessage());
        }
        status = Validate.component(edition1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid edition component: " + status.getMessage());
        }
        status = Validate.component(language1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid language component: " + status.getMessage());
        }
        status = Validate.component(swEdition1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid swEdition component: " + status.getMessage());
        }
        status = Validate.component(targetSw1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid targetSw component: " + status.getMessage());
        }
        status = Validate.component(targetHw1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid targetHw component: " + status.getMessage());
        }
        status = Validate.component(other1);
        if (!status.isValid()) {
            throw new CpeValidationException("Invalid other component: " + status.getMessage());
        }
    }

    @Override
    public Part getPart() {
        return this.part;
    }

    @Override
    public String getVendor() {
        return Convert.fromWellFormed(this.vendor);
    }

    @Override
    public String getProduct() {
        return Convert.fromWellFormed(this.product);
    }

    @Override
    public String getVersion() {
        return Convert.fromWellFormed(this.version);
    }

    @Override
    public String getUpdate() {
        return Convert.fromWellFormed(this.update);
    }

    @Override
    public String getEdition() {
        return Convert.fromWellFormed(this.edition);
    }

    @Override
    public String getLanguage() {
        return Convert.fromWellFormed(this.language);
    }

    @Override
    public String getSwEdition() {
        return Convert.fromWellFormed(this.swEdition);
    }

    @Override
    public String getTargetSw() {
        return Convert.fromWellFormed(this.targetSw);
    }

    @Override
    public String getTargetHw() {
        return Convert.fromWellFormed(this.targetHw);
    }

    @Override
    public String getOther() {
        return Convert.fromWellFormed(this.other);
    }

    @Override
    public String getWellFormedVendor() {
        return this.vendor;
    }

    @Override
    public String getWellFormedProduct() {
        return this.product;
    }

    @Override
    public String getWellFormedVersion() {
        return this.version;
    }

    @Override
    public String getWellFormedUpdate() {
        return this.update;
    }

    @Override
    public String getWellFormedEdition() {
        return this.edition;
    }

    @Override
    public String getWellFormedLanguage() {
        return this.language;
    }

    @Override
    public String getWellFormedSwEdition() {
        return this.swEdition;
    }

    @Override
    public String getWellFormedTargetSw() {
        return this.targetSw;
    }

    @Override
    public String getWellFormedTargetHw() {
        return this.targetHw;
    }

    @Override
    public String getWellFormedOther() {
        return this.other;
    }

    @Override
    public String toCpe22Uri() throws CpeEncodingException {
        StringBuilder sb = new StringBuilder("cpe:/");
        sb.append(Convert.wellFormedToCpeUri(this.part)).append(":");
        sb.append(Convert.wellFormedToCpeUri(this.vendor)).append(":");
        sb.append(Convert.wellFormedToCpeUri(this.product)).append(":");
        sb.append(Convert.wellFormedToCpeUri(this.version)).append(":");
        sb.append(Convert.wellFormedToCpeUri(this.update)).append(":");
        if (!this.swEdition.isEmpty() && !"*".equals(this.swEdition) || !this.targetSw.isEmpty() && !"*".equals(this.targetSw) || !this.targetHw.isEmpty() && !"*".equals(this.targetHw) || !this.other.isEmpty() && !"*".equals(this.other)) {
            sb.append("~").append(Convert.wellFormedToCpeUri(this.edition)).append("~").append(Convert.wellFormedToCpeUri(this.swEdition)).append("~").append(Convert.wellFormedToCpeUri(this.targetSw)).append("~").append(Convert.wellFormedToCpeUri(this.targetHw)).append("~").append(Convert.wellFormedToCpeUri(this.other)).append(":");
        } else {
            sb.append(Convert.wellFormedToCpeUri(this.edition)).append(":");
        }
        sb.append(Convert.wellFormedToCpeUri(this.language));
        return sb.toString().replaceAll("[:]*$", "");
    }

    @Override
    public String toCpe23FS() {
        return String.format("cpe:2.3:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s", Convert.wellFormedToFS(this.part), Convert.wellFormedToFS(this.vendor), Convert.wellFormedToFS(this.product), Convert.wellFormedToFS(this.version), Convert.wellFormedToFS(this.update), Convert.wellFormedToFS(this.edition), Convert.wellFormedToFS(this.language), Convert.wellFormedToFS(this.swEdition), Convert.wellFormedToFS(this.targetSw), Convert.wellFormedToFS(this.targetHw), Convert.wellFormedToFS(this.other));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.part);
        hash = 97 * hash + Objects.hashCode(this.vendor);
        hash = 97 * hash + Objects.hashCode(this.product);
        hash = 97 * hash + Objects.hashCode(this.version);
        hash = 97 * hash + Objects.hashCode(this.update);
        hash = 97 * hash + Objects.hashCode(this.edition);
        hash = 97 * hash + Objects.hashCode(this.language);
        hash = 97 * hash + Objects.hashCode(this.swEdition);
        hash = 97 * hash + Objects.hashCode(this.targetSw);
        hash = 97 * hash + Objects.hashCode(this.targetHw);
        hash = 97 * hash + Objects.hashCode(this.other);
        return hash;
    }

    @Override
    public boolean matches(ICpe target) {
        boolean result = true;
        result &= Cpe.compareAttributes(this.part, target.getPart());
        result &= Cpe.compareAttributes(this.vendor, target.getWellFormedVendor());
        result &= Cpe.compareAttributes(this.product, target.getWellFormedProduct());
        result &= Cpe.compareAttributes(this.version, target.getWellFormedVersion());
        result &= Cpe.compareAttributes(this.update, target.getWellFormedUpdate());
        result &= Cpe.compareAttributes(this.edition, target.getWellFormedEdition());
        result &= Cpe.compareAttributes(this.language, target.getWellFormedLanguage());
        result &= Cpe.compareAttributes(this.swEdition, target.getWellFormedSwEdition());
        result &= Cpe.compareAttributes(this.targetSw, target.getWellFormedTargetSw());
        result &= Cpe.compareAttributes(this.targetHw, target.getWellFormedTargetHw());
        return result &= Cpe.compareAttributes(this.other, target.getWellFormedOther());
    }

    @Override
    public boolean matchedBy(ICpe target) {
        return target.matches(this);
    }

    protected static boolean compareAttributes(Part left, Part right) {
        return Cpe.compareAttribute(left, right) != Relation.DISJOINT;
    }

    public static Relation compareAttribute(Part left, Part right) {
        if (left == right) {
            return Relation.EQUAL;
        }
        if (left == Part.ANY) {
            return Relation.SUPERSET;
        }
        if (right == Part.ANY) {
            return Relation.SUBSET;
        }
        return Relation.DISJOINT;
    }

    protected static boolean compareAttributes(String left, String right) {
        return Cpe.compareAttribute(left, right) != Relation.DISJOINT;
    }

    public static Relation compareAttribute(String left, String right) {
        if (left.equalsIgnoreCase(right)) {
            return Relation.EQUAL;
        }
        if (LogicalValue.ANY.getAbbreviation().equals(left)) {
            return Relation.SUPERSET;
        }
        if (LogicalValue.NA.getAbbreviation().equals(left) && LogicalValue.ANY.getAbbreviation().equals(right)) {
            return Relation.SUBSET;
        }
        if (LogicalValue.NA.getAbbreviation().equals(left)) {
            return Relation.DISJOINT;
        }
        if (LogicalValue.NA.getAbbreviation().equals(right)) {
            return Relation.DISJOINT;
        }
        if (LogicalValue.ANY.getAbbreviation().equals(right)) {
            return Relation.SUBSET;
        }
        if (Cpe.containsSpecialCharacter(left)) {
            Pattern p = Convert.wellFormedToPattern(left.toLowerCase());
            Matcher m = p.matcher(right.toLowerCase());
            return m.matches() ? Relation.SUPERSET : Relation.DISJOINT;
        }
        return Relation.DISJOINT;
    }

    private static boolean containsSpecialCharacter(String value) {
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '?' || c == '*') {
                return true;
            }
            if (c != '\\') continue;
            ++x;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cpe compareTo = (Cpe)obj;
        if (!Objects.equals(this.vendor, compareTo.vendor)) {
            return false;
        }
        if (!Objects.equals(this.product, compareTo.product)) {
            return false;
        }
        if (!Objects.equals(this.version, compareTo.version)) {
            return false;
        }
        if (!Objects.equals(this.update, compareTo.update)) {
            return false;
        }
        if (!Objects.equals(this.edition, compareTo.edition)) {
            return false;
        }
        if (!Objects.equals(this.language, compareTo.language)) {
            return false;
        }
        if (!Objects.equals(this.swEdition, compareTo.swEdition)) {
            return false;
        }
        if (!Objects.equals(this.targetSw, compareTo.targetSw)) {
            return false;
        }
        if (!Objects.equals(this.targetHw, compareTo.targetHw)) {
            return false;
        }
        if (!Objects.equals(this.other, compareTo.other)) {
            return false;
        }
        return this.part == compareTo.part;
    }

    public String toString() {
        return this.toCpe23FS();
    }

    public int compareTo(Object o) {
        if (o instanceof ICpe) {
            ICpe otherObject = (ICpe)o;
            int before = -1;
            boolean equal = false;
            boolean after = true;
            if (this == otherObject) {
                return 0;
            }
            int r = this.getPart().getAbbreviation().compareTo(otherObject.getPart().getAbbreviation());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getVendor().compareTo(otherObject.getVendor());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getProduct().compareTo(otherObject.getProduct());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = Cpe.compareVersions(this.getVersion(), otherObject.getVersion());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getUpdate().compareTo(otherObject.getUpdate());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getEdition().compareTo(otherObject.getEdition());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getLanguage().compareTo(otherObject.getLanguage());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getSwEdition().compareTo(otherObject.getSwEdition());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getTargetSw().compareTo(otherObject.getTargetSw());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getTargetHw().compareTo(otherObject.getTargetHw());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            r = this.getOther().compareTo(otherObject.getOther());
            if (r < 0) {
                return -1;
            }
            if (r > 0) {
                return 1;
            }
            return 0;
        }
        throw new RuntimeException("Unable to compare " + o.getClass().getCanonicalName());
    }

    protected static int compareVersions(String left, String right) {
        int result = 0;
        List<String> subLeft = Cpe.splitVersion(left);
        List<String> subRight = Cpe.splitVersion(right);
        int subMax = subLeft.size() <= subRight.size() ? subLeft.size() : subRight.size();
        for (int x = 0; result == 0 && x < subMax; ++x) {
            if (Cpe.isPositiveInteger(subLeft.get(x)) && Cpe.isPositiveInteger(subRight.get(x))) {
                try {
                    result = Long.valueOf(subLeft.get(x)).compareTo(Long.valueOf(subRight.get(x)));
                }
                catch (NumberFormatException ex) {
                    if (!subLeft.get(x).equalsIgnoreCase(subRight.get(x))) {
                        result = subLeft.get(x).compareTo(subRight.get(x));
                    }
                }
            } else {
                result = subLeft.get(x).compareTo(subRight.get(x));
            }
            if (result == 0) continue;
            return result;
        }
        if (subLeft.size() > subRight.size()) {
            result = 1;
        }
        if (subRight.size() > subLeft.size()) {
            result = -1;
        }
        return result;
    }

    private static List<String> splitVersion(String s) {
        Pattern pattern = Pattern.compile("^([\\d]+?)(.*)$");
        String[] splitString = s.split("(\\.|:-)");
        ArrayList<String> res = new ArrayList<String>();
        for (String token : splitString) {
            if (token.matches("^[\\d]+?[A-z]+")) {
                Matcher matcher = pattern.matcher(token);
                matcher.find();
                String g1 = matcher.group(1);
                String g2 = matcher.group(2);
                res.add(g1);
                res.add(g2);
                continue;
            }
            res.add(token);
        }
        return res;
    }

    private static boolean isPositiveInteger(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.charAt(0) == '0' && str.length() > 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

